/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.util.database.spatial.rect.Rectangle2D;

public interface TraceAddressSnapRange
extends Rectangle2D<Address, Long, TraceAddressSnapRange> {
    public Range<Long> getLifespan();

    public AddressRange getRange();

    default public TraceAddressSnapRange getBounds() {
        return this;
    }

    default public Address getX1() {
        return this.getRange().getMinAddress();
    }

    default public Address getX2() {
        return this.getRange().getMaxAddress();
    }

    default public Long getY1() {
        return DBTraceUtils.lowerEndpoint(this.getLifespan());
    }

    default public Long getY2() {
        return DBTraceUtils.upperEndpoint(this.getLifespan());
    }

    default public TraceAddressSnapRange immutable(Address x1, Address x2, Long y1, Long y2) {
        return new ImmutableTraceAddressSnapRange(x1, x2, y1, y2);
    }

    default public String description() {
        return String.format("[%s:%x:%x]%s", this.getRange().getAddressSpace(), this.getX1().getOffset(), this.getX2().getOffset(), this.getLifespan());
    }
}

