/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.thread.TraceThread;
import java.util.Objects;

public class DefaultTraceLocation
implements TraceLocation {
    private final Trace trace;
    private final TraceThread thread;
    private final Range<Long> lifespan;
    private final Address address;

    public DefaultTraceLocation(Trace trace, TraceThread thread, Range<Long> lifespan, Address address) {
        this.trace = trace;
        this.thread = thread;
        this.lifespan = lifespan;
        this.address = address;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public Range<Long> getLifespan() {
        return this.lifespan;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        return "TraceLocation<" + this.trace + ": " + this.lifespan + "," + this.address + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTraceLocation)) {
            return false;
        }
        DefaultTraceLocation that = (DefaultTraceLocation)obj;
        if (this.trace != that.trace) {
            return false;
        }
        if (this.thread != that.thread) {
            return false;
        }
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        return Objects.equals(this.lifespan, that.lifespan);
    }

    public int hashCode() {
        return Objects.hash(this.trace, this.thread, this.lifespan, this.address);
    }

    @Override
    public int compareTo(TraceLocation that) {
        if (this == that) {
            return 0;
        }
        int result = this.trace.getName().compareTo(that.getTrace().getName());
        if (result != 0) {
            return result;
        }
        result = this.thread.getName().compareTo(that.getThread().getName());
        if (result != 0) {
            return result;
        }
        result = DBTraceUtils.compareRanges(this.getLifespan(), that.getLifespan());
        if (result != 0) {
            return result;
        }
        result = this.address.compareTo((Object)that.getAddress());
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

