/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewEquate;
import ghidra.trace.database.symbol.DBTraceEquate;
import ghidra.trace.database.symbol.DBTraceEquateManager;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBTraceProgramViewEquateTable
implements EquateTable {
    protected final DBTraceProgramView program;
    protected final DBTraceEquateManager equateManager;
    protected final Map<DBTraceEquate, DBTraceProgramViewEquate> cache = CacheBuilder.newBuilder().removalListener(this::equateRemoved).weakValues().build().asMap();

    public DBTraceProgramViewEquateTable(DBTraceProgramView program) {
        this.program = program;
        this.equateManager = program.trace.getEquateManager();
    }

    private void equateRemoved(RemovalNotification<DBTraceEquate, DBTraceProgramViewEquate> rn) {
    }

    public Equate createEquate(String name, long value) throws DuplicateNameException, InvalidInputException {
        try (LockHold hold = this.program.trace.lockWrite();){
            DBTraceEquate equate = this.equateManager.create(name, value);
            DBTraceProgramViewEquate view = new DBTraceProgramViewEquate(this.program, equate);
            this.cache.put(equate, view);
            DBTraceProgramViewEquate dBTraceProgramViewEquate = view;
            return dBTraceProgramViewEquate;
        }
    }

    public boolean removeEquate(String name) {
        try (LockHold hold = this.program.trace.lockWrite();){
            DBTraceEquate equate = this.equateManager.getByName(name);
            if (equate == null) {
                boolean bl = false;
                return bl;
            }
            this.cache.remove(equate);
            equate.delete();
            boolean bl = true;
            return bl;
        }
    }

    public void deleteAddressRange(Address start, Address end, TaskMonitor monitor) throws CancelledException {
        this.equateManager.clearReferences((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), (AddressRange)new AddressRangeImpl(start, end), monitor);
    }

    protected DBTraceProgramViewEquate doGetViewEquate(DBTraceEquate equate) {
        if (equate == null) {
            return null;
        }
        return this.cache.computeIfAbsent(equate, e -> new DBTraceProgramViewEquate(this.program, (DBTraceEquate)e));
    }

    public Equate getEquate(String name) {
        try (LockHold hold = this.program.trace.lockRead();){
            DBTraceProgramViewEquate dBTraceProgramViewEquate = this.doGetViewEquate(this.equateManager.getByName(name));
            return dBTraceProgramViewEquate;
        }
    }

    public Equate getEquate(Address reference, int opndPosition, long value) {
        try (LockHold hold = this.program.trace.lockRead();){
            TraceCodeUnit cu = this.program.getTopCode(reference, (space, s) -> space.definedUnits().getContaining((long)s, reference));
            if (cu == null) {
                Equate equate = null;
                return equate;
            }
            DBTraceProgramViewEquate dBTraceProgramViewEquate = this.doGetViewEquate(this.equateManager.getReferencedByValue(cu.getStartSnap(), reference, opndPosition, value));
            return dBTraceProgramViewEquate;
        }
    }

    public List<Equate> getEquates(Address reference, int opndPosition) {
        try (LockHold hold = this.program.trace.lockRead();){
            ArrayList<Equate> result = new ArrayList<Equate>();
            TraceCodeUnit cu = this.program.getTopCode(reference, (space, s) -> space.definedUnits().getContaining((long)s, reference));
            if (cu == null) {
                ArrayList<Equate> arrayList = result;
                return arrayList;
            }
            for (DBTraceEquate dBTraceEquate : this.equateManager.getReferenced(cu.getStartSnap(), reference, opndPosition)) {
                result.add(this.doGetViewEquate(dBTraceEquate));
            }
            ArrayList<Equate> arrayList = result;
            return arrayList;
        }
    }

    public List<Equate> getEquates(Address reference) {
        try (LockHold hold = this.program.trace.lockRead();){
            ArrayList<Equate> result = new ArrayList<Equate>();
            TraceCodeUnit cu = this.program.getTopCode(reference, (space, s) -> space.definedUnits().getContaining((long)s, reference));
            if (cu == null) {
                ArrayList<Equate> arrayList = result;
                return arrayList;
            }
            for (DBTraceEquate dBTraceEquate : this.equateManager.getReferenced(cu.getStartSnap(), reference)) {
                result.add(this.doGetViewEquate(dBTraceEquate));
            }
            ArrayList<Equate> arrayList = result;
            return arrayList;
        }
    }

    public AddressIterator getEquateAddresses() {
        return this.program.viewport.unionedAddresses(s -> this.equateManager.getReferringAddresses((Range<Long>)Range.singleton((Comparable)s))).getAddresses(true);
    }

    public List<Equate> getEquates(long value) {
        try (LockHold hold = this.program.trace.lockRead();){
            ArrayList<DBTraceProgramViewEquate> result = new ArrayList<DBTraceProgramViewEquate>();
            for (DBTraceEquate dBTraceEquate : this.equateManager.getByValue(value)) {
                result.add(this.doGetViewEquate(dBTraceEquate));
            }
            ArrayList<DBTraceProgramViewEquate> arrayList = result;
            return arrayList;
        }
    }

    public Iterator<Equate> getEquates() {
        return Iterators.transform(this.equateManager.getAll().iterator(), e -> this.doGetViewEquate((DBTraceEquate)e));
    }

    public AddressIterator getEquateAddresses(Address start) {
        return this.program.viewport.unionedAddresses(s -> this.equateManager.getReferringAddresses((Range<Long>)Range.singleton((Comparable)s))).getAddresses(start, true);
    }

    public AddressIterator getEquateAddresses(AddressSetView asv) {
        return new IntersectionAddressSetView(asv, this.program.viewport.unionedAddresses(s -> this.equateManager.getReferringAddresses((Range<Long>)Range.singleton((Comparable)s)))).getAddresses(true);
    }
}

