/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class IsolateVariableTask
extends RenameTask {
    private HighSymbol highSymbol;
    private HighFunction highFunction;
    private Function function;
    private SourceType srcType;
    private String originalName;
    private boolean nameIsReserved;
    private boolean instanceIsMapped;

    public IsolateVariableTask(PluginTool tool, Program program, DecompilerPanel panel, ClangToken token, HighSymbol sym, SourceType st) {
        super(tool, program, panel, token, "");
        Varnode vn;
        this.highSymbol = sym;
        this.highFunction = this.highSymbol.getHighFunction();
        this.function = this.highFunction.getFunction();
        this.srcType = st;
        this.originalName = this.highSymbol.getName();
        this.nameIsReserved = this.highSymbol.isNameLocked();
        this.instanceIsMapped = false;
        if (this.nameIsReserved && (vn = token.getVarnode()) != null) {
            boolean bl = this.instanceIsMapped = vn.getMergeGroup() == vn.getHigh().getRepresentative().getMergeGroup();
        }
        if (!this.nameIsReserved || this.instanceIsMapped) {
            this.oldName = this.originalName;
        }
    }

    @Override
    public String getTransactionName() {
        return "Name New Variable";
    }

    @Override
    public boolean isValid(String newNm) {
        this.newName = newNm;
        if (this.newName.equals(this.originalName)) {
            if (this.nameIsReserved && !this.instanceIsMapped) {
                this.errorMsg = "The name \"" + this.originalName + "\" is attached to another instance";
                return false;
            }
            return true;
        }
        LocalSymbolMap localSymbolMap = this.highFunction.getLocalSymbolMap();
        if (localSymbolMap.containsVariableWithName(this.newName) || IsolateVariableTask.isSymbolInFunction(this.function, this.newName)) {
            this.errorMsg = "Duplicate name";
            return false;
        }
        return true;
    }

    @Override
    public void commit() throws DuplicateNameException, InvalidInputException {
        Varnode vn = this.tokenAtCursor.getVarnode();
        try {
            HighVariable highVariable = this.highFunction.splitOutMergeGroup(vn.getHigh(), vn);
            this.highSymbol = highVariable.getSymbol();
        }
        catch (PcodeException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"New Variable Failed", (Object)e.getMessage());
            return;
        }
        DataType dataType = this.highSymbol.getDataType();
        if (Undefined.isUndefined((DataType)dataType)) {
            dataType = AbstractIntegerDataType.getUnsignedDataType((int)dataType.getLength(), (DataTypeManager)this.program.getDataTypeManager());
        }
        HighFunctionDBUtil.updateDBVariable((HighSymbol)this.highSymbol, (String)this.newName, (DataType)dataType, (SourceType)this.srcType);
    }
}

