/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.dbgmodel;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.impl.dbgeng.client.DebugClientImpl1;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.client.IDebugClient;
import agent.dbgmodel.dbgmodel.bridge.HostDataModelAccess;
import agent.dbgmodel.impl.dbgmodel.bridge.HostDataModelAccessInternal;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.lang.ref.Cleaner;

public class DbgModel {
    private static final Cleaner CLEANER = Cleaner.create();

    public static OpaqueCleanable releaseWhenPhantom(Object owner, IUnknown obj) {
        ReleaseCOMObject state = new ReleaseCOMObject(obj);
        return new OpaqueCleanable(state, CLEANER.register(owner, state));
    }

    public static OpaqueCleanable releaseWhenPhantom(Object owner, WinNT.HANDLE handle) {
        ReleaseHANDLE state = new ReleaseHANDLE(handle);
        return new OpaqueCleanable(state, CLEANER.register(owner, state));
    }

    private static HostDataModelAccess wrapClient(DebugClientInternal debugClient) {
        DebugClientImpl1 impl = (DebugClientImpl1)debugClient;
        IDebugClient jnaClient = impl.getJNAClient();
        HostDataModelAccessInternal hostDataModelAccess = HostDataModelAccessInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)jnaClient).QueryInterface(arg_0, arg_1));
        hostDataModelAccess.setClient((DebugClient)debugClient);
        hostDataModelAccess.getDataModel();
        return hostDataModelAccess;
    }

    public static HostDataModelAccess debugConnect(String remoteOptions) {
        DbgModel.addSearchPaths();
        WString options = new WString(remoteOptions);
        return DbgModel.wrapClient(DebugClientInternal.tryPreferredInterfaces((refiid, ppClient) -> DbgEngNative.INSTANCE.DebugConnectWide(options, refiid, ppClient)));
    }

    public static HostDataModelAccess debugCreate() {
        DbgModel.addSearchPaths();
        return DbgModel.wrapClient(DebugClientInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((DbgEngNative)DbgEngNative.INSTANCE).DebugCreate(arg_0, arg_1)));
    }

    public static HostDataModelAccess debugCreate(int options) {
        DbgModel.addSearchPaths();
        WinDef.DWORD dwOpts = new WinDef.DWORD((long)options);
        return DbgModel.wrapClient(DebugClientInternal.tryPreferredInterfaces((refiid, ppClient) -> DbgEngNative.INSTANCE.DebugCreateEx(refiid, dwOpts, ppClient)));
    }

    private static void addSearchPaths() {
    }

    public static class OpaqueCleanable {
        private final Object state;
        private final Cleaner.Cleanable cleanable;

        public OpaqueCleanable(Object state, Cleaner.Cleanable cleanable) {
            this.state = state;
            this.cleanable = cleanable;
        }
    }

    private static class ReleaseHANDLE
    implements Runnable {
        private final WinNT.HANDLE handle;

        public ReleaseHANDLE(WinNT.HANDLE handle) {
            this.handle = handle;
        }

        @Override
        public void run() {
            Kernel32Util.closeHandle((WinNT.HANDLE)this.handle);
        }
    }

    private static class ReleaseCOMObject
    implements Runnable {
        private final IUnknown obj;

        ReleaseCOMObject(IUnknown obj) {
            this.obj = obj;
        }

        @Override
        public void run() {
            try {
                this.obj.Release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

