/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.util.SystemUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FSRL {
    public static final String PARAM_MD5 = "MD5";
    protected final FSRL parent;
    protected final String path;
    private final String md5;

    public static FSRL fromString(String fsrlStr) throws MalformedURLException {
        return FSRL.fromString(null, fsrlStr);
    }

    public static FSRL fromString(FSRL parent, String fsrlStr) throws MalformedURLException {
        String[] partStrs;
        for (String partStr : partStrs = fsrlStr.trim().split("\\|")) {
            FSRL fsrl;
            parent = fsrl = FSRL.fromPartString(parent, partStr);
        }
        return parent;
    }

    public static FSRL convertRootToContainer(FSRL fsrl) {
        return fsrl instanceof FSRLRoot && fsrl.getFS().hasContainer() ? fsrl.getFS().getContainer() : fsrl;
    }

    private static FSRL fromPartString(FSRL containerFile, String partStr) throws MalformedURLException {
        int colonSlashSlash = (partStr = partStr.trim()).indexOf("://");
        if (colonSlashSlash <= 0) {
            throw new MalformedURLException("Missing protocol in " + partStr);
        }
        String proto = partStr.substring(0, colonSlashSlash);
        String path = partStr.substring(colonSlashSlash + 3);
        int paramStart = path.indexOf("?");
        String md5 = null;
        if (paramStart >= 0) {
            String params = path.substring(paramStart + 1);
            path = path.substring(0, paramStart);
            Map<String, String> paramMap = FSRL.getParamMapFromString(params);
            md5 = paramMap.get(PARAM_MD5);
        }
        FSRLRoot fsRoot = FSRLRoot.nestedFS(containerFile, proto);
        String decodedPath = FSUtilities.escapeDecode(path);
        if ((decodedPath = decodedPath.replace('\\', '/')).isEmpty()) {
            decodedPath = null;
        }
        return new FSRL(fsRoot, decodedPath, md5);
    }

    private static Map<String, String> getParamMapFromString(String paramsStr) throws MalformedURLException {
        String[] fields;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String field : fields = paramsStr.split("&")) {
            int equalIdx = field.indexOf(61);
            String name = equalIdx > 0 ? field.substring(0, equalIdx) : "";
            String value = equalIdx >= 0 ? field.substring(equalIdx + 1) : field;
            name = FSUtilities.escapeDecode(name);
            value = FSUtilities.escapeDecode(value);
            paramMap.put(name, value);
        }
        return paramMap;
    }

    protected FSRL(FSRL parent, String path) {
        this(parent, path, null);
    }

    protected FSRL(FSRL parent, String path, String md5) {
        this.parent = parent;
        this.path = path;
        this.md5 = md5;
    }

    public FSRLRoot getFS() {
        return (FSRLRoot)this.parent;
    }

    public int getNestingDepth() {
        int depth = 0;
        FSRLRoot root = this.getFS();
        while (root != null) {
            ++depth;
            root = root.hasContainer() ? root.getContainer().getFS() : null;
        }
        return depth;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.path == null) {
            return null;
        }
        int cp = this.path.lastIndexOf(47);
        return cp >= 0 ? this.path.substring(cp + 1) : this.path;
    }

    public String getName(int nestedDepth) throws IOException {
        FSRL current = this;
        for (int depth = 0; depth < nestedDepth; ++depth) {
            FSRL parentContainer = current.getFS().getContainer();
            if (parentContainer == null) {
                throw new IOException("Unknown requested FSRL parent, requested depth " + nestedDepth + ", only " + this.getNestingDepth() + " available in " + this.toString());
            }
            current = parentContainer;
        }
        return current.getName();
    }

    public String getMD5() {
        return this.md5;
    }

    public boolean isMD5Equal(String otherMD5) {
        if (this.md5 == null) {
            return otherMD5 == null;
        }
        return this.md5.equalsIgnoreCase(otherMD5);
    }

    public FSRL withMD5(String newMD5) {
        return Objects.equals(this.md5, newMD5) ? this : new FSRL(this.getFS(), this.path, newMD5);
    }

    public FSRL withPath(String newpath) {
        return new FSRL(this.getFS(), newpath);
    }

    public FSRL withPath(FSRL copyPath) {
        return new FSRL(this.getFS(), copyPath.getPath(), copyPath.getMD5());
    }

    public FSRL appendPath(String relPath) {
        String basePath = this.getPath();
        return new FSRL(this.getFS(), FSUtilities.appendPath(basePath == null ? "/" : basePath, relPath));
    }

    public FSRLRoot makeNested(String fstype) {
        return FSRLRoot.nestedFS(this, fstype);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb, true, true, true);
        return sb.toString();
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb, true, false, true);
        return sb.toString();
    }

    public String toPrettyFullpathString() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb, true, false, false);
        return sb.toString();
    }

    protected void appendToStringBuilder(StringBuilder sb, boolean recurse, boolean includeParams, boolean includeFSRoot) {
        this.parent.appendToStringBuilder(sb, recurse, includeParams, includeFSRoot);
        if (this.path != null) {
            sb.append(FSUtilities.escapeEncode(this.path));
        }
        if (this.md5 != null && includeParams) {
            sb.append("?").append(PARAM_MD5).append("=").append(this.md5);
        }
    }

    public String toStringPart() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb, false, true, true);
        return sb.toString();
    }

    public List<FSRL> split() {
        ArrayList<FSRL> result = new ArrayList<FSRL>();
        FSRL current = this;
        while (current != null) {
            result.add(0, current);
            current = current.getFS().getContainer();
        }
        return result;
    }

    public boolean isEquivalent(String fsrlStr) {
        if (fsrlStr == null) {
            return false;
        }
        String s = this.toString();
        return s.equals(fsrlStr) || this.getMD5() != null && s.startsWith(fsrlStr) && s.substring(fsrlStr.length()).startsWith("?MD5=") && s.length() == fsrlStr.length() + 37 || this.getMD5() == null && fsrlStr.startsWith(s) && fsrlStr.substring(s.length()).startsWith("?MD5=") && fsrlStr.length() == s.length() + 37;
    }

    public boolean isEquivalent(FSRL other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.isEquivalent(other.parent)) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    public boolean isDescendantOf(FSRL potentialParent) {
        if (this.isEquivalent(potentialParent)) {
            return false;
        }
        List<FSRL> split = this.split();
        for (int i = split.size() - 1; i >= 0; --i) {
            FSRL myPart = split.get(i);
            if (!myPart.getFS().equals(potentialParent.getFS()) || !SystemUtilities.isEqual((Object)myPart.getPath(), (Object)potentialParent.getPath()) && !FSRL.isParentPath(potentialParent.getPath(), myPart.getPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean isParentPath(String parent, String child) {
        return child.startsWith(parent) && child.length() > parent.length() && (parent.endsWith("/") || child.charAt(parent.length()) == '/');
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.md5 == null ? 0 : this.md5.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FSRL)) {
            return false;
        }
        FSRL other = (FSRL)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.md5 == null ? other.md5 != null : !this.md5.equals(other.md5));
    }
}

