/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.ResourceDataDirectory;
import ghidra.app.util.bin.format.pe.resource.ResourceDataEntry;
import ghidra.app.util.bin.format.pe.resource.ResourceDirectory;
import ghidra.app.util.bin.format.pe.resource.ResourceDirectoryStringU;
import ghidra.app.util.bin.format.pe.resource.ResourceInfo;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResourceDirectoryEntry
implements StructConverter {
    private static final String NAME = "IMAGE_RESOURCE_DIRECTORY_ENTRY";
    public static final int SIZEOF = 8;
    private boolean isNameEntry;
    private boolean isFirstLevel;
    private ResourceDirectoryStringU dirString;
    private ResourceDirectory subDirectory;
    private ResourceDataEntry data;
    private int nameOffset;
    private boolean nameIsString;
    private int name;
    private int id;
    private int offsetToData;
    private int offsetToDirectory;
    private boolean dataIsDirectory;
    private boolean isValid;

    /*
     * Enabled aggressive block sorting
     */
    public ResourceDirectoryEntry(FactoryBundledWithBinaryReader reader, int index, int resourceBase, boolean isNameEntry, boolean isFirstLevel, NTHeader ntHeader) throws IOException {
        block9: {
            this.isNameEntry = isNameEntry;
            this.isFirstLevel = isFirstLevel;
            int irde1 = reader.readInt(index);
            int irde2 = reader.readInt(index + 4);
            this.nameOffset = irde1 & Integer.MAX_VALUE;
            boolean bl = this.nameIsString = (irde1 & Integer.MIN_VALUE) != 0;
            if (this.nameOffset < 0) {
                Msg.error((Object)this, (Object)("Invalid nameOffset " + this.nameOffset));
                return;
            }
            this.name = irde1;
            this.id = irde1 & 0xFFFF;
            this.offsetToData = irde2;
            this.offsetToDirectory = irde2 & Integer.MAX_VALUE;
            boolean bl2 = this.dataIsDirectory = (irde2 & Integer.MIN_VALUE) != 0;
            if (this.nameIsString) {
                int nameptr = this.nameOffset + resourceBase;
                if (ntHeader.checkRVA(nameptr) || 0 < nameptr && (long)nameptr < reader.length()) {
                    this.dirString = new ResourceDirectoryStringU(reader, nameptr);
                } else {
                    Msg.error((Object)this, (Object)("Invalid nameOffset " + Integer.toHexString(this.nameOffset)));
                    return;
                }
            }
            if (this.dataIsDirectory) {
                int dirptr = this.offsetToDirectory + resourceBase;
                if (ntHeader.checkRVA(dirptr) || 0 < dirptr && (long)dirptr < reader.length()) {
                    this.subDirectory = new ResourceDirectory(reader, dirptr, resourceBase, false, ntHeader);
                    break block9;
                } else {
                    Msg.error((Object)this, (Object)("Invalid offsetToDirectory " + Integer.toHexString(this.offsetToDirectory)));
                    return;
                }
            }
            int dataptr = this.offsetToData + resourceBase;
            if (ntHeader.checkRVA(dataptr) || 0 < dataptr && (long)dataptr < reader.length()) {
                this.data = new ResourceDataEntry(reader, dataptr);
            } else {
                Msg.error((Object)this, (Object)("Invalid offsetToData " + Integer.toHexString(this.offsetToData)));
                return;
            }
        }
        this.isValid = true;
    }

    public List<ResourceInfo> getResources(int level) {
        ArrayList<ResourceInfo> resources = new ArrayList<ResourceInfo>();
        if (this.data != null) {
            resources.add(new ResourceInfo(this.data.getOffsetToData(), this.toString(), this.data.getSize()));
        }
        if (this.subDirectory != null) {
            List<ResourceDirectoryEntry> entries = this.subDirectory.getEntries();
            for (ResourceDirectoryEntry entry : entries) {
                List<ResourceInfo> entryResources = entry.getResources(level + 1);
                for (ResourceInfo info : entryResources) {
                    resources.add(info);
                    info.setName(this.toString() + "_" + info.getName());
                    if (this.isNameEntry) continue;
                    if (level == 0) {
                        info.setTypeID(this.id);
                        continue;
                    }
                    if (level != 1) continue;
                    info.setID(this.id);
                }
            }
        }
        return resources;
    }

    public boolean isNameEntry() {
        return this.isNameEntry;
    }

    public ResourceDirectoryStringU getDirectoryString() {
        return this.dirString;
    }

    public ResourceDataEntry getData() {
        return this.data;
    }

    public ResourceDirectory getSubDirectory() {
        return this.subDirectory;
    }

    public String toString() {
        if (this.isNameEntry && this.dirString != null) {
            return this.dirString.getNameString();
        }
        if (!this.isNameEntry && this.isFirstLevel && this.id <= 24) {
            return ResourceDataDirectory.PREDEFINED_RESOURCE_NAMES[this.id];
        }
        return Integer.toHexString(this.id);
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public boolean getNameIsString() {
        return this.nameIsString;
    }

    public int getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getOffsetToData() {
        return this.offsetToData;
    }

    public int getOffsetToDirectory() {
        return this.offsetToDirectory;
    }

    public boolean getDataIsDirectory() {
        return this.dataIsDirectory;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType nameStruct = new StructureDataType("IMAGE_RESOURCE_DIRECTORY_ENTRY_NameStruct", 0);
        nameStruct.add(DWORD, "NameOffset", null);
        nameStruct.add(DWORD, "NameIsString", null);
        nameStruct.setCategoryPath(new CategoryPath("/PE"));
        UnionDataType union1 = new UnionDataType("IMAGE_RESOURCE_DIRECTORY_ENTRY_NameUnion");
        union1.add((DataType)nameStruct, nameStruct.getName(), null);
        union1.add(DWORD, "Name", null);
        union1.add(WORD, "Id", null);
        union1.setCategoryPath(new CategoryPath("/PE"));
        StructureDataType offsetStruct = new StructureDataType("IMAGE_RESOURCE_DIRECTORY_ENTRY_DirectoryStruct", 0);
        offsetStruct.add(DWORD, "OffsetToDirectory", null);
        offsetStruct.add(DWORD, "DataIsDirectory", null);
        UnionDataType union2 = new UnionDataType("IMAGE_RESOURCE_DIRECTORY_ENTRY_DirectoryUnion");
        union2.add(DWORD, "OffsetToData", null);
        union2.add((DataType)offsetStruct, offsetStruct.getName(), null);
        UnionDataType union3 = new UnionDataType(NAME);
        union3.add((DataType)union1, "NameUnion", null);
        union3.add((DataType)union2, "DirectoryUnion", null);
        union3.setCategoryPath(new CategoryPath("/PE"));
        return union3;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

