/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliSigAssemblyRef
extends CliAbstractSig {
    byte[] content;

    public CliSigAssemblyRef(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = blob.getContentsReader();
        this.content = reader.readNextByteArray(this.contentsSize);
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add((DataType)new ArrayDataType(BYTE, this.contentsSize, 1), "", "AssemblyRef Content");
        return struct;
    }

    @Override
    public String getContentsName() {
        return "AssemblyRefSig";
    }

    @Override
    public String getContentsComment() {
        return "Data stored in an AssemblyRef blob";
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        return this.content.toString();
    }
}

