/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.DefaultDataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeMarkupable;
import ghidra.app.util.bin.format.pe.cli.CliMetadataDirectory;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodDef;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ImageCor20Header
implements StructConverter,
PeMarkupable {
    private static final String NAME = "IMAGE_COR20_HEADER";
    private int cb;
    private short majorRuntimeVersion;
    private short minorRuntimeVersion;
    private CliMetadataDirectory metadata;
    private int flags;
    private int entryPointToken;
    private Address entryPointVA;
    private DefaultDataDirectory resources;
    private DefaultDataDirectory strongNameSignature;
    private DefaultDataDirectory codeManagerTable;
    private DefaultDataDirectory vTableFixups;
    private DefaultDataDirectory exportAddressTableJumps;
    private DefaultDataDirectory managedNativeHeader;

    static ImageCor20Header createImageCor20Header(FactoryBundledWithBinaryReader reader, long index, NTHeader ntHeader) throws IOException {
        ImageCor20Header imageCor20Header = (ImageCor20Header)reader.getFactory().create(ImageCor20Header.class, new Object[0]);
        imageCor20Header.initIMAGE_COR20_HEADER(reader, index, ntHeader);
        return imageCor20Header;
    }

    private void initIMAGE_COR20_HEADER(FactoryBundledWithBinaryReader reader, long index, NTHeader ntHeader) throws IOException {
        long origIndex = reader.getPointerIndex();
        reader.setPointerIndex(index);
        this.cb = reader.readNextInt();
        this.majorRuntimeVersion = reader.readNextShort();
        this.minorRuntimeVersion = reader.readNextShort();
        this.metadata = CliMetadataDirectory.createCliMetadataDirectory(ntHeader, reader);
        this.flags = reader.readNextInt();
        this.entryPointToken = reader.readNextInt();
        this.resources = DefaultDataDirectory.createDefaultDataDirectory(ntHeader, reader);
        this.strongNameSignature = DefaultDataDirectory.createDefaultDataDirectory(ntHeader, reader);
        this.codeManagerTable = DefaultDataDirectory.createDefaultDataDirectory(ntHeader, reader);
        this.vTableFixups = DefaultDataDirectory.createDefaultDataDirectory(ntHeader, reader);
        this.exportAddressTableJumps = DefaultDataDirectory.createDefaultDataDirectory(ntHeader, reader);
        this.managedNativeHeader = DefaultDataDirectory.createDefaultDataDirectory(ntHeader, reader);
        reader.setPointerIndex(origIndex);
    }

    public boolean parse() throws IOException {
        boolean success = true;
        success &= this.metadata.parse();
        success &= this.resources.parse();
        success &= this.strongNameSignature.parse();
        success &= this.codeManagerTable.parse();
        success &= this.vTableFixups.parse();
        success &= this.exportAddressTableJumps.parse();
        return success &= this.managedNativeHeader.parse();
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException, MemoryAccessException {
        if (!this.metadata.hasParsedCorrectly()) {
            return;
        }
        this.metadata.markup(program, isBinary, monitor, log, ntHeader);
        if (this.entryPointToken > 0) {
            try {
                if ((this.flags & 0x10) == 16) {
                    program.getSymbolTable().addExternalEntryPoint(program.getImageBase().add((long)this.entryPointToken));
                } else {
                    CliStreamMetadata stream = (CliStreamMetadata)this.metadata.getMetadataRoot().getStreamHeader(CliStreamMetadata.getName()).getStream();
                    CliTableMethodDef.CliMethodDefRow row = (CliTableMethodDef.CliMethodDefRow)stream.getTable((this.entryPointToken & 0xFF000000) >> 24).getRow(this.entryPointToken & 0xFFFFFF);
                    program.getSymbolTable().addExternalEntryPoint(program.getImageBase().add((long)row.RVA));
                    this.entryPointVA = program.getImageBase().add((long)row.RVA);
                }
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new DWordDataType(), "cb", "Size of the structure");
        struct.add((DataType)new WordDataType(), "MajorRuntimeVersion", "Version of CLR Runtime");
        struct.add((DataType)new WordDataType(), "MinorRuntimeVersion", null);
        struct.add(this.metadata.toDataType(), "MetaData", "RVA and size of MetaData");
        struct.add((DataType)new ImageCor20Flags(), "Flags", null);
        struct.add((DataType)new DWordDataType(), "EntryPointToken", "This is a metadata token if not a valid RVA");
        struct.add(this.resources.toDataType(), "Resources", null);
        struct.add(this.strongNameSignature.toDataType(), "StrongNameSignature", null);
        struct.add(this.codeManagerTable.toDataType(), "CodeManagerTable", "Should be 0");
        struct.add(this.vTableFixups.toDataType(), "VTableFixups", null);
        struct.add(this.exportAddressTableJumps.toDataType(), "ExportAddressTableJumps", "Should be 0");
        struct.add(this.managedNativeHeader.toDataType(), "ManagedNativeHeader", "0 unless this is a native image");
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public int getCb() {
        return this.cb;
    }

    public short getMajorRuntimeVersion() {
        return this.majorRuntimeVersion;
    }

    public short getMinorRuntimeVersion() {
        return this.minorRuntimeVersion;
    }

    public CliMetadataDirectory getMetadata() {
        return this.metadata;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getEntryPointToken() {
        return this.entryPointToken;
    }

    public Address getEntryPointVA() {
        return this.entryPointVA;
    }

    public DefaultDataDirectory getResources() {
        return this.resources;
    }

    public DefaultDataDirectory getStrongNameSignature() {
        return this.strongNameSignature;
    }

    public DefaultDataDirectory getCodeManagerTable() {
        return this.codeManagerTable;
    }

    public DefaultDataDirectory getVTableFixups() {
        return this.vTableFixups;
    }

    public DefaultDataDirectory getExportAddressTableJumps() {
        return this.exportAddressTableJumps;
    }

    public DefaultDataDirectory getManagedNativeHeader() {
        return this.managedNativeHeader;
    }

    public static class ImageCor20Flags
    extends EnumDataType {
        public static final String PATH = "/PE/CLI/Flags";
        public static final int COMIMAGE_FLAGS_ILONLY = 1;
        public static final int COMIMAGE_FLAGS_32BITREQUIRED = 2;
        public static final int COMIMAGE_FLAGS_IL_LIBRARY = 4;
        public static final int COMIMAGE_FLAGS_STRONGNAMESIGNED = 8;
        public static final int COMIMAGE_FLAGS_NATIVE_ENTRYPOINT = 16;
        public static final int COMIMAGE_FLAGS_TRACKDEBUGDATA = 65536;

        public ImageCor20Flags() {
            super(new CategoryPath(PATH), "COR20_Flags", 4);
            String prefix = "COMIMAGE_FLAGS_";
            this.add(prefix + "ILONLY", 1L);
            this.add(prefix + "32BITREQUIRED", 2L);
            this.add(prefix + "IL_LIBRARY", 4L);
            this.add(prefix + "STRONGNAMESIGNED", 8L);
            this.add(prefix + "NATIVE_ENTRYPOINT", 16L);
            this.add(prefix + "TRACKDEBUGDATA", 65536L);
        }
    }
}

