/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheRangeEntry
implements StructConverter {
    private long startAddress;
    private int size;
    private int imageIndex;

    public DyldCacheRangeEntry(BinaryReader reader) throws IOException {
        this.startAddress = reader.readNextLong();
        this.size = reader.readNextInt();
        this.imageIndex = reader.readNextInt();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_range_entry", 0);
        struct.add(QWORD, "startAddress", "");
        struct.add(DWORD, "size", "");
        struct.add(DWORD, "imageIndex", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

