/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheAccelerateInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageTextInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheHeader
implements StructConverter {
    private byte[] magic;
    private int mappingOffset;
    private int mappingCount;
    private int imagesOffset;
    private int imagesCount;
    private long dyldBaseAddress;
    private long codeSignatureOffset;
    private long codeSignatureSize;
    private long slideInfoOffset;
    private long slideInfoSize;
    private long localSymbolsOffset;
    private long localSymbolsSize;
    private byte[] uuid;
    private long cacheType;
    private int branchPoolsOffset;
    private int branchPoolsCount;
    private long accelerateInfoAddr;
    private long accelerateInfoSize;
    private long imagesTextOffset;
    private long imagesTextCount;
    private long patchInfoAddr;
    private long patchInfoSize;
    private long otherImageGroupAddrUnused;
    private long otherImageGroupSizeUnused;
    private long progClosuresAddr;
    private long progClosuresSize;
    private long progClosuresTrieAddr;
    private long progClosuresTrieSize;
    private int platform;
    private int dyld_info;
    private int formatVersion;
    private boolean dylibsExpectedOnDisk;
    private boolean simulator;
    private boolean locallyBuiltCache;
    private boolean builtFromChainedFixups;
    private int padding;
    private long sharedRegionStart;
    private long sharedRegionSize;
    private long maxSlide;
    private long dylibsImageArrayAddr;
    private long dylibsImageArraySize;
    private long dylibsTrieAddr;
    private long dylibsTrieSize;
    private long otherImageArrayAddr;
    private long otherImageArraySize;
    private long otherTrieAddr;
    private long otherTrieSize;
    private int mappingWithSlideOffset;
    private int mappingWithSlideCount;
    private int headerType;
    private int headerSize;
    private BinaryReader reader;
    private long baseAddress;
    private List<DyldCacheMappingInfo> mappingInfoList;
    private List<DyldCacheImageInfo> imageInfoList;
    private List<DyldCacheSlideInfoCommon> slideInfoList;
    private DyldCacheLocalSymbolsInfo localSymbolsInfo;
    private List<Long> branchPoolList;
    private DyldCacheAccelerateInfo accelerateInfo;
    private List<DyldCacheImageTextInfo> imageTextInfoList;
    private DyldArchitecture architecture;
    private List<DyldCacheMappingAndSlideInfo> cacheMappingAndSlideInfoList;

    public DyldCacheHeader(BinaryReader reader) throws IOException {
        this.reader = reader;
        long startIndex = reader.getPointerIndex();
        this.headerType = 1;
        this.magic = reader.readNextByteArray(16);
        this.mappingOffset = reader.readNextInt();
        this.mappingCount = reader.readNextInt();
        this.imagesOffset = reader.readNextInt();
        this.imagesCount = reader.readNextInt();
        this.dyldBaseAddress = reader.readNextLong();
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.headerType = 2;
            this.codeSignatureOffset = reader.readNextLong();
            this.codeSignatureSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.slideInfoOffset = reader.readNextLong();
            this.slideInfoSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.headerType = 3;
            this.localSymbolsOffset = reader.readNextLong();
            this.localSymbolsSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.headerType = 4;
            this.uuid = reader.readNextByteArray(16);
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.headerType = 5;
            this.cacheType = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.headerType = 6;
            this.branchPoolsOffset = reader.readNextInt();
            this.branchPoolsCount = reader.readNextInt();
            this.accelerateInfoAddr = reader.readNextLong();
            this.accelerateInfoSize = reader.readNextLong();
            this.imagesTextOffset = reader.readNextLong();
            this.imagesTextCount = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.headerType = 7;
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.patchInfoAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.patchInfoSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageGroupAddrUnused = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageGroupSizeUnused = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresTrieSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.platform = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dyld_info = reader.readNextInt();
            this.formatVersion = this.dyld_info & 0xFF;
            this.dylibsExpectedOnDisk = (this.dyld_info >>> 8 & 1) == 1;
            this.simulator = (this.dyld_info >>> 9 & 1) == 1;
            this.locallyBuiltCache = (this.dyld_info >> 10 & 1) == 1;
            this.builtFromChainedFixups = (this.dyld_info >> 11 & 1) == 1;
            this.padding = this.dyld_info >> 12 & 0xFFFFF;
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.sharedRegionStart = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.sharedRegionSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.maxSlide = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsImageArrayAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsImageArraySize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsTrieSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageArrayAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageArraySize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherTrieSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.mappingWithSlideOffset = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.mappingWithSlideCount = reader.readNextInt();
        }
        this.headerSize = (int)(reader.getPointerIndex() - startIndex);
        this.baseAddress = reader.readLong(this.mappingOffset);
        this.architecture = DyldArchitecture.getArchitecture(new String(this.magic).trim());
        this.mappingInfoList = new ArrayList<DyldCacheMappingInfo>(this.mappingCount);
        this.cacheMappingAndSlideInfoList = new ArrayList<DyldCacheMappingAndSlideInfo>(this.mappingWithSlideCount);
        this.slideInfoList = new ArrayList<DyldCacheSlideInfoCommon>();
        this.imageInfoList = new ArrayList<DyldCacheImageInfo>(this.imagesCount);
        this.branchPoolList = new ArrayList<Long>(this.branchPoolsCount);
        this.imageTextInfoList = new ArrayList<DyldCacheImageTextInfo>();
    }

    public void parseFromFile(boolean parseSymbols, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.headerType >= 1) {
            this.parseMappingInfo(log, monitor);
            this.parseImageInfo(log, monitor);
        }
        if (this.headerType >= 3 && parseSymbols) {
            this.parseLocalSymbolsInfo(log, monitor);
        }
        if (this.headerType >= 6) {
            this.parseBranchPools(log, monitor);
            this.parseImageTextInfo(log, monitor);
        }
        this.parseCacheMappingSlideInfo(log, monitor);
        if (this.haSlideInfo()) {
            this.parseSlideInfos(log, monitor);
        }
    }

    private void parseSlideInfos(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.slideInfoOffset != 0L) {
            DyldCacheSlideInfoCommon slideInfo = this.parseSlideInfo(this.slideInfoOffset, log, monitor);
            if (slideInfo != null) {
                this.slideInfoList.add(slideInfo);
            }
        } else if (this.cacheMappingAndSlideInfoList.size() > 0) {
            int listLen = this.cacheMappingAndSlideInfoList.size();
            DyldCacheMappingAndSlideInfo linkEditInfo = this.cacheMappingAndSlideInfoList.get(listLen - 1);
            for (DyldCacheMappingAndSlideInfo info : this.cacheMappingAndSlideInfoList) {
                if (info.getSlideInfoFileOffset() == 0L) continue;
                long offsetInEditRegion = info.getSlideInfoFileOffset() - linkEditInfo.getSlideInfoFileOffset();
                DyldCacheSlideInfoCommon slideInfo = this.parseSlideInfo(info.getSlideInfoFileOffset(), log, monitor);
                this.slideInfoList.add(slideInfo);
            }
        }
    }

    private void parseCacheMappingSlideInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD cache mapping and slide info...");
        monitor.initialize((long)this.mappingWithSlideCount);
        try {
            if (this.mappingWithSlideCount <= 0) {
                return;
            }
            this.reader.setPointerIndex(this.mappingWithSlideOffset);
            for (int i = 0; i < this.mappingWithSlideCount; ++i) {
                this.cacheMappingAndSlideInfoList.add(new DyldCacheMappingAndSlideInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_mapping_info.");
        }
    }

    public void parseFromMemory(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.headerType >= 6) {
            this.parseAcceleratorInfo(program, space, log, monitor);
        }
    }

    public void markup(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (this.headerType >= 1) {
            this.markupHeader(program, space, monitor, log);
            this.markupMappingInfo(program, space, monitor, log);
            this.markupImageInfo(program, space, monitor, log);
        }
        if (this.headerType >= 2) {
            this.markupCodeSignature(program, space, monitor, log);
            this.markupSlideInfo(program, space, monitor, log);
        }
        if (this.headerType >= 3) {
            this.markupLocalSymbolsInfo(program, space, monitor, log);
        }
        if (this.headerType >= 6) {
            this.markupBranchPools(program, space, monitor, log);
            this.markupAcceleratorInfo(program, space, monitor, log);
            this.markupImageTextInfo(program, space, monitor, log);
        }
        if (this.mappingWithSlideOffset >= 0) {
            this.markupCacheMappingSlideInfo(program, space, log, monitor);
        }
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public List<DyldCacheMappingInfo> getMappingInfos() {
        return this.mappingInfoList;
    }

    public int getImagesOffset() {
        return this.imagesOffset;
    }

    public int getImagesCount() {
        return this.imagesCount;
    }

    public List<DyldCacheImage> getMappedImages() {
        ArrayList<DyldCacheImage> images = new ArrayList<DyldCacheImage>();
        if (this.imageInfoList.size() > 0) {
            images.addAll(this.imageInfoList);
        } else {
            block0: for (DyldCacheImageTextInfo imageTextInfo : this.imageTextInfoList) {
                for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
                    if (!mappingInfo.contains(imageTextInfo.getAddress())) continue;
                    images.add(imageTextInfo);
                    continue block0;
                }
            }
        }
        return images;
    }

    public List<DyldCacheMappingAndSlideInfo> getCacheMappingAndSlideInfos() {
        return this.cacheMappingAndSlideInfoList;
    }

    public DyldCacheLocalSymbolsInfo getLocalSymbolsInfo() {
        return this.localSymbolsInfo;
    }

    public List<DyldCacheSlideInfoCommon> getSlideInfos() {
        return this.slideInfoList;
    }

    public List<Long> getBranchPoolAddresses() {
        return this.branchPoolList;
    }

    public DyldArchitecture getArchitecture() {
        return this.architecture;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_header", 0);
        this.addHeaderField(struct, (DataType)new ArrayDataType(ASCII, 16, 1), "magic", "e.g. \"dyld_v0    i386\"");
        this.addHeaderField(struct, DWORD, "mappingOffset", "file offset to first dyld_cache_mapping_info");
        this.addHeaderField(struct, DWORD, "mappingCount", "number of dyld_cache_mapping_info entries");
        this.addHeaderField(struct, DWORD, "imagesOffset", "file offset to first dyld_cache_image_info");
        this.addHeaderField(struct, DWORD, "imagesCount", "number of dyld_cache_image_info entries");
        this.addHeaderField(struct, QWORD, "dyldBaseAddress", "base address of dyld when cache was built");
        this.addHeaderField(struct, QWORD, "codeSignatureOffset", "file offset of code signature blob");
        this.addHeaderField(struct, QWORD, "codeSignatureSize", "size of code signature blob (zero means to end of file)");
        this.addHeaderField(struct, QWORD, "slideInfoOffset", "file offset of kernel slid info");
        this.addHeaderField(struct, QWORD, "slideInfoSize", "size of kernel slid info");
        this.addHeaderField(struct, QWORD, "localSymbolsOffset", "file offset of where local symbols are stored");
        this.addHeaderField(struct, QWORD, "localSymbolsSize", "size of local symbols information");
        this.addHeaderField(struct, (DataType)new ArrayDataType(BYTE, 16, 1), "uuid", "unique value for each shared cache file");
        this.addHeaderField(struct, QWORD, "cacheType", "0 for development, 1 for production");
        this.addHeaderField(struct, DWORD, "branchPoolsOffset", "file offset to table of uint64_t pool addresses");
        this.addHeaderField(struct, DWORD, "branchPoolsCount", "number of uint64_t entries");
        this.addHeaderField(struct, QWORD, "accelerateInfoAddr", "(unslid) address of optimization info");
        this.addHeaderField(struct, QWORD, "accelerateInfoSize", "size of optimization info");
        this.addHeaderField(struct, QWORD, "imagesTextOffset", "file offset to first dyld_cache_image_text_info");
        this.addHeaderField(struct, QWORD, "imagesTextCount", "number of dyld_cache_image_text_info entries");
        this.addHeaderField(struct, QWORD, "patchInfoAddr", "(unslid) address of dyld_cache_patch_info");
        this.addHeaderField(struct, QWORD, "patchInfoSize", "Size of all of the patch information pointed to via the dyld_cache_patch_info");
        this.addHeaderField(struct, QWORD, "otherImageGroupAddrUnused", "unused");
        this.addHeaderField(struct, QWORD, "otherImageGroupSizeUnused", "unused");
        this.addHeaderField(struct, QWORD, "progClosuresAddr", "(unslid) address of list of program launch closures");
        this.addHeaderField(struct, QWORD, "progClosuresSize", "size of list of program launch closures");
        this.addHeaderField(struct, QWORD, "progClosuresTrieAddr", "(unslid) address of trie of indexes into program launch closures");
        this.addHeaderField(struct, QWORD, "progClosuresTrieSize", "size of trie of indexes into program launch closures");
        this.addHeaderField(struct, DWORD, "platform", "platform number (macOS=1, etc)");
        this.addHeaderField(struct, DWORD, "dyld_info", "");
        this.addHeaderField(struct, QWORD, "sharedRegionStart", "base load address of cache if not slid");
        this.addHeaderField(struct, QWORD, "sharedRegionSize", "overall size of region cache can be mapped into");
        this.addHeaderField(struct, QWORD, "maxSlide", "runtime slide of cache can be between zero and this value");
        this.addHeaderField(struct, QWORD, "dylibsImageArrayAddr", "(unslid) address of ImageArray for dylibs in this cache");
        this.addHeaderField(struct, QWORD, "dylibsImageArraySize", "size of ImageArray for dylibs in this cache");
        this.addHeaderField(struct, QWORD, "dylibsTrieAddr", "(unslid) address of trie of indexes of all cached dylibs");
        this.addHeaderField(struct, QWORD, "dylibsTrieSize", "size of trie of cached dylib paths");
        this.addHeaderField(struct, QWORD, "otherImageArrayAddr", "(unslid) address of ImageArray for dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, QWORD, "otherImageArraySize", "size of ImageArray for dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, QWORD, "otherTrieAddr", "(unslid) address of trie of indexes of all dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, QWORD, "otherTrieSize", "size of trie of dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, DWORD, "mappingWithSlideOffset", "file offset to first dyld_cache_mapping_and_slide_info");
        this.addHeaderField(struct, DWORD, "mappingWithSlideCount", "number of dyld_cache_mapping_and_slide_info entries");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    private void addHeaderField(StructureDataType struct, DataType dt, String fieldname, String comment) {
        if (this.headerSize > struct.getLength()) {
            struct.add(dt, fieldname, comment);
        }
    }

    private void parseMappingInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD mapping info...");
        monitor.initialize((long)this.mappingCount);
        try {
            this.reader.setPointerIndex(this.mappingOffset);
            for (int i = 0; i < this.mappingCount; ++i) {
                this.mappingInfoList.add(new DyldCacheMappingInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_mapping_info.");
        }
    }

    private void parseImageInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.imagesOffset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD image info...");
        monitor.initialize((long)this.imagesCount);
        try {
            this.reader.setPointerIndex(this.imagesOffset);
            for (int i = 0; i < this.imagesCount; ++i) {
                this.imageInfoList.add(new DyldCacheImageInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_image_info.");
        }
    }

    private DyldCacheSlideInfoCommon parseSlideInfo(long offset, MessageLog log, TaskMonitor monitor) throws CancelledException {
        DyldCacheSlideInfoCommon slideInfo = DyldCacheSlideInfoCommon.parseSlideInfo(this.reader, offset, log, monitor);
        return slideInfo;
    }

    private void parseLocalSymbolsInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.localSymbolsOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD local symbols info...");
        monitor.initialize(1L);
        try {
            this.reader.setPointerIndex(this.localSymbolsOffset);
            this.localSymbolsInfo = new DyldCacheLocalSymbolsInfo(this.reader, this.architecture);
            this.localSymbolsInfo.parse(log, monitor);
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_local_symbols_info.");
        }
    }

    private void parseBranchPools(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.branchPoolsOffset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD branch pool addresses...");
        monitor.initialize((long)this.branchPoolsCount);
        try {
            this.reader.setPointerIndex(this.branchPoolsOffset);
            for (int i = 0; i < this.branchPoolsCount; ++i) {
                this.branchPoolList.add(this.reader.readNextLong());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse pool addresses.");
        }
    }

    private void parseImageTextInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.imagesTextOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD image text info...");
        monitor.initialize(this.imagesTextCount);
        try {
            this.reader.setPointerIndex(this.imagesTextOffset);
            int i = 0;
            while ((long)i < this.imagesTextCount) {
                this.imageTextInfoList.add(new DyldCacheImageTextInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
                ++i;
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_image_text_info.");
        }
    }

    private void parseAcceleratorInfo(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.accelerateInfoAddr == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD accelerateor info...");
        monitor.initialize(this.imagesTextCount);
        try {
            Address addr = space.getAddress(this.accelerateInfoAddr);
            MemoryByteProvider bytes = new MemoryByteProvider(program.getMemory(), addr);
            BinaryReader memoryReader = new BinaryReader(bytes, !program.getLanguage().isBigEndian());
            this.accelerateInfo = new DyldCacheAccelerateInfo(memoryReader);
            this.accelerateInfo.parse(program, addr, log, monitor);
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_accelerator_info.");
        }
    }

    private void markupHeader(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD header...");
        monitor.initialize(1L);
        try {
            DataUtilities.createData((Program)program, (Address)space.getAddress(this.getBaseAddress()), (DataType)this.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_header.");
        }
    }

    private void markupMappingInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD mapping info...");
        monitor.initialize((long)this.mappingInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.mappingOffset, program, space);
            for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)mappingInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_mapping_info.");
        }
    }

    private void markupCacheMappingSlideInfo(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Marking up DYLD cache mapping and slide info...");
        monitor.initialize((long)this.cacheMappingAndSlideInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.mappingWithSlideOffset, program, space);
            for (DyldCacheMappingAndSlideInfo mappingInfo : this.cacheMappingAndSlideInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)mappingInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_mapping_info.");
        }
    }

    private void markupImageInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image info...");
        monitor.initialize((long)this.imageInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.imagesOffset, program, space);
            for (DyldCacheImageInfo imageInfo : this.imageInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(addr, 0, imageInfo.getPath());
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_image_info.");
        }
    }

    private void markupCodeSignature(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD code signature...");
        monitor.initialize(1L);
        try {
            String size = "0x" + Long.toHexString(this.codeSignatureSize);
            program.getListing().setComment(this.fileOffsetToAddr(this.codeSignatureOffset, program, space), 3, "Code Signature (" + size + " bytes)");
            monitor.incrementProgress(1L);
        }
        catch (IllegalArgumentException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup code signature.");
        }
    }

    private void markupSlideInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD slide info...");
        monitor.initialize(1L);
        try {
            if (this.slideInfoList.size() > 0) {
                for (DyldCacheSlideInfoCommon info : this.slideInfoList) {
                    Address addr = this.fileOffsetToAddr(info.getSlideInfoOffset(), program, space);
                    DataUtilities.createData((Program)program, (Address)addr, (DataType)info.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                }
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_slide_info.");
        }
    }

    private void markupLocalSymbolsInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD local symbols info...");
        monitor.initialize(1L);
        try {
            if (this.localSymbolsInfo != null) {
                Address addr = this.fileOffsetToAddr(this.localSymbolsOffset, program, space);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.localSymbolsInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.localSymbolsInfo.markup(program, addr, monitor, log);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_local_symbols_info.");
        }
    }

    private void markupBranchPools(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD branch pool addresses...");
        monitor.initialize((long)this.branchPoolList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.branchPoolsOffset, program, space);
            for (Long element : this.branchPoolList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)Pointer64DataType.dataType, (int)Pointer64DataType.dataType.getLength(), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup branch pool addresses.");
        }
    }

    private void markupAcceleratorInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD accelerator info...");
        monitor.initialize(1L);
        try {
            if (this.accelerateInfo != null) {
                Address addr = space.getAddress(this.accelerateInfoAddr);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.accelerateInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.accelerateInfo.markup(program, addr, monitor, log);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_accelerator_info.");
        }
    }

    private void markupImageTextInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image text info...");
        monitor.initialize((long)this.imageTextInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.imagesTextOffset, program, space);
            for (DyldCacheImageTextInfo imageTextInfo : this.imageTextInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageTextInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(addr, 0, imageTextInfo.getPath());
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_image_text_info.");
        }
    }

    private Address fileOffsetToAddr(long offset, Program program, AddressSpace space) {
        for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
            if (offset < mappingInfo.getFileOffset() || offset >= mappingInfo.getFileOffset() + mappingInfo.getSize()) continue;
            return space.getAddress(mappingInfo.getAddress() + (offset - mappingInfo.getFileOffset()));
        }
        AddressSpace fileSpace = program.getAddressFactory().getAddressSpace("FILE");
        if (fileSpace != null) {
            try {
                return fileSpace.getAddress(offset);
            }
            catch (AddressOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public boolean haSlideInfo() {
        if (this.slideInfoSize != 0L) {
            return true;
        }
        if (this.headerType > 6) {
            for (DyldCacheMappingAndSlideInfo info : this.cacheMappingAndSlideInfoList) {
                if (info.getSlideInfoFileSize() == 0L) continue;
                return true;
            }
        }
        return false;
    }

    public long unslidLoadAddress() {
        return this.mappingInfoList.get(0).getAddress();
    }
}

