/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.attribs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAmbigNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBooleanAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFDeferredStringAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFIndirectAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFStringAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFForm;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.StringTable;
import java.io.IOException;

public class DWARFAttributeFactory {
    public static final int MAX_BLOCK4_SIZE = 0x100000;
    private DWARFProgram prog;

    public DWARFAttributeFactory(DWARFProgram prog) {
        this.prog = prog;
    }

    public DWARFAttributeValue read(BinaryReader reader, DWARFCompilationUnit unit, DWARFForm form) throws IOException {
        StringTable debugStrings = this.prog.getDebugStrings();
        switch (form) {
            case DW_FORM_addr: {
                return new DWARFNumericAttribute(DWARFUtil.readVarSizedULong(reader, unit.getPointerSize()));
            }
            case DW_FORM_ref1: {
                long uoffset = DWARFUtil.readVarSizedULong(reader, 1);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref2: {
                long uoffset = DWARFUtil.readVarSizedULong(reader, 2);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref4: {
                long uoffset = DWARFUtil.readVarSizedULong(reader, 4);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref8: {
                long uoffset = DWARFUtil.readVarSizedULong(reader, 8);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref_udata: {
                long uoffset = LEB128.readAsLong(reader, false);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref_addr: {
                return new DWARFNumericAttribute(DWARFUtil.readOffsetByDWARFformat(reader, unit.getFormat()));
            }
            case DW_FORM_sec_offset: {
                return new DWARFNumericAttribute(DWARFUtil.readOffsetByDWARFformat(reader, unit.getFormat()));
            }
            case DW_FORM_block1: {
                int length = DWARFUtil.readVarSizedUInt(reader, 1);
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_block2: {
                int length = DWARFUtil.readVarSizedUInt(reader, 2);
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_block4: {
                int length = DWARFUtil.readVarSizedUInt(reader, 4);
                if (length < 0 || length > 0x100000) {
                    throw new IOException("Invalid/bad dw_form_block4 size: " + length);
                }
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_block: {
                int length = LEB128.readAsUInt32(reader);
                if (length < 0 || length > 0x100000) {
                    throw new IOException("Invalid/bad dw_form_block size: " + length);
                }
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_data1: {
                return new DWARFAmbigNumericAttribute(reader.readNextByte(), 255L);
            }
            case DW_FORM_data2: {
                return new DWARFAmbigNumericAttribute(reader.readNextShort(), 65535L);
            }
            case DW_FORM_data4: {
                return new DWARFAmbigNumericAttribute(reader.readNextInt(), 0xFFFFFFFFL);
            }
            case DW_FORM_data8: {
                return new DWARFNumericAttribute(reader.readNextLong());
            }
            case DW_FORM_sdata: {
                return new DWARFNumericAttribute(LEB128.readAsLong(reader, true));
            }
            case DW_FORM_udata: {
                return new DWARFNumericAttribute(LEB128.readAsLong(reader, false));
            }
            case DW_FORM_exprloc: {
                int length = LEB128.readAsUInt32(reader);
                if (length < 0 || length > 0x100000) {
                    throw new IOException("Invalid/bad dw_form_exprloc size: " + length);
                }
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_flag: {
                return DWARFBooleanAttribute.get(reader.readNextByte() != 0);
            }
            case DW_FORM_flag_present: {
                return DWARFBooleanAttribute.TRUE;
            }
            case DW_FORM_string: {
                return new DWARFStringAttribute(reader.readNextNullTerminatedAsciiString());
            }
            case DW_FORM_strp: {
                long stringOffset = DWARFUtil.readOffsetByDWARFformat(reader, unit.getFormat());
                if (!debugStrings.isValid(stringOffset)) {
                    throw new IOException("Bad string offset " + Long.toHexString(stringOffset));
                }
                return new DWARFDeferredStringAttribute(stringOffset);
            }
            case DW_FORM_ref_sig8: {
                throw new UnsupportedOperationException("DW_FORM_ref_sig8 is currently not implemented");
            }
            case DW_FORM_indirect: {
                DWARFForm formValue = DWARFForm.find(LEB128.readAsUInt32(reader));
                DWARFAttributeValue value = this.read(reader, unit, formValue);
                return new DWARFIndirectAttribute(value, formValue);
            }
        }
        throw new IllegalArgumentException("Unknown DWARF Form: " + form.toString());
    }
}

