/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.TableAddRemoveStrategy;
import ghidra.app.cmd.function.DeleteFunctionCmd;
import ghidra.app.cmd.label.DeleteLabelCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.plugin.core.symtable.NewSymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolProvider;
import ghidra.app.plugin.core.symtable.SymbolTableAddRemoveStrategy;
import ghidra.docking.settings.Settings;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.AbstractWrapperTypeColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AbstractProgramLocationTableColumn;
import ghidra.util.table.field.AddressBasedLocation;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

class SymbolTableModel
extends AddressBasedTableModel<Symbol> {
    private static final Comparator<Symbol> NAME_COL_COMPARATOR = (s1, s2) -> s1.toString().compareToIgnoreCase(s2.toString());
    static final int LABEL_COL = 0;
    static final int LOCATION_COL = 1;
    static final int TYPE_COL = 2;
    static final int DATA_TYPE_COL = 3;
    static final int NAMESPACE_COL = 4;
    static final int SOURCE_COL = 5;
    static final int REFS_COL = 6;
    private SymbolProvider provider;
    private PluginTool tool;
    private SymbolTable symbolTable;
    private ReferenceManager refMgr;
    private Symbol lastSymbol;
    private SymbolFilter filter;
    private TableAddRemoveStrategy<Symbol> deletedDbObjectAddRemoveStrategy = new SymbolTableAddRemoveStrategy();

    SymbolTableModel(SymbolProvider provider, PluginTool tool) {
        super("Symbols", (ServiceProvider)tool, null, null);
        this.provider = provider;
        this.tool = tool;
        this.filter = new NewSymbolFilter();
    }

    @Override
    protected TableColumnDescriptor<Symbol> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new NameTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new LocationTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new SymbolTypeTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new DataTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new NamespaceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceCountTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new OffcutReferenceCountTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new PinnedTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new UserTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new OriginalNameColumn());
        return descriptor;
    }

    protected TableAddRemoveStrategy<Symbol> getAddRemoveStrategy() {
        return this.deletedDbObjectAddRemoveStrategy;
    }

    void setFilter(SymbolFilter filter) {
        this.filter = filter;
        this.reload();
    }

    Symbol getSymbol(long symbolID) {
        if (this.symbolTable != null) {
            return this.symbolTable.getSymbol(symbolID);
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.symbolTable = null;
        this.refMgr = null;
        this.lastSymbol = null;
        this.provider = null;
    }

    void reload(Program prog) {
        this.cancelAllUpdates();
        this.lastSymbol = null;
        if (prog != null) {
            this.setProgram(prog);
            this.symbolTable = prog.getSymbolTable();
            this.refMgr = prog.getReferenceManager();
            this.reload();
        } else {
            this.setProgram(null);
            this.symbolTable = null;
            this.refMgr = null;
        }
    }

    public int getKeyCount() {
        if (this.symbolTable != null) {
            int cnt = this.symbolTable.getNumSymbols();
            if (this.filter.acceptsDefaultLabelSymbols()) {
                cnt += this.refMgr.getReferenceDestinationCount();
            }
            return cnt;
        }
        return 0;
    }

    protected void doLoad(Accumulator<Symbol> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.symbolTable == null) {
            return;
        }
        SymbolIterator it = this.symbolTable.getDefinedSymbols();
        monitor.initialize((long)this.getKeyCount());
        int value = 0;
        while (it.hasNext()) {
            monitor.setProgress((long)value++);
            monitor.checkCanceled();
            Symbol s = it.next();
            if (!this.filter.accepts(s, this.getProgram())) continue;
            accumulator.add((Object)s);
        }
        if (this.filter.acceptsDefaultLabelSymbols()) {
            AddressIterator addrIt = this.refMgr.getReferenceDestinationIterator((AddressSetView)this.getProgram().getAddressFactory().getAddressSet(), true);
            while (addrIt.hasNext()) {
                monitor.setProgress((long)value++);
                monitor.checkCanceled();
                Address a = addrIt.next();
                Symbol s = this.symbolTable.getPrimarySymbol(a);
                if (!s.isDynamic() || !this.filter.accepts(s, this.getProgram())) continue;
                accumulator.add((Object)s);
            }
        }
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public boolean isCellEditable(int key, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int row, int columnIndex) {
        if (this.provider == null || this.symbolTable == null || aValue == null) {
            return;
        }
        if (row < 0 || row >= this.filteredData.size()) {
            return;
        }
        Symbol symbol = (Symbol)this.filteredData.get(row);
        if (symbol == null) {
            return;
        }
        if (columnIndex != 0) {
            return;
        }
        String newName = aValue.toString();
        if (symbol.getName().equals(newName)) {
            return;
        }
        RenameLabelCmd renameCmd = new RenameLabelCmd(symbol, newName, SourceType.USER_DEFINED);
        if (!this.tool.execute((Command)renameCmd, (DomainObject)this.getProgram())) {
            Msg.showError(this.getClass(), (Component)this.provider.getComponent(), (String)"Error Renaming Symbol", (Object)renameCmd.getStatusMsg());
        }
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        Symbol s = (Symbol)this.getValueAt(row, 0);
        if (s != null) {
            return s.getProgramLocation();
        }
        return null;
    }

    public ProgramLocation getProgramLocation(int row) {
        return (ProgramLocation)this.getValueAt(row, 1);
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            AddressBasedLocation symbolLocation = this.getSymbolLocation((Symbol)this.getRowObject(element));
            if (!symbolLocation.isMemoryLocation()) continue;
            set.add(symbolLocation.getAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    public void reload() {
        this.lastSymbol = null;
        super.reload();
    }

    void symbolAdded(Symbol s) {
        if (this.filter.accepts(s, this.getProgram())) {
            this.addObject(s);
            this.lastSymbol = s;
        }
    }

    void symbolRemoved(Symbol s) {
        if (this.lastSymbol != null && this.lastSymbol.getID() == s.getID()) {
            this.lastSymbol = null;
        }
        this.removeObject(s);
    }

    void symbolChanged(Symbol s) {
        Symbol Symbol2 = s;
        if (this.filter.accepts(s, this.getProgram())) {
            this.updateObject(Symbol2);
        } else {
            this.removeObject(Symbol2);
        }
    }

    void delete(List<Symbol> rowObjects) {
        if (rowObjects == null || rowObjects.isEmpty()) {
            return;
        }
        this.tool.setStatusInfo("");
        LinkedList<Symbol> deleteList = new LinkedList<Symbol>();
        CompoundCmd cmd = new CompoundCmd("Delete symbol(s)");
        for (Symbol symbol : rowObjects) {
            if (symbol.isDynamic()) continue;
            deleteList.add(symbol);
            String label = symbol.getName();
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                Function function = (Function)symbol.getObject();
                boolean ignoreMissingFunction = function.isThunk();
                cmd.add((Command)new DeleteFunctionCmd(symbol.getAddress(), ignoreMissingFunction));
                if (symbol.getSource() == SourceType.DEFAULT) continue;
                cmd.add((Command)new DeleteLabelCmd(symbol.getAddress(), label, symbol.getParentNamespace()));
                continue;
            }
            cmd.add((Command)new DeleteLabelCmd(symbol.getAddress(), label, symbol.getParentNamespace()));
        }
        if (cmd.size() == 0) {
            return;
        }
        if (this.tool.execute((Command)cmd, (DomainObject)this.getProgram())) {
            for (Symbol s : deleteList) {
                this.removeObject(s);
            }
            this.updateNow();
        } else {
            this.tool.setStatusInfo(cmd.getStatusMsg());
            this.reload();
        }
    }

    public SymbolFilter getFilter() {
        return this.filter;
    }

    @Override
    public Address getAddress(int row) {
        Symbol symbol = (Symbol)this.getRowObject(row);
        if (symbol == null) {
            return null;
        }
        return symbol.getAddress();
    }

    private AddressBasedLocation getSymbolLocation(Symbol s) {
        if (s == null) {
            return new AddressBasedLocation();
        }
        SymbolType type = s.getSymbolType();
        if (type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR) {
            Variable object = (Variable)s.getObject();
            if (object == null) {
                return null;
            }
            return new VariableSymbolLocation(object);
        }
        return new AddressBasedLocation(this.program, s.getAddress());
    }

    protected Comparator<Symbol> createSortComparator(int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        if (column instanceof NameTableColumn) {
            return NAME_COL_COMPARATOR;
        }
        return super.createSortComparator(columnIndex);
    }

    private class OriginalNameColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, String> {
        private OriginalNameColumn() {
        }

        public String getColumnName() {
            return "Original Imported Name";
        }

        public String getColumnDescription() {
            return "The original (pre-demangled) import name (External Symbols Only)";
        }

        public String getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            if (!symbol.isExternal()) {
                return null;
            }
            SymbolType symbolType = symbol.getSymbolType();
            if (symbolType != SymbolType.FUNCTION && symbolType != SymbolType.LABEL) {
                return null;
            }
            ExternalManager externalManager = p.getExternalManager();
            ExternalLocation externalLocation = externalManager.getExternalLocation(symbol);
            if (externalLocation != null) {
                return externalLocation.getOriginalImportedName();
            }
            return null;
        }
    }

    private class UserTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, String> {
        private UserTableColumn() {
        }

        public String getColumnName() {
            return "User";
        }

        public String getColumnDescription() {
            return "The user that created or last edited this symbol.";
        }

        public String getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            SourceType source = symbol.getSource();
            if (source != SourceType.USER_DEFINED) {
                return null;
            }
            Address address = symbol.getAddress();
            LabelHistory[] labelHistory = SymbolTableModel.this.symbolTable.getLabelHistory(address);
            if (labelHistory.length > 0) {
                return labelHistory[0].getUserName();
            }
            return null;
        }
    }

    private class OffcutReferenceCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, Integer> {
        private OffcutReferenceCountRenderer renderer = new OffcutReferenceCountRenderer();

        private OffcutReferenceCountTableColumn() {
        }

        public String getColumnName() {
            return "Offcut Ref Count";
        }

        public Integer getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            CodeUnit codeUnit;
            if (symbol.isDeleted()) {
                return null;
            }
            Address address = symbol.getAddress();
            int count = 0;
            if (address.isMemoryAddress() && (codeUnit = p.getListing().getCodeUnitContaining(address)) != null) {
                AddressSet set = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
                set.deleteRange(address, address);
                ReferenceManager referenceManager = p.getReferenceManager();
                AddressIterator it = referenceManager.getReferenceDestinationIterator((AddressSetView)set, true);
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
            }
            return count;
        }

        public GColumnRenderer<Integer> getColumnRenderer() {
            return this.renderer;
        }

        private class OffcutReferenceCountRenderer
        extends GTableCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Integer> {
            private OffcutReferenceCountRenderer() {
            }
        }
    }

    private class ReferenceCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, Integer> {
        private ReferenceCountRenderer renderer = new ReferenceCountRenderer();

        private ReferenceCountTableColumn() {
        }

        public String getColumnName() {
            return "Reference Count";
        }

        public Integer getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            return symbol.getReferenceCount();
        }

        public GColumnRenderer<Integer> getColumnRenderer() {
            return this.renderer;
        }

        private class ReferenceCountRenderer
        extends GTableCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Integer> {
            private ReferenceCountRenderer() {
            }
        }
    }

    private class SourceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, SourceType> {
        private GColumnRenderer<SourceType> renderer = new AbstractGColumnRenderer<SourceType>(){

            protected String getText(Object value) {
                if (value == null) {
                    return "";
                }
                return ((SourceType)value).getDisplayString();
            }

            public String getFilterString(SourceType t, Settings settings) {
                return this.getText(t);
            }
        };

        private SourceTableColumn() {
        }

        public String getColumnName() {
            return "Source";
        }

        public GColumnRenderer<SourceType> getColumnRenderer() {
            return this.renderer;
        }

        public SourceType getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol == null) {
                return null;
            }
            return symbol.getSource();
        }
    }

    private class NamespaceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, String> {
        private NamespaceTableColumn() {
        }

        public String getColumnName() {
            return "Namespace";
        }

        public String getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            return symbol.getParentNamespace().getName(true);
        }
    }

    private class DataTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, String> {
        private DataTypeTableColumn() {
        }

        public String getColumnName() {
            return "Data Type";
        }

        public String getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            DataType dt = null;
            Object obj = symbol.getObject();
            if (obj instanceof Data) {
                dt = ((Data)obj).getDataType();
            } else if (obj instanceof Function) {
                dt = ((Function)obj).getReturnType();
            } else if (obj instanceof Variable) {
                dt = ((Variable)obj).getDataType();
            } else if (obj instanceof ExternalLocation) {
                dt = ((ExternalLocation)obj).getDataType();
            }
            if (dt != null) {
                return dt.getDisplayName();
            }
            return "";
        }
    }

    private class VariableSymbolLocation
    extends AddressBasedLocation {
        VariableSymbolLocation(Variable variable) {
            super(variable.getSymbol().getAddress(), variable.getVariableStorage().toString());
        }
    }

    private class SymbolTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, String> {
        private SymbolTypeTableColumn() {
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            return SymbolUtilities.getSymbolTypeDisplayName((Symbol)symbol);
        }
    }

    private class LocationTableColumn
    extends AbstractProgramLocationTableColumn<Symbol, AddressBasedLocation> {
        private LocationTableColumn() {
        }

        public String getColumnName() {
            return "Location";
        }

        public AddressBasedLocation getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            return SymbolTableModel.this.getSymbolLocation(symbol);
        }

        @Override
        public ProgramLocation getProgramLocation(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) {
            if (symbol.isDeleted()) {
                return null;
            }
            return symbol.getProgramLocation();
        }
    }

    private class PinnedTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, Boolean> {
        private PinnedRenderer renderer = new PinnedRenderer();

        private PinnedTableColumn() {
        }

        public String getColumnName() {
            return "Pinned";
        }

        public Boolean getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            return symbol.isPinned();
        }

        public GColumnRenderer<Boolean> getColumnRenderer() {
            return this.renderer;
        }

        private class PinnedRenderer
        extends GBooleanCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Boolean> {
            private PinnedRenderer() {
            }
        }
    }

    private class NameTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Symbol, Symbol> {
        private NameTableColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public Symbol getValue(Symbol symbol, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            if (symbol.isDeleted()) {
                return null;
            }
            return symbol;
        }
    }
}

