/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.TaskScheduler;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.searchtext.SearchOptions;
import ghidra.app.plugin.core.searchtext.SearchTextPlugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocFieldLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.StringUtilities;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

class SearchTextDialog
extends DialogComponentProvider {
    private static final int DEFAULT_MAX_ENTRIES = 10;
    private SearchTextPlugin plugin;
    private PluginTool tool;
    private JButton nextButton;
    private JButton previousButton;
    private JButton allButton;
    private JTextField valueField;
    private GhidraComboBox<String> valueComboBox;
    private List<String> history = new LinkedList<String>();
    private JRadioButton programDatabaseSearchRB;
    private JRadioButton listingDisplaySearchRB;
    private JCheckBox searchSelectionCB;
    private JRadioButton searchFieldRB;
    private JRadioButton searchAllRB;
    private JCheckBox commentsCB;
    private JCheckBox labelsCB;
    private JCheckBox mnemonicsCB;
    private JCheckBox operandsCB;
    private JCheckBox dataMnemonicsCB;
    private JCheckBox dataOperandsCB;
    private JCheckBox functionsCB;
    private boolean changingState;
    private boolean forward;
    private boolean isBusy;
    private boolean searchEnabled = true;
    private JCheckBox caseSensitiveCB;
    private JRadioButton loadedBlocksButton;
    private JRadioButton allBlocksButton;

    SearchTextDialog(SearchTextPlugin plugin) {
        super("Search Program Text", false, true, true, true);
        this.setHelpLocation(new HelpLocation("Search", "Search_Text"));
        this.plugin = plugin;
        this.tool = plugin.getTool();
        this.addWorkPanel(this.createMainPanel());
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic('N');
        this.nextButton.addActionListener(ev -> this.nextPrevious(true));
        this.addButton(this.nextButton);
        this.previousButton = new JButton("Previous");
        this.previousButton.setMnemonic('P');
        this.previousButton.addActionListener(ev -> this.nextPrevious(false));
        this.addButton(this.previousButton);
        this.allButton = new JButton("Search All");
        this.allButton.setMnemonic('a');
        this.allButton.addActionListener(ev -> {
            this.searchAll();
            this.valueField.requestFocus();
        });
        this.addButton(this.allButton);
        this.setUseSharedLocation(true);
        this.addDismissButton();
    }

    public void close() {
        super.close();
    }

    public void show(ComponentProvider componentProvider) {
        this.clearStatusText();
        this.valueField.requestFocus();
        this.valueField.selectAll();
        this.tool.showDialog((DialogComponentProvider)this, componentProvider);
        this.isBusy = false;
        this.updateSearchButtonsEnablement();
    }

    protected void dismissCallback() {
        this.close();
        this.cancelCurrentTask();
    }

    public void setStatusText(String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setStatusText(text);
        } else {
            SwingUtilities.invokeLater(() -> this.setMessage(text));
        }
    }

    protected void executeProgressTask(Task task, int delay) {
        super.executeProgressTask(task, delay);
    }

    protected TaskMonitorComponent getTaskMonitorComponent() {
        return super.getTaskMonitorComponent();
    }

    protected TaskScheduler getTaskScheduler() {
        return super.getTaskScheduler();
    }

    private void updateSearchButtonsEnablement() {
        this.allButton.setEnabled(!this.isBusy && this.searchEnabled);
        this.nextButton.setEnabled(!this.isBusy && this.searchEnabled);
        this.previousButton.setEnabled(!this.isBusy && this.searchEnabled);
    }

    void setSearchEnabled(boolean enabled) {
        this.searchEnabled = enabled;
        this.updateSearchButtonsEnablement();
    }

    void setHasSelection(boolean hasSelection) {
        this.searchSelectionCB.setEnabled(hasSelection);
        this.searchSelectionCB.setSelected(hasSelection);
    }

    boolean searchSelection() {
        return this.searchSelectionCB.isSelected();
    }

    private void setMessage(String msg) {
        super.setStatusText(msg);
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 0));
        mainPanel.add((Component)this.createSearchPanel(), "North");
        mainPanel.add((Component)this.createDetailsPanel(), "Center");
        return mainPanel;
    }

    private JPanel createSearchPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 10, 4));
        panel.setLayout(new BorderLayout());
        this.valueComboBox = new GhidraComboBox();
        this.valueComboBox.setEditable(true);
        this.valueField = (JTextField)this.valueComboBox.getEditor().getEditorComponent();
        this.valueField.setColumns(20);
        this.valueField.setDocument(new AutoCompleteDocument());
        this.valueField.addActionListener(ev -> {
            if (this.nextButton.isEnabled()) {
                this.nextPrevious(true);
                this.valueField.requestFocus();
            }
        });
        this.valueField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    SearchTextDialog.this.setStatusText("");
                }
            }
        });
        JPanel searchPanel = new JPanel();
        BoxLayout bl = new BoxLayout(searchPanel, 0);
        searchPanel.setLayout(bl);
        searchPanel.add((Component)new GLabel("Search for:"));
        searchPanel.add(Box.createHorizontalStrut(5));
        searchPanel.add((Component)this.valueComboBox);
        JPanel outerPanel = new JPanel(new FlowLayout(1));
        outerPanel.add(searchPanel);
        panel.add((Component)outerPanel, "Center");
        return panel;
    }

    private JPanel createDetailsPanel() {
        JPanel detailsPanel = new JPanel(new BorderLayout());
        detailsPanel.add((Component)this.createSearchTypePanel(), "North");
        detailsPanel.add((Component)this.createDetailsGroupPanel(), "Center");
        return detailsPanel;
    }

    private JPanel createDetailsGroupPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 10));
        panel.add(this.createFieldsPanel());
        panel.add(this.createRightPanel());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private JPanel createRightPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1, 10, 10));
        panel.add(this.createDirectionPanel());
        panel.add(this.createOptionsPanel());
        return panel;
    }

    private JPanel createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        this.caseSensitiveCB = new GCheckBox("Case Sensitive");
        this.caseSensitiveCB.setToolTipText(HTMLUtilities.toHTML((String)"Select this if the search\n should be case sensitive."));
        panel.add(this.caseSensitiveCB);
        this.searchSelectionCB = new GCheckBox("Search Selection");
        panel.add(this.searchSelectionCB);
        panel.setBorder(BorderFactory.createTitledBorder("Options"));
        return panel;
    }

    private JPanel createFieldOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        BoxLayout bl = new BoxLayout(optionsPanel, 1);
        optionsPanel.setLayout(bl);
        this.functionsCB = new GCheckBox("Functions");
        this.functionsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in the Function Header fields"));
        this.commentsCB = new GCheckBox("Comments", true);
        this.commentsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in any of the comment fields"));
        this.labelsCB = new GCheckBox("Labels");
        this.labelsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in the Lable field"));
        this.mnemonicsCB = new GCheckBox("Instruction Mnemonics");
        this.mnemonicsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in the Instruction Mnemonic field"));
        this.operandsCB = new GCheckBox("Instruction Operands");
        this.operandsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in the Instruction Operand fields"));
        this.dataMnemonicsCB = new GCheckBox("Defined Data Mnemonics");
        this.dataMnemonicsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in the Data Mnemonic and Value fields"));
        this.dataOperandsCB = new GCheckBox("Defined Data Values");
        this.dataOperandsCB.setToolTipText(HTMLUtilities.toHTML((String)"Search in the Data Mnemonic and Value fields"));
        optionsPanel.add(this.functionsCB);
        optionsPanel.add(this.commentsCB);
        optionsPanel.add(this.labelsCB);
        optionsPanel.add(this.mnemonicsCB);
        optionsPanel.add(this.operandsCB);
        optionsPanel.add(this.dataMnemonicsCB);
        optionsPanel.add(this.dataOperandsCB);
        return optionsPanel;
    }

    private JPanel createFieldsPanel() {
        JPanel radioPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        ButtonGroup bg = new ButtonGroup();
        this.searchFieldRB = new GRadioButton("Selected Fields", true);
        this.searchFieldRB.setToolTipText(HTMLUtilities.toHTML((String)"Search for specific fields. Use the\ncheckboxes to mark which fields to search.\nThis option applies to either the Program Database Search\nor the Listing Display Match Search.\n\nNOTE: Selecting all of these fields is NOT the same as selecting \"All Fields\".\n"));
        this.searchAllRB = new GRadioButton("All Fields", false);
        this.searchAllRB.setToolTipText(HTMLUtilities.toHTML((String)"Search all the fields displayed in the Code Browser.\nThe option applies only to the Listing Display Search."));
        this.searchAllRB.addItemListener(e -> {
            if (this.changingState) {
                return;
            }
            this.changingState = true;
            boolean isSelected = e.getStateChange() == 1;
            this.enableCheckboxes(!isSelected);
            if (isSelected) {
                this.listingDisplaySearchRB.setSelected(true);
            }
            this.changingState = false;
        });
        bg.add(this.searchFieldRB);
        bg.add(this.searchAllRB);
        JPanel optionsPanel = this.createFieldOptionsPanel();
        Border b2 = BorderFactory.createEmptyBorder(0, 20, 10, 10);
        optionsPanel.setBorder(b2);
        radioPanel.add(this.searchFieldRB);
        radioPanel.add(optionsPanel);
        radioPanel.add(this.searchAllRB);
        radioPanel.setBorder(BorderFactory.createTitledBorder("Fields"));
        return radioPanel;
    }

    private JPanel createSearchTypePanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.setBorder(BorderFactory.createTitledBorder("Search Type"));
        ButtonGroup bg = new ButtonGroup();
        this.programDatabaseSearchRB = new GRadioButton("Program Database", true);
        this.programDatabaseSearchRB.setToolTipText(HTMLUtilities.toHTML((String)"Searches comments, labels, instructions, function signatures, and data stored in the program database.\n This search is much faster, but does not search all text displayed in the Code Browser\n Listing window, which contains auto-generated and derived information.\n"));
        this.programDatabaseSearchRB.addItemListener(e -> {
            if (this.changingState) {
                return;
            }
            this.changingState = true;
            if (e.getStateChange() == 1) {
                this.searchFieldRB.setSelected(true);
                this.enableCheckboxes(true);
            }
            this.changingState = false;
        });
        this.listingDisplaySearchRB = new GRadioButton("Listing Display", false);
        this.listingDisplaySearchRB.setToolTipText(HTMLUtilities.toHTML((String)"Searches the text displayed in the Code Browser\nListing Display. (Depending on which fields are selected)\nWarning: this may be very slow!"));
        bg.add(this.programDatabaseSearchRB);
        bg.add(this.listingDisplaySearchRB);
        panel.add(this.programDatabaseSearchRB);
        panel.add(this.listingDisplaySearchRB);
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        outerPanel.add(panel);
        return outerPanel;
    }

    private JPanel createDirectionPanel() {
        JPanel directionPanel = new JPanel((LayoutManager)new VerticalLayout(3));
        directionPanel.setBorder(BorderFactory.createTitledBorder("Memory Block Types"));
        ButtonGroup directionGroup = new ButtonGroup();
        this.loadedBlocksButton = new GRadioButton("Loaded Blocks", true);
        this.allBlocksButton = new GRadioButton("All Blocks", false);
        this.loadedBlocksButton.setToolTipText(HTMLUtilities.toHTML((String)"Only searches memory blocks that are loaded in a running executable.\n  Ghidra now includes memory blocks for other data such as section headers.\nThis option exludes these OTHER (non loaded) blocks."));
        this.allBlocksButton.setToolTipText("Searches all memory blocks including blocks that are not actually loaded in a running executable");
        directionGroup.add(this.loadedBlocksButton);
        directionGroup.add(this.allBlocksButton);
        directionPanel.add(this.loadedBlocksButton);
        directionPanel.add(this.allBlocksButton);
        return directionPanel;
    }

    private void nextPrevious(boolean searchForward) {
        this.forward = searchForward;
        this.clearStatusText();
        if (!this.validate()) {
            return;
        }
        this.addToHistory(this.valueField.getText());
        this.plugin.next();
        this.plugin.searched();
        this.isBusy = true;
        this.updateSearchButtonsEnablement();
    }

    public SearchOptions getSearchOptions() {
        String value = this.valueField.getText();
        value = StringUtilities.fixMultipleAsterisks((String)value);
        if (this.searchAllRB.isSelected()) {
            return new SearchOptions(value, this.caseSensitiveCB.isSelected(), this.forward, this.allBlocksButton.isSelected());
        }
        return new SearchOptions(value, this.programDatabaseSearchRB.isSelected(), this.functionsCB.isSelected(), this.commentsCB.isSelected(), this.labelsCB.isSelected(), this.mnemonicsCB.isSelected(), this.operandsCB.isSelected(), this.dataMnemonicsCB.isSelected(), this.dataOperandsCB.isSelected(), this.caseSensitiveCB.isSelected(), this.forward, this.allBlocksButton.isSelected(), false);
    }

    private boolean validate() {
        String value = this.valueField.getText();
        if (value.length() == 0) {
            this.setStatusText("Please enter a pattern to search for.");
            return false;
        }
        if ("*".equals(value = StringUtilities.fixMultipleAsterisks((String)value))) {
            this.setStatusText("Pattern must contain a non-wildcard character.");
            return false;
        }
        if (this.searchAllRB.isSelected()) {
            return true;
        }
        if (!(this.commentsCB.isSelected() || this.labelsCB.isSelected() || this.mnemonicsCB.isSelected() || this.operandsCB.isSelected() || this.dataMnemonicsCB.isSelected() || this.dataOperandsCB.isSelected() || this.functionsCB.isSelected())) {
            this.setStatusText("Please select an option to search.");
            return false;
        }
        return true;
    }

    private void searchAll() {
        this.clearStatusText();
        this.addToHistory(this.valueField.getText());
        if (!this.validate()) {
            return;
        }
        this.plugin.searchAll(this.getSearchOptions());
        this.isBusy = true;
        this.updateSearchButtonsEnablement();
    }

    void searchAllFinished() {
        this.hideTaskMonitorComponent();
        this.isBusy = false;
        this.updateSearchButtonsEnablement();
    }

    public void taskCompleted(Task task) {
        super.taskCompleted(task);
        this.isBusy = false;
        if (this.plugin != null) {
            this.searchEnabled = this.plugin.getNavigatable() != null;
            this.updateSearchButtonsEnablement();
        }
    }

    public void taskCancelled(Task task) {
        super.taskCancelled(task);
        this.isBusy = false;
        if (this.plugin != null) {
            this.searchEnabled = this.plugin.getNavigatable() != null;
            this.updateSearchButtonsEnablement();
        }
    }

    public void repeatSearch() {
        this.nextPrevious(this.forward);
    }

    private void addToHistory(String input) {
        this.history.remove(input);
        this.history.add(0, input);
        this.truncateHistoryAsNeeded();
        this.updateCombo();
    }

    void truncateHistoryAsNeeded() {
        int maxEntries = 10;
        int historySize = this.history.size();
        if (historySize > maxEntries) {
            int numToRemove = historySize - maxEntries;
            for (int i = 0; i < numToRemove; ++i) {
                this.history.remove(this.history.size() - 1);
            }
        }
    }

    private String matchHistory(String input) {
        if (input == null) {
            return null;
        }
        Iterator<String> itr = this.history.iterator();
        String ret = null;
        while (ret == null && itr.hasNext()) {
            String cur = itr.next();
            if (!cur.startsWith(input)) continue;
            ret = cur;
        }
        return ret;
    }

    private void updateCombo() {
        String[] list = new String[this.history.size()];
        this.history.toArray(list);
        this.valueComboBox.setModel(new DefaultComboBoxModel<String>(list));
    }

    private void enableCheckboxes(boolean enabled) {
        this.commentsCB.setEnabled(enabled);
        this.labelsCB.setEnabled(enabled);
        this.mnemonicsCB.setEnabled(enabled);
        this.operandsCB.setEnabled(enabled);
        this.dataMnemonicsCB.setEnabled(enabled);
        this.dataOperandsCB.setEnabled(enabled);
        this.functionsCB.setEnabled(enabled);
    }

    public void setValueFieldText(String selectedText) {
        this.valueField.setText(selectedText);
    }

    public void setCurrentField(ProgramLocation textField, boolean isInstruction) {
        if (textField instanceof CommentFieldLocation || textField instanceof EolCommentFieldLocation || textField instanceof PlateFieldLocation || textField instanceof PostCommentFieldLocation) {
            this.commentsCB.setSelected(true);
        }
        if (textField instanceof LabelFieldLocation) {
            this.labelsCB.setSelected(true);
        }
        if (textField instanceof FunctionNameFieldLocation || textField instanceof FunctionRepeatableCommentFieldLocation || textField instanceof FunctionSignatureFieldLocation || textField instanceof VariableCommentFieldLocation || textField instanceof VariableLocFieldLocation || textField instanceof VariableNameFieldLocation || textField instanceof VariableTypeFieldLocation) {
            this.functionsCB.setSelected(true);
        }
        if (textField instanceof MnemonicFieldLocation && isInstruction) {
            this.mnemonicsCB.setSelected(true);
        }
        if (textField instanceof OperandFieldLocation && isInstruction) {
            this.operandsCB.setSelected(true);
        }
        if (textField instanceof MnemonicFieldLocation && !isInstruction) {
            this.dataMnemonicsCB.setSelected(true);
        }
        if (textField instanceof OperandFieldLocation && !isInstruction) {
            this.dataOperandsCB.setSelected(true);
        }
    }

    public class AutoCompleteDocument
    extends DefaultStyledDocument {
        private String previousInput;
        private boolean automated = false;

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (this.automated) {
                this.automated = false;
            } else {
                String input = SearchTextDialog.this.valueField.getText();
                if (!input.equals(this.previousInput)) {
                    this.previousInput = input;
                    String match = SearchTextDialog.this.matchHistory(input);
                    if (match != null && match.length() > input.length()) {
                        this.automated = true;
                        SearchTextDialog.this.valueField.setText(match);
                        SearchTextDialog.this.valueField.setSelectionStart(input.length());
                        SearchTextDialog.this.valueField.setSelectionEnd(match.length());
                    }
                }
            }
        }
    }
}

