/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.MultiActionDockingAction;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.overview.OverviewColorComponent;
import ghidra.app.plugin.core.overview.OverviewColorService;
import ghidra.app.services.CodeViewerService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Overview Color Manager", description="Provides various color mappings for the program address space.", servicesRequired={CodeViewerService.class})
public class OverviewColorPlugin
extends ProgramPlugin {
    public static final String HELP_TOPIC = "OverviewPlugin";
    private static final String ACTIVE_SERVICES = "ActiveServices";
    private List<OverviewColorService> allServices;
    private Map<OverviewColorService, OverviewColorComponent> activeServices = new LinkedHashMap<OverviewColorService, OverviewColorComponent>();
    private CodeViewerService codeViewerService;
    private Map<OverviewColorService, OverviewToggleAction> actionMap = new HashMap<OverviewColorService, OverviewToggleAction>();
    private MultiActionDockingAction multiAction;

    public OverviewColorPlugin(PluginTool tool) {
        super(tool, false, false);
    }

    protected void init() {
        super.init();
        this.codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        this.allServices = ClassSearcher.getInstances(OverviewColorService.class);
        this.createActions();
        for (OverviewColorService service : this.allServices) {
            service.initialize(this.tool);
        }
    }

    public void readConfigState(SaveState saveState) {
        String[] activeServiceNames;
        for (String serviceName : activeServiceNames = saveState.getStrings(ACTIVE_SERVICES, new String[0])) {
            OverviewColorService service = this.getService(serviceName);
            if (service == null) {
                Msg.warn((Object)((Object)this), (Object)("Can't restore OverviewColorService: " + serviceName));
                continue;
            }
            OverviewToggleAction action = this.actionMap.get(service);
            action.setSelected(true);
            SwingUtilities.invokeLater(() -> this.installOverview(service));
        }
    }

    private OverviewColorService getService(String serviceName) {
        for (OverviewColorService service : this.allServices) {
            if (!service.getName().equals(serviceName)) continue;
            return service;
        }
        return null;
    }

    protected void cleanup() {
        ArrayList<OverviewColorService> services = new ArrayList<OverviewColorService>(this.activeServices.keySet());
        for (OverviewColorService service : services) {
            this.uninstallOverview(service);
        }
        this.codeViewerService.removeLocalAction((DockingAction)this.multiAction);
    }

    public void writeConfigState(SaveState saveState) {
        saveState.putStrings(ACTIVE_SERVICES, this.getActiveServiceNames());
    }

    private String[] getActiveServiceNames() {
        List<String> names = this.activeServices.keySet().stream().map(s -> s.getName()).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    private void createActions() {
        for (OverviewColorService overviewColorService : this.allServices) {
            this.actionMap.put(overviewColorService, new OverviewToggleAction(this.getName(), overviewColorService));
        }
        this.multiAction = new MultiActionDockingAction("Overview", this.getName()){

            public void actionPerformed(ActionContext context) {
            }
        };
        this.multiAction.setPerformActionOnButtonClick(false);
        this.multiAction.setActions(new ArrayList<OverviewToggleAction>(this.actionMap.values()));
        this.multiAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/x-office-document-template.png")));
        this.codeViewerService.addLocalAction((DockingAction)this.multiAction);
        this.multiAction.setDescription("Toggles overview margin displays.");
        this.multiAction.setHelpLocation(new HelpLocation(HELP_TOPIC, HELP_TOPIC));
    }

    public void installOverview(OverviewColorService overviewColorService) {
        overviewColorService.setProgram(this.currentProgram);
        OverviewColorComponent overview = new OverviewColorComponent(this.tool, overviewColorService);
        this.activeServices.put(overviewColorService, overview);
        this.codeViewerService.addOverviewProvider(overview);
        overview.installActions();
    }

    private void uninstallOverview(OverviewColorService overviewColorService) {
        OverviewColorComponent overviewComponent = this.activeServices.get(overviewColorService);
        overviewComponent.uninstallActions();
        this.codeViewerService.removeOverviewProvider(overviewComponent);
        this.activeServices.remove(overviewColorService);
        overviewColorService.setProgram(null);
    }

    @Override
    protected void programActivated(Program program) {
        for (OverviewColorService service : this.activeServices.keySet()) {
            service.setProgram(program);
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        for (OverviewColorService service : this.activeServices.keySet()) {
            service.setProgram(null);
        }
    }

    private class OverviewToggleAction
    extends ToggleDockingAction {
        private OverviewColorService service;

        public OverviewToggleAction(String owner, OverviewColorService service) {
            super(service.getName(), owner);
            this.service = service;
            this.setMenuBarData(new MenuData(new String[]{"Show " + service.getName()}));
            this.setHelpLocation(service.getHelpLocation());
        }

        public void actionPerformed(ActionContext context) {
            if (this.isSelected()) {
                OverviewColorPlugin.this.installOverview(this.service);
            } else {
                OverviewColorPlugin.this.uninstallOverview(this.service);
            }
        }
    }
}

