/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class NextPreviousInstructionAction
extends AbstractNextPreviousAction {
    public NextPreviousInstructionAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Instruction", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.loadImage((String)"images/I.gif");
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Instruction";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInstructionAt(program, address)) {
            address = this.getAddressOfNextPreviousNonInstruction(monitor, program, address, true);
        }
        return this.getAddressOfNextInstructionAfter(program, address);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInstructionAt(program, address)) {
            address = this.getAddressOfNextPreviousNonInstruction(monitor, program, address, false);
        }
        return this.getAddressOfPreviousInstructionBefore(program, address);
    }

    private boolean isInstructionAt(Program program, Address address) {
        if (address == null) {
            return false;
        }
        return program.getListing().getInstructionAt(address) != null;
    }

    private Address getAddressOfNextInstructionAfter(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Instruction instruction = program.getListing().getInstructionAfter(address);
        if (instruction == null) {
            return null;
        }
        return instruction.getMinAddress();
    }

    private Address getAddressOfPreviousInstructionBefore(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Instruction instruction = program.getListing().getInstructionBefore(address);
        if (instruction == null) {
            return null;
        }
        return instruction.getMinAddress();
    }

    private Address getAddressOfNextPreviousNonInstruction(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        CodeUnitIterator codeUnits = program.getListing().getCodeUnits(address, forward);
        while (codeUnits.hasNext()) {
            monitor.checkCanceled();
            CodeUnit codeUnit = codeUnits.next();
            if (!(codeUnit instanceof Data)) continue;
            return codeUnit.getAddress();
        }
        return null;
    }
}

