/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.model.MaskContainer;
import ghidra.app.plugin.core.instructionsearch.model.OperandMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.EndianFlipWidget;
import ghidra.app.plugin.core.instructionsearch.ui.HintTextAreaIS;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.ui.MessagePanel;
import ghidra.app.plugin.core.instructionsearch.ui.SelectionModeWidget;
import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoInstruction;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InsertBytesWidget
extends DialogComponentProvider
implements KeyListener {
    private HintTextAreaIS inputBytesTA;
    private SelectionModeWidget selectionModeWidget;
    private EndianFlipWidget endianFlipWidget;
    private MessagePanel msgPanel;
    private PseudoDisassembler disassembler;
    private InstructionSearchDialog dialog = null;
    private Program program;
    private String errorMsg = "";
    private static String ERROR_MSG_FULL_BYTE = "Input must consist of full bytes (no nibbles or individual bits).";
    private static String ERROR_MSG_HEX_INPUT = "Hex mode selected. Please adjust your input to be valid";
    private static String ERROR_MSG_BINARY_INPUT = "Binary mode selected. Please adjust your input to be valid";
    private static String ERROR_NO_INPUT = "No input specified!";
    private static String ERROR_MSG_GROUPS = "Groups must contain full bytes (no individual bits or nibbles!).";
    private final String HINT_TEXT = "<input hex or binary data; full bytes only>";

    public InsertBytesWidget(Program program, InstructionSearchDialog dialog) {
        super("Edit Bytes", false, true, true, false);
        this.dialog = dialog;
        this.program = program;
        this.disassembler = new PseudoDisassembler(program);
        this.addWorkPanel(this.createWorkPanel());
        this.addApplyButton();
        this.addCancelButton();
    }

    protected void applyCallback() {
        this.disassemble();
    }

    public void loadBytes(String bytes) {
        SystemUtilities.runSwingLater(() -> {
            this.inputBytesTA.setText(bytes);
            this.applyButton.doClick();
        });
    }

    public String getInputString() {
        return this.inputBytesTA.getText();
    }

    public void setInputString(String input) {
        this.inputBytesTA.setText(input);
    }

    protected void dialogShown() {
        this.populateDialog();
        this.toFront();
    }

    protected JPanel createWorkPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setMinimumSize(new Dimension(500, 300));
        this.inputBytesTA = new HintTextAreaIS("<input hex or binary data; full bytes only>");
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.inputBytesTA));
        this.inputBytesTA.addKeyListener(this);
        this.selectionModeWidget = new SelectionModeWidget("Input Mode", this);
        this.endianFlipWidget = new EndianFlipWidget("Endianness", this);
        this.msgPanel = new MessagePanel();
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)this.selectionModeWidget, "West");
        southPanel.add((Component)this.endianFlipWidget, "Center");
        southPanel.add((Component)this.msgPanel, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)scrollPane, "Center");
        contentPanel.add((Component)southPanel, "South");
        return contentPanel;
    }

    public void showError() {
        Msg.showError((Object)this, (Component)this.getComponent(), (String)"Instruction Search Input Error", (Object)this.errorMsg);
    }

    private void populateDialog() {
        this.msgPanel.clear();
        StringBuilder sb = new StringBuilder();
        List<InstructionMetadata> instrs = this.dialog.getSearchData().getInstructions();
        String comb = this.dialog.getSearchData().getCombinedString();
        for (InstructionMetadata instr : instrs) {
            int instrLen = instr.getMaskContainer().toBinaryString().length();
            String instrStr = comb.substring(0, instrLen);
            instrStr = instrStr.replaceAll("\\.", "0");
            comb = comb.substring(instrLen);
            instrStr = InstructionSearchUtils.addSpaceOnByteBoundary(instrStr, SelectionModeWidget.InputMode.BINARY);
            sb.append(instrStr + "\n");
        }
        this.inputBytesTA.setText(sb.toString());
        this.selectionModeWidget.setInputMode(SelectionModeWidget.InputMode.BINARY);
        this.inputBytesTA.setSelectionStart(0);
        this.inputBytesTA.setSelectionEnd(this.inputBytesTA.getText().length());
    }

    public void disassemble() {
        if (this.dialog == null) {
            return;
        }
        this.msgPanel.clear();
        String input = this.inputBytesTA.getText();
        if (!this.validateInput(input)) {
            this.showError();
            return;
        }
        input = this.inputBytesTA.getText().replaceAll("\\s", "");
        if (this.selectionModeWidget.getInputMode() == SelectionModeWidget.InputMode.HEX) {
            input = InstructionSearchUtils.toBinary(input);
        }
        List<Byte> allBytes = InstructionSearchUtils.toByteArray(input);
        ArrayList<InstructionMetadata> instructions = new ArrayList<InstructionMetadata>();
        while (allBytes.size() > 0) {
            try {
                Byte[] bytearray = new Byte[allBytes.size()];
                bytearray = allBytes.toArray(bytearray);
                PseudoInstruction instruction = this.disassembler.disassemble(this.program.getMinAddress(), InstructionSearchUtils.toPrimitive(bytearray));
                InstructionMetadata instructionMD = this.createInstructionMetadata(instruction);
                List<OperandMetadata> operands = this.createOperandMetadata(instruction);
                instructionMD.setOperands(operands);
                instructions.add(instructionMD);
                if (allBytes.size() < instruction.getLength()) {
                    this.msgPanel.setMessageText("Input invalid: unknown disassembly error.", Color.RED);
                    return;
                }
                allBytes.subList(0, instruction.getLength()).clear();
            }
            catch (InsufficientBytesException | UnknownContextException | UnknownInstructionException | MemoryAccessException e) {
                this.msgPanel.setMessageText("Input invalid: unknown disassembly error.", Color.RED);
                Msg.debug((Object)this, (Object)"Error disassembling instruction", (Throwable)e);
                return;
            }
        }
        this.dialog.getSearchData().setInstructions(instructions);
    }

    private List<OperandMetadata> createOperandMetadata(PseudoInstruction instruction) throws MemoryAccessException {
        ArrayList<OperandMetadata> operands = new ArrayList<OperandMetadata>();
        for (int i = 0; i < instruction.getNumOperands(); ++i) {
            OperandMetadata operandMD = new OperandMetadata();
            operandMD.setOpType(instruction.getOperandType(i));
            operandMD.setTextRep(instruction.getDefaultOperandRepresentation(i));
            byte[] mask = instruction.getPrototype().getOperandValueMask(i).getBytes();
            byte[] value = InstructionSearchUtils.byteArrayAnd(mask, instruction.getBytes());
            MaskContainer maskContainer = new MaskContainer(mask, value);
            operandMD.setMaskContainer(maskContainer);
            operands.add(operandMD);
        }
        return operands;
    }

    private InstructionMetadata createInstructionMetadata(PseudoInstruction instruction) throws MemoryAccessException {
        byte[] mask = instruction.getPrototype().getInstructionMask().getBytes();
        byte[] value = this.clearOperandBits(mask, instruction.getBytes());
        MaskContainer mnemonicMask = new MaskContainer(mask, value);
        InstructionMetadata instructionMD = new InstructionMetadata(mnemonicMask);
        instructionMD.setIsInstruction(true);
        instructionMD.setTextRep(instruction.getMnemonicString());
        return instructionMD;
    }

    private byte[] clearOperandBits(byte[] mask, byte[] value) {
        return InstructionSearchUtils.byteArrayAnd(mask, value);
    }

    public boolean validateInput() {
        return this.validateInput(this.inputBytesTA.getText());
    }

    public boolean validateInput(String input) {
        String text = input.trim();
        if (text.isEmpty()) {
            this.errorMsg = ERROR_NO_INPUT;
            return false;
        }
        if (this.selectionModeWidget.getInputMode() == SelectionModeWidget.InputMode.BINARY) {
            try {
                InstructionSearchUtils.getGroupSizes(text, SelectionModeWidget.InputMode.BINARY);
            }
            catch (Exception e) {
                this.inputBytesTA.setError();
                this.errorMsg = ERROR_MSG_GROUPS;
                return false;
            }
            if (!InstructionSearchUtils.isBinary(text)) {
                this.inputBytesTA.setError();
                this.errorMsg = ERROR_MSG_BINARY_INPUT;
                return false;
            }
            if (!InstructionSearchUtils.isFullBinaryByte(text)) {
                this.inputBytesTA.setError();
                this.errorMsg = ERROR_MSG_FULL_BYTE;
                return false;
            }
        } else if (this.selectionModeWidget.getInputMode() == SelectionModeWidget.InputMode.HEX) {
            try {
                InstructionSearchUtils.getGroupSizes(text, SelectionModeWidget.InputMode.HEX);
            }
            catch (Exception e) {
                this.inputBytesTA.setError();
                this.errorMsg = ERROR_MSG_GROUPS;
                return false;
            }
            if (!InstructionSearchUtils.isHex(text)) {
                this.inputBytesTA.setError();
                this.errorMsg = ERROR_MSG_HEX_INPUT;
                return false;
            }
            if (!InstructionSearchUtils.isFullHexByte(text)) {
                this.inputBytesTA.setError();
                this.errorMsg = ERROR_MSG_FULL_BYTE;
                return false;
            }
        }
        this.inputBytesTA.setValid();
        this.errorMsg = "";
        return true;
    }

    public void setInputInvalid() {
        this.inputBytesTA.setError();
        this.errorMsg = this.selectionModeWidget.getInputMode() == SelectionModeWidget.InputMode.BINARY ? ERROR_MSG_BINARY_INPUT : ERROR_MSG_HEX_INPUT;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.validateInput(this.inputBytesTA.getText());
        this.msgPanel.clear();
    }

    public SelectionModeWidget getSelectionModeWidget() {
        return this.selectionModeWidget;
    }
}

