/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.action.DockingActionIf;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.function.tags.EditFunctionTagsAction;
import ghidra.app.plugin.core.function.tags.FunctionTagProvider;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Create, edit, and delete function tags", description="This provides actions for creating, editing, and deleting function tags")
public class FunctionTagPlugin
extends ProgramPlugin {
    public static final String FUNCTION_TAG_MENU_SUBGROUP = "TagFunction";
    private EditFunctionTagsAction editFunctionTagsAction;
    private FunctionTagProvider provider = new FunctionTagProvider(this, this.getCurrentProgram());

    public FunctionTagPlugin(PluginTool tool) {
        super(tool, true, false);
        this.createActions();
    }

    public FunctionTagProvider getProvider() {
        return this.provider;
    }

    public void init() {
        super.init();
    }

    @Override
    protected void programDeactivated(Program program) {
        this.provider.programDeactivated(program);
    }

    @Override
    protected void programActivated(Program program) {
        this.provider.programActivated(program);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        this.provider.locationChanged(loc);
    }

    private void createActions() {
        this.editFunctionTagsAction = new EditFunctionTagsAction("Edit Function Tags", this);
        this.tool.addAction((DockingActionIf)this.editFunctionTagsAction);
    }
}

