/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.builder.ActionBuilder;
import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.analysis.AnalysisBackgroundCommand;
import ghidra.app.plugin.core.analysis.AnalysisOptionsDialog;
import ghidra.app.plugin.core.analysis.AnalysisOptionsEditor;
import ghidra.app.plugin.core.analysis.AnalyzeAllOpenProgramsTask;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.AutoAnalysisManagerListener;
import ghidra.app.plugin.core.analysis.OneShotAnalysisCommand;
import ghidra.app.plugin.core.analysis.StoredAnalyzerTimesPropertyEditor;
import ghidra.app.services.Analyzer;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Analysis", shortDescription="Manages auto-analysis", description="Provides coordination and a service for All Auto Analysis tasks.", eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramActivatedPluginEvent.class})
public class AutoAnalysisPlugin
extends Plugin
implements AutoAnalysisManagerListener {
    private static final String SHOW_ANALYSIS_OPTIONS = "Show Analysis Options";
    private static final String ANALYZE_GROUP_NAME = "Analyze";
    private DockingAction autoAnalyzeAction;
    private DockingAction analyzeAllAction;
    private HelpLocation helpLocation;
    private List<Analyzer> analyzers = new ArrayList<Analyzer>();
    private List<OneShotAnalyzerAction> oneShotActions = new ArrayList<OneShotAnalyzerAction>();

    public AutoAnalysisPlugin(PluginTool tool) {
        super(tool);
        this.findAnalyzers();
        this.createActions();
        ToolOptions options = tool.getOptions("Auto Analysis");
        String description = "This option forces the analysis options dialog to appear whenever auto-analysis action is invoked.";
        this.helpLocation = new HelpLocation("AutoAnalysisPlugin", "AnalysisOptions");
        options.setOptionsHelpLocation(this.helpLocation);
        options.registerOption(SHOW_ANALYSIS_OPTIONS, (Object)true, this.helpLocation, description);
    }

    private void findAnalyzers() {
        this.analyzers.addAll(ClassSearcher.getInstances(Analyzer.class));
        Collections.sort(this.analyzers, (o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    private void createActions() {
        int subGroupIndex = 0;
        this.autoAnalyzeAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Auto Analyze", this.getName()).supportsDefaultToolContext(true)).menuPath(new String[]{"&Analysis", "&Auto Analyze..."})).menuGroup(ANALYZE_GROUP_NAME, "" + subGroupIndex++)).keyBinding("A")).validContextWhen(ac -> {
            this.updateActionName((ActionContext)ac);
            return ac instanceof ListingActionContext;
        })).onAction(this::analyzeCallback)).buildAndInstall((Tool)this.tool);
        this.analyzeAllAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Analyze All Open", this.getName()).supportsDefaultToolContext(true)).menuPath(new String[]{"&Analysis", "Analyze All &Open..."})).menuGroup(ANALYZE_GROUP_NAME, "" + subGroupIndex++)).onAction(c -> this.analyzeAllCallback())).validContextWhen(ac -> ac instanceof ListingActionContext)).buildAndInstall((Tool)this.tool);
        this.tool.setMenuGroup(new String[]{"Analysis", "One Shot"}, ANALYZE_GROUP_NAME);
    }

    private void updateActionName(ActionContext context) {
        String programName = "";
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            programName = listingContext.getProgram().getDomainFile().getName();
        }
        MenuData menuBarData = this.autoAnalyzeAction.getMenuBarData();
        menuBarData.setMenuItemName("&Auto Analyze '" + programName + "'...");
    }

    private void analyzeCallback(ActionContext context) {
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            this.analyzeCallback(listingContext.getProgram(), listingContext.getSelection());
        }
    }

    private void addOneShotActions(Program program) {
        this.removeOneShotActions();
        for (Analyzer analyzer : this.analyzers) {
            if (!analyzer.supportsOneTimeAnalysis() || !analyzer.canAnalyze(program)) continue;
            OneShotAnalyzerAction action = new OneShotAnalyzerAction(analyzer);
            this.oneShotActions.add(action);
            this.tool.addAction((DockingActionIf)action);
        }
    }

    private void removeOneShotActions() {
        for (OneShotAnalyzerAction action : this.oneShotActions) {
            this.tool.removeAction((DockingActionIf)action);
        }
        this.oneShotActions.clear();
    }

    private void analyzeAllCallback() {
        AnalyzeAllOpenProgramsTask task = new AnalyzeAllOpenProgramsTask(this);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }

    private void analyzeCallback(Program program, ProgramSelection selection) {
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
        analysisMgr.initializeOptions();
        if (!this.showOptionsDialog(program)) {
            return;
        }
        analysisMgr.initializeOptions();
        GhidraProgramUtilities.setAnalyzedFlag(program, true);
        this.tool.executeBackgroundCommand((BackgroundCommand)new AnalysisBackgroundCommand(analysisMgr, true), (UndoableDomainObject)program);
        analysisMgr.reAnalyzeAll(selection);
    }

    public static String getDescription() {
        return "Provides coordination and a service for All Auto Analysis tasks";
    }

    public static String getDescriptiveName() {
        return "AutoAnalysisManager";
    }

    public static String getCategory() {
        return "Analysis";
    }

    protected void programClosed(Program program) {
        if (AutoAnalysisManager.hasAutoAnalysisManager(program)) {
            AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
            analysisMgr.removeTool(this.tool);
            analysisMgr.removeListener(this);
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)event;
            this.programClosed(ev.getProgram());
        } else if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)event;
            this.programOpened(ev.getProgram());
        } else if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program program = ev.getActiveProgram();
            if (program == null) {
                this.removeOneShotActions();
            } else {
                this.programActivated(program);
                this.addOneShotActions(program);
            }
        }
    }

    protected void programOpened(Program program) {
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
        analysisMgr.addTool(this.tool);
        analysisMgr.addListener(this);
        Options options = program.getOptions("Analyzers");
        options.registerOptionsEditor((OptionsEditor)new AnalysisOptionsEditor(program));
        options.setOptionsHelpLocation(new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option"));
    }

    private void programActivated(Program program) {
        program.getOptions("Program Information.Analysis Times").registerOption("Times", OptionType.CUSTOM_TYPE, null, null, "Cumulative analysis task times", (PropertyEditor)new StoredAnalyzerTimesPropertyEditor());
        SwingUtilities.invokeLater(() -> {
            if (program.isClosed()) {
                return;
            }
            AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
            if (analysisMgr.askToAnalyze(this.tool)) {
                this.analyzeCallback(program, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showOptionsDialog(Program program) {
        this.tool.clearStatusInfo();
        ToolOptions options = this.tool.getOptions("Auto Analysis");
        boolean showDialog = options.getBoolean(SHOW_ANALYSIS_OPTIONS, true);
        if (!showDialog) {
            return true;
        }
        int id = program.startTransaction("Analysis Options");
        try {
            AnalysisOptionsDialog dialog = new AnalysisOptionsDialog(program);
            this.tool.showDialog((DialogComponentProvider)dialog);
            boolean bl = dialog.wasAnalyzeButtonSelected();
            return bl;
        }
        finally {
            program.endTransaction(id, true);
        }
    }

    @Override
    public void analysisEnded(AutoAnalysisManager manager) {
        MessageLog log = manager.getMessageLog();
        if (log.hasMessages()) {
            log.write(AutoAnalysisManager.class, "Analysis Log Messages");
            String shortMessage = "There were warnings/errors issued during analysis.";
            String detailedMessage = "(These messages are also written to the application log file)\n\n" + log.toString();
            MultiLineMessageDialog dialog = new MultiLineMessageDialog("Auto Analysis Summary", shortMessage, detailedMessage, 2, false);
            DockingWindowManager.showDialog(null, (DialogComponentProvider)dialog);
        }
    }

    class OneShotAnalyzerAction
    extends DockingAction {
        private Analyzer analyzer;
        private Program canAnalyzeProgram;
        private boolean canAnalyze;

        public OneShotAnalyzerAction(Analyzer analyzer) {
            super(analyzer.getName(), AutoAnalysisPlugin.this.getName());
            this.analyzer = analyzer;
            this.setMenuBarData(new MenuData(new String[]{"Analysis", "One Shot", analyzer.getName()}, null, AutoAnalysisPlugin.ANALYZE_GROUP_NAME));
            this.setHelpLocation(new HelpLocation("AutoAnalysisPlugin", "Auto_Analyzers"));
            this.setEnabled(false);
            this.setSupportsDefaultToolContext(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!(context instanceof ListingActionContext)) {
                return;
            }
            ListingActionContext programContext = (ListingActionContext)context;
            ProgramSelection set = programContext.hasSelection() ? programContext.getSelection() : programContext.getProgram().getMemory();
            AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(programContext.getProgram());
            Program program = programContext.getProgram();
            Options options = program.getOptions("Analyzers");
            options = options.getOptions(this.analyzer.getName());
            this.analyzer.optionsChanged(options, program);
            analysisMgr.schedule(new OneShotAnalysisCommand(this.analyzer, set, analysisMgr.getMessageLog()), this.analyzer.getPriority().priority());
            AutoAnalysisPlugin.this.tool.setStatusInfo("Analysis scheduled: " + this.analyzer.getName());
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!(context instanceof ListingActionContext)) {
                return false;
            }
            ListingActionContext programContext = (ListingActionContext)context;
            Program p = programContext.getProgram();
            if (p != this.canAnalyzeProgram) {
                this.canAnalyzeProgram = p;
                this.canAnalyze = this.analyzer.canAnalyze(p);
            }
            return this.canAnalyze;
        }
    }
}

