/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.algorithmtree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.cmd.module.ModuleAlgorithmCmd;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.BlockModelServiceListener;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Program Tree", shortDescription="Apply Module Algorithm to a folder or fragment", description="This plugin applies the \"module\" algorithm  to a Folder or Fragment in a program tree. This algorithm first applies the Multiple Entry Point Subroutine model, which generates fragments; then the algorithm applies the Partitioned Code Subroutine model to these fragments.", servicesRequired={BlockModelService.class})
public class ModuleAlgorithmPlugin
extends ProgramPlugin
implements BlockModelServiceListener {
    private DockingAction[] actions;
    private BlockModelService blockModelService;

    public ModuleAlgorithmPlugin(PluginTool tool) {
        super(tool, false, false);
    }

    protected void init() {
        this.blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        this.blockModelService.addListener(this);
        this.updateSubroutineActions();
    }

    public void dispose() {
        super.dispose();
        if (this.blockModelService != null) {
            this.blockModelService.removeListener(this);
            this.blockModelService = null;
        }
    }

    private void updateSubroutineActions() {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                this.tool.removeAction((DockingActionIf)this.actions[i]);
                this.actions[i] = null;
            }
            this.actions = null;
        }
        HelpLocation loc = new HelpLocation("ProgramTreePlugin", "Modularize_By_Subroutine");
        String[] subModels = this.blockModelService.getAvailableModelNames(2);
        if (subModels.length > 1) {
            this.actions = new DockingAction[subModels.length];
            for (int i = 0; i < subModels.length; ++i) {
                final String modelName = subModels[i];
                this.actions[i] = new DockingAction("Modularize By Subroutine [" + modelName + "]", this.getName()){

                    public void actionPerformed(ActionContext context) {
                        ModuleAlgorithmPlugin.this.applyModuleAlgorithm(modelName, context.getContextObject());
                    }

                    public boolean isEnabledForContext(ActionContext context) {
                        if (context.getContextObject() instanceof ProgramNode) {
                            return super.isEnabledForContext(context);
                        }
                        return false;
                    }
                };
                this.actions[i].setPopupMenuData(new MenuData(new String[]{"Modularize By", "Subroutine", subModels[i]}, null, "select"));
                this.tool.addAction((DockingActionIf)this.actions[i]);
                this.actions[i].setEnabled(this.currentProgram != null);
                this.actions[i].setHelpLocation(loc);
            }
        } else {
            this.actions = new DockingAction[1];
            this.actions[0] = new DockingAction("Modularize By Subroutine", this.getName()){

                public void actionPerformed(ActionContext context) {
                    ModuleAlgorithmPlugin.this.applyModuleAlgorithm(null, context.getContextObject());
                }

                public boolean isEnabledForContext(ActionContext context) {
                    if (context.getContextObject() instanceof ProgramNode) {
                        return super.isEnabledForContext(context);
                    }
                    return false;
                }
            };
            this.actions[0].setPopupMenuData(new MenuData(new String[]{"Modularize By", "Subroutine"}, "select"));
            this.tool.addAction((DockingActionIf)this.actions[0]);
            this.actions[0].setEnabled(this.currentProgram != null);
            this.actions[0].setHelpLocation(loc);
        }
    }

    private void applyModuleAlgorithm(String modelName, Object activeObject) {
        ProgramNode node = (ProgramNode)activeObject;
        ModuleAlgorithmCmd cmd = new ModuleAlgorithmCmd(node.getGroupPath(), node.getGroup().getTreeName(), this.blockModelService, modelName);
        cmd.setPluginTool(this.tool);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)this.currentProgram);
    }

    @Override
    protected void programDeactivated(Program program) {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i].setEnabled(false);
            }
        }
    }

    @Override
    protected void programActivated(Program program) {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i].setEnabled(true);
            }
        }
    }

    @Override
    public void modelAdded(String modeName, int modelType) {
        if (modelType == 2) {
            this.updateSubroutineActions();
        }
    }

    @Override
    public void modelRemoved(String modeName, int modelType) {
        if (modelType == 2) {
            this.updateSubroutineActions();
        }
    }
}

