/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public interface PathPredicates {
    public boolean matches(List<String> var1);

    public boolean successorCouldMatch(List<String> var1, boolean var2);

    public boolean ancestorMatches(List<String> var1, boolean var2);

    public Set<String> getNextNames(List<String> var1);

    public Set<String> getNextIndices(List<String> var1);

    public List<String> getSingletonPath();

    public PathPattern getSingletonPattern();

    public static boolean anyMatches(Set<String> pats, String key) {
        for (String pat : pats) {
            if ("".equals(pat)) {
                return true;
            }
            if (!key.equals(pat)) continue;
            return true;
        }
        return false;
    }

    default public NavigableMap<List<String>, ?> getCachedValues(TargetObject seed) {
        return this.getCachedValues(List.of(), seed);
    }

    default public NavigableMap<List<String>, ?> getCachedValues(List<String> path, Object val) {
        TreeMap<List<String>, Object> result = new TreeMap<List<String>, Object>(PathUtils.PathComparator.KEYED);
        this.getCachedValues(result, path, val);
        return result;
    }

    default public void getCachedValues(Map<List<String>, Object> result, List<String> path, Object val) {
        if (this.matches(path)) {
            result.put(path, val);
        }
        if (val instanceof TargetObject && this.successorCouldMatch(path, true)) {
            Set<String> nextIndices;
            TargetObject cur = (TargetObject)val;
            Set<String> nextNames = this.getNextNames(path);
            if (!nextNames.isEmpty()) {
                for (Map.Entry<String, ?> ent : cur.getCachedAttributes().entrySet()) {
                    Object value = ent.getValue();
                    String name = ent.getKey();
                    if (!PathPredicates.anyMatches(nextNames, name)) continue;
                    this.getCachedValues(result, PathUtils.extend(path, name), value);
                }
            }
            if (!(nextIndices = this.getNextIndices(path)).isEmpty()) {
                for (Map.Entry<String, ? extends TargetObject> ent : cur.getCachedElements().entrySet()) {
                    TargetObject obj = ent.getValue();
                    String index = ent.getKey();
                    if (!PathPredicates.anyMatches(nextIndices, index)) continue;
                    this.getCachedValues(result, PathUtils.index(path, index), obj);
                }
            }
        }
    }

    default public NavigableMap<List<String>, TargetObject> getCachedSuccessors(TargetObject seed) {
        TreeMap<List<String>, TargetObject> result = new TreeMap<List<String>, TargetObject>(PathUtils.PathComparator.KEYED);
        this.getCachedSuccessors(result, List.of(), seed);
        return result;
    }

    default public void getCachedSuccessors(Map<List<String>, TargetObject> result, List<String> path, TargetObject cur) {
        if (this.matches(path)) {
            result.put(path, cur);
        }
        if (this.successorCouldMatch(path, true)) {
            Set<String> nextIndices;
            Set<String> nextNames = this.getNextNames(path);
            if (!nextNames.isEmpty()) {
                for (Map.Entry<String, ?> ent : cur.getCachedAttributes().entrySet()) {
                    String name;
                    Object value = ent.getValue();
                    if (!(value instanceof TargetObject) || !PathPredicates.anyMatches(nextNames, name = ent.getKey())) continue;
                    TargetObject obj = (TargetObject)value;
                    this.getCachedSuccessors(result, PathUtils.extend(path, name), obj);
                }
            }
            if (!(nextIndices = this.getNextIndices(path)).isEmpty()) {
                for (Map.Entry<String, ? extends TargetObject> ent : cur.getCachedElements().entrySet()) {
                    TargetObject obj = ent.getValue();
                    String index = ent.getKey();
                    if (!PathPredicates.anyMatches(nextIndices, index)) continue;
                    this.getCachedSuccessors(result, PathUtils.index(path, index), obj);
                }
            }
        }
    }

    default public CompletableFuture<NavigableMap<List<String>, TargetObject>> fetchSuccessors(TargetObject seed) {
        TreeMap<List<String>, TargetObject> result = new TreeMap<List<String>, TargetObject>(PathUtils.PathComparator.KEYED);
        return this.fetchSuccessors(result, List.of(), seed).thenApply(__ -> result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public CompletableFuture<Void> fetchSuccessors(Map<List<String>, TargetObject> result, List<String> path, TargetObject cur) {
        AsyncFence fence = new AsyncFence();
        if (this.matches(path)) {
            Map<List<String>, TargetObject> map = result;
            synchronized (map) {
                result.put(path, cur);
            }
        }
        if (this.successorCouldMatch(path, true)) {
            Set<String> nextIndices;
            Set<String> nextNames = this.getNextNames(path);
            if (!nextNames.isEmpty()) {
                fence.include((CompletableFuture)cur.fetchAttributes().thenCompose(attrs -> {
                    AsyncFence aFence = new AsyncFence();
                    for (Map.Entry ent : attrs.entrySet()) {
                        String name;
                        Object value = ent.getValue();
                        if (!(value instanceof TargetObject) || !PathPredicates.anyMatches(nextNames, name = (String)ent.getKey())) continue;
                        TargetObject obj = (TargetObject)value;
                        aFence.include(this.fetchSuccessors(result, PathUtils.extend(path, name), obj));
                    }
                    return aFence.ready();
                }));
            }
            if (!(nextIndices = this.getNextIndices(path)).isEmpty()) {
                fence.include((CompletableFuture)cur.fetchElements().thenCompose(elems -> {
                    AsyncFence eFence = new AsyncFence();
                    for (Map.Entry ent : elems.entrySet()) {
                        TargetObject obj = (TargetObject)ent.getValue();
                        String index = (String)ent.getKey();
                        if (!PathPredicates.anyMatches(nextIndices, index)) continue;
                        eFence.include(this.fetchSuccessors(result, PathUtils.index(path, index), obj));
                    }
                    return eFence.ready();
                }));
            }
        }
        return fence.ready();
    }

    public PathPredicates applyIndices(List<String> var1);

    default public PathPredicates applyIndices(String ... indices) {
        return this.applyIndices(List.of(indices));
    }

    public boolean isEmpty();
}

