/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.attributes.TargetDataType;
import ghidra.dbg.attributes.TargetObjectList;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.DefaultSchemaContext;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum EnumerableTargetObjectSchema implements TargetObjectSchema
{
    ANY("ANY", new Class[]{Object.class}){

        @Override
        public TargetObjectSchema.SchemaName getDefaultElementSchema() {
            return OBJECT.getName();
        }

        @Override
        public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
            return TargetObjectSchema.AttributeSchema.DEFAULT_ANY;
        }
    }
    ,
    OBJECT("OBJECT", new Class[]{TargetObject.class}){

        @Override
        public TargetObjectSchema.SchemaName getDefaultElementSchema() {
            return OBJECT.getName();
        }

        @Override
        public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
            return TargetObjectSchema.AttributeSchema.DEFAULT_ANY;
        }
    }
    ,
    VOID("VOID", Void.class, Void.TYPE),
    BOOL("BOOL", Boolean.class, Boolean.TYPE),
    BYTE("BYTE", Byte.class, Byte.TYPE),
    SHORT("SHORT", Short.class, Short.TYPE),
    INT("INT", Integer.class, Integer.TYPE),
    LONG("LONG", Long.class, Long.TYPE),
    STRING("STRING", String.class),
    ADDRESS("ADDRESS", Address.class),
    RANGE("RANGE", AddressRange.class),
    DATA_TYPE("DATA_TYPE", TargetDataType.class),
    LIST_OBJECT("LIST_OBJECT", TargetObjectList.class),
    MAP_PARAMETERS("MAP_PARAMETERS", TargetMethod.TargetParameterMap.class),
    SET_ATTACH_KIND("SET_ATTACH_KIND", TargetAttacher.TargetAttachKindSet.class),
    SET_BREAKPOINT_KIND("SET_BREAKPOINT_KIND", TargetBreakpointSpecContainer.TargetBreakpointKindSet.class),
    SET_STEP_KIND("SET_STEP_KIND", TargetSteppable.TargetStepKindSet.class),
    EXECUTION_STATE("EXECUTION_STATE", TargetExecutionStateful.TargetExecutionState.class);

    private final TargetObjectSchema.SchemaName name;
    private final List<Class<?>> types;

    public static EnumerableTargetObjectSchema schemaForPrimitive(Class<?> cls) {
        for (EnumerableTargetObjectSchema schema : EnumerableTargetObjectSchema.values()) {
            if (!schema.getTypes().contains(cls)) continue;
            return schema;
        }
        return null;
    }

    public static TargetObjectSchema.SchemaName nameForPrimitive(Class<?> cls) {
        EnumerableTargetObjectSchema schema = EnumerableTargetObjectSchema.schemaForPrimitive(cls);
        return schema == null ? null : schema.getName();
    }

    private EnumerableTargetObjectSchema(String name, Class<?> ... types) {
        this.name = new TargetObjectSchema.SchemaName(name);
        this.types = List.of(types);
    }

    @Override
    public SchemaContext getContext() {
        return MinimalSchemaContext.INSTANCE;
    }

    @Override
    public TargetObjectSchema.SchemaName getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.types.get(0);
    }

    public List<Class<?>> getTypes() {
        return this.types;
    }

    @Override
    public Set<Class<? extends TargetObject>> getInterfaces() {
        return Set.of();
    }

    @Override
    public boolean isCanonicalContainer() {
        return false;
    }

    @Override
    public Map<String, TargetObjectSchema.SchemaName> getElementSchemas() {
        return Map.of();
    }

    @Override
    public TargetObjectSchema.SchemaName getDefaultElementSchema() {
        return VOID.getName();
    }

    @Override
    public TargetObjectSchema.ResyncMode getElementResyncMode() {
        return TargetObjectSchema.DEFAULT_ELEMENT_RESYNC;
    }

    @Override
    public Map<String, TargetObjectSchema.AttributeSchema> getAttributeSchemas() {
        return Map.of();
    }

    @Override
    public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return TargetObjectSchema.AttributeSchema.DEFAULT_VOID;
    }

    @Override
    public TargetObjectSchema.ResyncMode getAttributeResyncMode() {
        return TargetObjectSchema.DEFAULT_ATTRIBUTE_RESYNC;
    }

    @Override
    public PathMatcher searchFor(Class<? extends TargetObject> type, boolean requireCanonical) {
        return new PathMatcher();
    }

    @Override
    public List<String> searchForCanonicalContainer(Class<? extends TargetObject> type) {
        return null;
    }

    @Override
    public List<String> searchForSuitable(Class<? extends TargetObject> type, List<String> path) {
        return null;
    }

    public static final class MinimalSchemaContext
    extends DefaultSchemaContext {
        public static final SchemaContext INSTANCE = new MinimalSchemaContext();
    }
}

