/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedThreadRecorder;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.trace.model.thread.TraceThread;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public class RecorderThreadMap {
    protected final NavigableSet<Integer> observedThreadPathLengths = new TreeSet<Integer>();
    protected final Map<TargetThread, ManagedThreadRecorder> byTargetThread = new HashMap<TargetThread, ManagedThreadRecorder>();
    protected final Map<TraceThread, ManagedThreadRecorder> byTraceThread = new HashMap<TraceThread, ManagedThreadRecorder>();

    public void put(ManagedThreadRecorder rec) {
        this.observedThreadPathLengths.add(rec.getTargetThread().getPath().size());
        this.byTargetThread.put(rec.getTargetThread(), rec);
        this.byTraceThread.put(rec.getTraceThread(), rec);
    }

    public ManagedThreadRecorder get(TargetThread thread) {
        return this.byTargetThread.get(thread);
    }

    public ManagedThreadRecorder get(TargetObject maybeThread) {
        return this.byTargetThread.get(maybeThread);
    }

    public ManagedThreadRecorder get(TraceThread thread) {
        return this.byTraceThread.get(thread);
    }

    public void remove(ManagedThreadRecorder rec) {
        ManagedThreadRecorder rByTarget = this.byTargetThread.remove(rec.getTargetThread());
        ManagedThreadRecorder rByTrace = this.byTraceThread.remove(rec.getTraceThread());
        assert (rec == rByTarget);
        assert (rec == rByTrace);
    }

    public Collection<ManagedThreadRecorder> recorders() {
        return this.byTargetThread.values();
    }
}

