/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import java.util.Set;

public class GdbPowerPCDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_PPC32_BE = new LanguageID("PowerPC:BE:32:default");
    protected static final LanguageID LANG_ID_PPC64_BE = new LanguageID("PowerPC:BE:64:default");
    protected static final LanguageID LANG_ID_PPC64_BE_A2 = new LanguageID("PowerPC:BE:64:A2-32addr");
    protected static final LanguageID LANG_ID_PPC64_BE_A2ALT = new LanguageID("PowerPC:BE:64:A2ALT-32addr");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");

    @Override
    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetProcess process, boolean includeOverrides) {
        if (!env.getDebugger().toLowerCase().contains("gdb")) {
            return Set.of();
        }
        String os = env.getOperatingSystem();
        if (!os.contains("Linux")) {
            return Set.of();
        }
        String endian = env.getEndian();
        if (!endian.contains("big")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        if (arch.startsWith("powerpc:32")) {
            return Set.of(new GdbPowerPCBE32DefLinuxOffer(process));
        }
        if (arch.startsWith("powerpc:A2")) {
            return Set.of(new GdbPowerPCBE64A2LinuxOffer(process));
        }
        if (arch.startsWith("powerpc:A2-Alt")) {
            return Set.of(new GdbPowerPCBA64A2AltLinuxOffer(process));
        }
        if (arch.startsWith("powerpc")) {
            return Set.of(new GdbPowerPCBE64DefLinuxOffer(process));
        }
        return Set.of();
    }

    protected static class GdbPowerPCBA64A2AltLinuxOffer
    extends DefaultDebuggerMappingOffer {
        public GdbPowerPCBA64A2AltLinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux PowerPC - 64-bit A2 ALT", LANG_ID_PPC64_BE_A2ALT, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbPowerPCBE64A2LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public GdbPowerPCBE64A2LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux PowerPC - 64-bit A2", LANG_ID_PPC64_BE_A2, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbPowerPCBE64DefLinuxOffer
    extends DefaultDebuggerMappingOffer {
        public GdbPowerPCBE64DefLinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux PowerPC - 64-bit", LANG_ID_PPC64_BE, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbPowerPCBE32DefLinuxOffer
    extends DefaultDebuggerMappingOffer {
        public GdbPowerPCBE32DefLinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux PowerPC - 32-bit", LANG_ID_PPC32_BE, COMP_ID_DEFAULT, Set.of());
        }
    }
}

