/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.MultiStateActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.app.plugin.core.debug.gui.action.DebuggerAutoReadMemoryAction;
import ghidra.app.plugin.core.debug.utils.BackgroundUtils;
import ghidra.app.services.TraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathMatcher;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public abstract class DebuggerReadsMemoryTrait {
    protected static final AutoConfigState.ClassHandler<DebuggerReadsMemoryTrait> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerReadsMemoryTrait.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected MultiStateDockingAction<AutoReadMemorySpec> actionAutoRead;
    protected RefreshSelectedMemoryAction actionRefreshSelected;
    private final AutoReadMemorySpec defaultAutoSpec;
    @AutoConfigStateField(codec=AutoReadMemorySpec.AutoReadMemorySpecConfigFieldCodec.class)
    protected AutoReadMemorySpec autoSpec;
    protected final PluginTool tool;
    protected final Plugin plugin;
    protected final ComponentProvider provider;
    protected final ForReadsTraceListener traceListener;
    protected final ForAccessRecorderListener recorderListener;
    protected final ForVisibilityListener displayListener;
    protected DebuggerCoordinates current;
    protected AddressSetView visible;

    public DebuggerReadsMemoryTrait(PluginTool tool, Plugin plugin, ComponentProvider provider) {
        this.autoSpec = this.defaultAutoSpec = AutoReadMemorySpec.fromConfigName("READ_VIS_RO_ONCE");
        this.traceListener = new ForReadsTraceListener();
        this.recorderListener = new ForAccessRecorderListener();
        this.displayListener = new ForVisibilityListener();
        this.current = DebuggerCoordinates.NOWHERE;
        this.tool = tool;
        this.plugin = plugin;
        this.provider = provider;
    }

    protected boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getRecorder(), b.getRecorder());
    }

    protected void addNewTraceListener() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().addListener((DomainObjectListener)this.traceListener);
        }
    }

    protected void removeOldTraceListener() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().removeListener((DomainObjectListener)this.traceListener);
        }
    }

    protected void addNewRecorderListener() {
        if (this.current.getRecorder() != null) {
            this.current.getRecorder().addListener(this.recorderListener);
        }
    }

    protected void removeOldRecorderListener() {
        if (this.current.getRecorder() != null) {
            this.current.getRecorder().removeListener(this.recorderListener);
        }
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        boolean doRecListener;
        if (this.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        boolean doTraceListener = !Objects.equals(this.current.getTrace(), coordinates.getTrace());
        boolean bl = doRecListener = !Objects.equals(this.current.getRecorder(), coordinates.getRecorder());
        if (doTraceListener) {
            this.removeOldTraceListener();
        }
        if (doRecListener) {
            this.removeOldRecorderListener();
        }
        this.current = coordinates;
        if (doTraceListener) {
            this.addNewTraceListener();
        }
        if (doRecListener) {
            this.addNewRecorderListener();
        }
        this.doAutoRead();
    }

    protected void doAutoRead() {
        this.autoSpec.readMemory(this.tool, this.current, this.visible).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could not auto-read memory: " + ex));
            return null;
        });
    }

    public MultiStateDockingAction<AutoReadMemorySpec> installAutoReadAction() {
        this.actionAutoRead = (MultiStateDockingAction)((MultiStateActionBuilder)DebuggerAutoReadMemoryAction.builder(this.plugin).onAction(this::activatedAutoRead)).onActionStateChanged(this::changedAutoReadMemory).buildAndInstallLocal(this.provider);
        this.actionAutoRead.setCurrentActionStateByUserData((Object)this.defaultAutoSpec);
        return this.actionAutoRead;
    }

    protected void activatedAutoRead(ActionContext ctx) {
        this.doAutoRead();
    }

    protected void changedAutoReadMemory(ActionState<AutoReadMemorySpec> newState, EventTrigger trigger) {
        this.doSetAutoRead((AutoReadMemorySpec)newState.getUserData());
    }

    protected void doSetAutoRead(AutoReadMemorySpec spec) {
        this.autoSpec = spec;
        if (this.visible != null) {
            this.doAutoRead();
        }
    }

    public DockingAction installRefreshSelectedAction() {
        this.actionRefreshSelected = new RefreshSelectedMemoryAction();
        this.provider.addLocalAction((DockingActionIf)this.actionRefreshSelected);
        return this.actionRefreshSelected;
    }

    public AddressSetDisplayListener getDisplayListener() {
        return this.displayListener;
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionAutoRead.setCurrentActionStateByUserData((Object)this.autoSpec);
    }

    public void setAutoSpec(AutoReadMemorySpec autoSpec) {
        this.actionAutoRead.setCurrentActionStateByUserData((Object)autoSpec);
    }

    public AutoReadMemorySpec getAutoSpec() {
        return this.autoSpec;
    }

    public AddressSetView getVisible() {
        return this.visible;
    }

    protected abstract AddressSetView getSelection();

    protected abstract void repaintPanel();

    protected class ForVisibilityListener
    implements AddressSetDisplayListener {
        protected ForVisibilityListener() {
        }

        public void visibleAddressesChanged(AddressSetView visibleAddresses) {
            if (Objects.equals(DebuggerReadsMemoryTrait.this.visible, visibleAddresses)) {
                return;
            }
            DebuggerReadsMemoryTrait.this.visible = visibleAddresses;
            DebuggerReadsMemoryTrait.this.doAutoRead();
        }
    }

    protected class ForAccessRecorderListener
    implements TraceRecorderListener {
        protected ForAccessRecorderListener() {
        }

        @Override
        public void processMemoryAccessibilityChanged(TraceRecorder recorder) {
            Swing.runIfSwingOrRunLater(() -> DebuggerReadsMemoryTrait.this.actionRefreshSelected.updateEnabled(null));
        }
    }

    protected class ForReadsTraceListener
    extends TraceDomainObjectListener {
        public ForReadsTraceListener() {
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.ADDED, this::snapshotAdded);
            this.listenFor((TraceChangeType)Trace.TraceMemoryStateChangeType.CHANGED, this::memStateChanged);
        }

        private void snapshotAdded(TraceSnapshot snapshot) {
            DebuggerReadsMemoryTrait.this.actionRefreshSelected.updateEnabled(null);
        }

        private void memStateChanged(TraceAddressSnapRange range, TraceMemoryState oldIsNull, TraceMemoryState newState) {
            if (DebuggerReadsMemoryTrait.this.current.getView() == null) {
                return;
            }
            if (!range.getLifespan().contains((Comparable)DebuggerReadsMemoryTrait.this.current.getSnap())) {
                return;
            }
            DebuggerReadsMemoryTrait.this.repaintPanel();
            if (newState == TraceMemoryState.UNKNOWN) {
                DebuggerReadsMemoryTrait.this.doAutoRead();
            }
        }
    }

    protected class RefreshSelectedMemoryAction
    extends DebuggerResources.AbstractRefreshSelectedMemoryAction {
        public static final String GROUP = "Dbg1. General";

        public RefreshSelectedMemoryAction() {
            super(DebuggerReadsMemoryTrait.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerReadsMemoryTrait.this.current.isAliveAndReadsPresent()) {
                return;
            }
            AddressSetView selection = DebuggerReadsMemoryTrait.this.getSelection();
            if (selection == null || selection.isEmpty()) {
                selection = DebuggerReadsMemoryTrait.this.visible;
            }
            AddressSetView sel = selection;
            Trace trace = DebuggerReadsMemoryTrait.this.current.getTrace();
            TraceRecorder recorder = DebuggerReadsMemoryTrait.this.current.getRecorder();
            BackgroundUtils.async(DebuggerReadsMemoryTrait.this.tool, trace, "Read Selected Memory", true, true, false, (_t, monitor) -> {
                TargetObject target = recorder.getTarget();
                DebuggerObjectModel model = target.getModel();
                model.invalidateAllLocalCaches();
                PathMatcher memMatcher = target.getSchema().searchFor(TargetMemory.class, true);
                Collection memories = memMatcher.getCachedSuccessors(target).values();
                CompletableFuture[] requests = (CompletableFuture[])memories.stream().map(TargetObject::invalidateCaches).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(requests).thenCompose(_r -> recorder.captureProcessMemory(sel, (TaskMonitor)monitor, false));
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            TraceRecorder recorder;
            if (!DebuggerReadsMemoryTrait.this.current.isAliveAndReadsPresent()) {
                return false;
            }
            AddressSetView selection = DebuggerReadsMemoryTrait.this.getSelection();
            if (selection == null || selection.isEmpty()) {
                selection = DebuggerReadsMemoryTrait.this.visible;
            }
            return (recorder = DebuggerReadsMemoryTrait.this.current.getRecorder()).getAccessibleProcessMemory().contains(selection);
        }

        public void updateEnabled(ActionContext context) {
            this.setEnabled(this.isEnabledForContext(context));
        }
    }
}

