/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug;

import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.DefaultTraceTimeViewport;
import ghidra.trace.util.TraceTimeViewport;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.jdom.Element;

public class DebuggerCoordinates {
    public static final DebuggerCoordinates NOWHERE = new DebuggerCoordinates(null, null, null, null, TraceSchedule.ZERO, 0){

        @Override
        public void writeDataState(PluginTool tool, SaveState saveState, String key) {
        }
    };
    private static final String KEY_TRACE_PROJ_LOC = "TraceProjLoc";
    private static final String KEY_TRACE_PROJ_NAME = "TraceProjName";
    private static final String KEY_TRACE_PATH = "TracePath";
    private static final String KEY_TRACE_VERSION = "TraceVersion";
    private static final String KEY_THREAD_KEY = "ThreadKey";
    private static final String KEY_TIME = "Time";
    private static final String KEY_FRAME = "Frame";
    private final Trace trace;
    private final TraceRecorder recorder;
    private final TraceThread thread;
    private final TraceProgramView view;
    private final TraceSchedule time;
    private final Integer frame;
    private final int hash;
    private Long viewSnap;
    private DefaultTraceTimeViewport viewport;

    public static DebuggerCoordinates all(Trace trace, TraceRecorder recorder, TraceThread thread, TraceProgramView view, TraceSchedule time, Integer frame) {
        if (trace == DebuggerCoordinates.NOWHERE.trace && recorder == DebuggerCoordinates.NOWHERE.recorder && thread == DebuggerCoordinates.NOWHERE.thread && view == DebuggerCoordinates.NOWHERE.view && time == DebuggerCoordinates.NOWHERE.time && frame == DebuggerCoordinates.NOWHERE.frame) {
            return NOWHERE;
        }
        return new DebuggerCoordinates(trace, recorder, thread, view, time, frame);
    }

    public static DebuggerCoordinates trace(Trace trace) {
        if (trace == null) {
            return NOWHERE;
        }
        return DebuggerCoordinates.all(trace, null, null, null, null, null);
    }

    public static DebuggerCoordinates recorder(TraceRecorder recorder) {
        return DebuggerCoordinates.all(recorder == null ? null : recorder.getTrace(), recorder, null, null, recorder == null ? null : TraceSchedule.snap((long)recorder.getSnap()), null);
    }

    public static DebuggerCoordinates thread(TraceThread thread) {
        return DebuggerCoordinates.all(thread == null ? null : thread.getTrace(), null, thread, null, null, null);
    }

    public static DebuggerCoordinates view(TraceProgramView view) {
        return DebuggerCoordinates.all(view == null ? null : view.getTrace(), null, null, view, view == null ? null : TraceSchedule.snap((long)view.getSnap()), null);
    }

    public static DebuggerCoordinates snap(long snap) {
        return DebuggerCoordinates.all(null, null, null, null, TraceSchedule.snap((long)snap), null);
    }

    public static DebuggerCoordinates time(String time) {
        return DebuggerCoordinates.time(TraceSchedule.parse((String)time));
    }

    public static DebuggerCoordinates time(TraceSchedule time) {
        return DebuggerCoordinates.all(null, null, null, null, time, null);
    }

    public static DebuggerCoordinates frame(int frame) {
        return DebuggerCoordinates.all(null, null, null, null, null, frame);
    }

    public static DebuggerCoordinates threadSnap(TraceThread thread, long snap) {
        return DebuggerCoordinates.all(thread == null ? null : thread.getTrace(), null, thread, null, TraceSchedule.snap((long)snap), null);
    }

    public static boolean equalsIgnoreRecorderAndView(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.trace, b.trace)) {
            return false;
        }
        if (!Objects.equals(a.thread, b.thread)) {
            return false;
        }
        if (!Objects.equals(a.time, b.time)) {
            return false;
        }
        return Objects.equals(a.frame, b.frame);
    }

    protected DebuggerCoordinates(Trace trace, TraceRecorder recorder, TraceThread thread, TraceProgramView view, TraceSchedule time, Integer frame) {
        this.trace = trace;
        this.recorder = recorder;
        this.thread = thread;
        this.view = view;
        this.time = time;
        this.frame = frame;
        this.hash = Objects.hash(trace, recorder, thread, view, time, frame);
    }

    public String toString() {
        return String.format("Coords(trace=%s,recorder=%s,thread=%s,view=%s,time=%s,frame=%d)", this.trace, this.recorder, this.thread, this.view, this.time, this.frame);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerCoordinates)) {
            return false;
        }
        DebuggerCoordinates that = (DebuggerCoordinates)obj;
        if (!Objects.equals(this.trace, that.trace)) {
            return false;
        }
        if (!Objects.equals(this.recorder, that.recorder)) {
            return false;
        }
        if (!Objects.equals(this.thread, that.thread)) {
            return false;
        }
        if (!Objects.equals(this.view, that.view)) {
            return false;
        }
        if (!Objects.equals(this.time, that.time)) {
            return false;
        }
        return Objects.equals(this.frame, that.frame);
    }

    public int hashCode() {
        return this.hash;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public TraceRecorder getRecorder() {
        return this.recorder;
    }

    public DebuggerCoordinates withRecorder(TraceRecorder newRecorder) {
        return DebuggerCoordinates.all(this.trace, newRecorder, this.thread, this.view, this.time, this.frame);
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public DebuggerCoordinates withReFoundThread() {
        if (this.trace == null || this.thread == null) {
            return this;
        }
        TraceThread newThread = this.trace.getThreadManager().getThread(this.thread.getKey());
        if (this.thread == newThread) {
            return this;
        }
        return this.withThread(newThread);
    }

    public DebuggerCoordinates withThread(TraceThread newThread) {
        return DebuggerCoordinates.all(this.trace, this.recorder, newThread, this.view, this.time, this.frame);
    }

    public TraceProgramView getView() {
        return this.view;
    }

    public Long getSnap() {
        return this.time.getSnap();
    }

    public DebuggerCoordinates withSnap(Long newSnap) {
        return DebuggerCoordinates.all(this.trace, this.recorder, this.thread, this.view, newSnap == null ? this.time : TraceSchedule.snap((long)newSnap), this.frame);
    }

    public DebuggerCoordinates withTime(TraceSchedule newTime) {
        return DebuggerCoordinates.all(this.trace, this.recorder, this.thread, this.view, newTime, this.frame);
    }

    public DebuggerCoordinates withView(TraceProgramView newView) {
        return DebuggerCoordinates.all(this.trace, this.recorder, this.thread, newView, this.time, this.frame);
    }

    public TraceSchedule getTime() {
        return this.time;
    }

    public Integer getFrame() {
        return this.frame;
    }

    public synchronized long getViewSnap() {
        if (this.viewSnap != null) {
            return this.viewSnap;
        }
        if (this.time.isSnapOnly()) {
            this.viewSnap = this.time.getSnap();
            return this.viewSnap;
        }
        Collection snapshots = this.trace.getTimeManager().getSnapshotsWithSchedule(this.time);
        if (snapshots.isEmpty()) {
            Msg.warn((Object)this, (Object)"Seems the emulation service did not create the requested snapshot, yet");
            return this.time.getSnap();
        }
        this.viewSnap = ((TraceSnapshot)snapshots.iterator().next()).getKey();
        return this.viewSnap;
    }

    public synchronized TraceTimeViewport getViewport() {
        if (this.viewport != null) {
            return this.viewport;
        }
        if (this.trace == null) {
            return null;
        }
        this.viewport = new DefaultTraceTimeViewport(this.trace);
        this.viewport.setSnap(this.getViewSnap());
        return this.viewport;
    }

    public void writeDataState(PluginTool tool, SaveState saveState, String key) {
        SaveState coordState = new SaveState();
        if (this.trace != null) {
            DomainFile df = this.trace.getDomainFile();
            if (df.getParent() == null) {
                return;
            }
            ProjectLocator projLoc = df.getProjectLocator();
            if (projLoc != null && !projLoc.isTransient()) {
                coordState.putString(KEY_TRACE_PROJ_LOC, projLoc.getLocation());
                coordState.putString(KEY_TRACE_PROJ_NAME, projLoc.getName());
                coordState.putString(KEY_TRACE_PATH, df.getPathname());
                if (!df.isLatestVersion()) {
                    coordState.putInt(KEY_TRACE_VERSION, df.getVersion());
                }
            }
        }
        if (this.thread != null) {
            coordState.putLong(KEY_THREAD_KEY, this.thread.getKey());
        }
        if (this.time != null) {
            coordState.putString(KEY_TIME, this.time.toString());
        }
        if (this.frame != null) {
            coordState.putInt(KEY_FRAME, this.frame.intValue());
        }
        saveState.putXmlElement(key, coordState.saveToXml());
    }

    protected static DomainFile getDomainFile(PluginTool tool, SaveState coordState) {
        DomainFile df;
        String pathname = coordState.getString(KEY_TRACE_PATH, null);
        String location = coordState.getString(KEY_TRACE_PROJ_LOC, null);
        String projName = coordState.getString(KEY_TRACE_PROJ_NAME, null);
        if (location == null || projName == null) {
            return null;
        }
        ProjectLocator projLoc = new ProjectLocator(location, projName);
        ProjectData projData = tool.getProject().getProjectData(projLoc);
        if (projData == null) {
            try {
                projData = new ProjectFileManager(projLoc, false, false);
            }
            catch (NotOwnerException e) {
                Msg.showError(DebuggerCoordinates.class, (Component)tool.getToolFrame(), (String)"Trace Open Failed", (Object)("Not project owner: " + projLoc + "(" + pathname + ")"));
                return null;
            }
            catch (IOException e) {
                Msg.showError(DebuggerCoordinates.class, (Component)tool.getToolFrame(), (String)"Trace Open Failed", (Object)("Project error: " + e.getMessage()));
                return null;
            }
        }
        if ((df = projData.getFile(pathname)) == null || !"Trace".equals(df.getContentType())) {
            String message = "Can't open trace - \"" + pathname + "\"";
            int version = coordState.getInt(KEY_TRACE_VERSION, -1);
            if (version != -1) {
                message = message + " version " + version;
            }
            String title = df == null ? "Trace Not Found" : "Wrong File Type";
            Msg.showError(DebuggerCoordinates.class, (Component)tool.getToolFrame(), (String)title, (Object)message);
            return null;
        }
        return df;
    }

    public static DebuggerCoordinates readDataState(PluginTool tool, SaveState saveState, String key, boolean resolve) {
        TraceSchedule time;
        if (!saveState.hasValue(key)) {
            return NOWHERE;
        }
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
        Trace trace = null;
        Element coordElement = saveState.getXmlElement(key);
        SaveState coordState = new SaveState(coordElement);
        if (traceManager != null) {
            DomainFile df = DebuggerCoordinates.getDomainFile(tool, coordState);
            int version = coordState.getInt(KEY_TRACE_VERSION, -1);
            if (df != null) {
                trace = traceManager.openTrace(df, version);
            }
        }
        TraceThread thread = null;
        if (trace != null && coordState.hasValue(KEY_THREAD_KEY)) {
            long threadKey = coordState.getLong(KEY_THREAD_KEY, 0L);
            thread = trace.getThreadManager().getThread(threadKey);
        }
        String timeSpec = coordState.getString(KEY_TIME, null);
        try {
            time = TraceSchedule.parse((String)timeSpec);
        }
        catch (Exception e) {
            Msg.error(DebuggerCoordinates.class, (Object)("Could not restore invalid time specification: " + timeSpec));
            time = TraceSchedule.ZERO;
        }
        Integer frame = null;
        if (coordState.hasValue(KEY_FRAME)) {
            frame = coordState.getInt(KEY_FRAME, 0);
        }
        DebuggerCoordinates coords = DebuggerCoordinates.all(trace, null, thread, null, time, frame);
        if (!resolve) {
            return coords;
        }
        return traceManager.resolveCoordinates(coords);
    }

    public boolean isAlive() {
        return this.recorder != null;
    }

    public boolean isPresent() {
        return this.recorder.getSnap() == this.time.getSnap() && this.time.isSnapOnly();
    }

    public boolean isReadsPresent() {
        return this.recorder.getSnap() == this.time.getSnap();
    }

    public boolean isAliveAndPresent() {
        return this.isAlive() && this.isPresent();
    }

    public boolean isDeadOrPresent() {
        return !this.isAlive() || this.isPresent();
    }

    public boolean isAliveAndReadsPresent() {
        return this.isAlive() && this.isReadsPresent();
    }
}

