/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Collections2;
import db.DBRecord;
import generic.NestedIterator;
import generic.util.PeekableIterator;
import ghidra.program.database.DatabaseObject;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.spatial.AbstractConstraintsTreeSpatialMap;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeNodeRecord;
import ghidra.util.database.spatial.DBTreeRecord;
import ghidra.util.database.spatial.Query;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public abstract class AbstractConstraintsTree<DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends BoundingShape<NS>, NR extends DBTreeNodeRecord<NS>, T, Q extends Query<DS, NS>> {
    protected final DBCachedObjectStore<DR> dataStore;
    protected final DBCachedObjectStore<NR> nodeStore;
    protected final Map<Long, Collection<DR>> cachedDataChildren = CacheBuilder.newBuilder().removalListener(this::cachedDataChildrenRemoved).concurrencyLevel(4).maximumSize(50L).build().asMap();
    protected final Map<Long, Collection<NR>> cachedNodeChildren = CacheBuilder.newBuilder().removalListener(this::cachedNodeChildrenRemoved).concurrencyLevel(4).maximumSize(50L).build().asMap();
    protected NR root;
    protected int leafLevel;

    public AbstractConstraintsTree(DBCachedObjectStoreFactory storeFactory, String tableName, Class<DR> dataType, Class<NR> nodeType, boolean upgradable) throws VersionException, IOException {
        this.dataStore = storeFactory.getOrCreateCachedStore(tableName, dataType, this::createDataEntry, upgradable);
        this.nodeStore = storeFactory.getOrCreateCachedStore(tableName + "_Nodes", nodeType, this::createNodeEntry, upgradable);
    }

    private void cachedDataChildrenRemoved(RemovalNotification<Long, Collection<DR>> rn) {
    }

    private void cachedNodeChildrenRemoved(RemovalNotification<Long, Collection<NR>> rn) {
    }

    protected abstract DR createDataEntry(DBCachedObjectStore<DR> var1, DBRecord var2);

    protected abstract NR createNodeEntry(DBCachedObjectStore<NR> var1, DBRecord var2);

    protected void init() {
        assert (this.root == null);
        this.root = this.getOrCreateRoot();
        this.leafLevel = this.computeLeafLevel();
    }

    protected abstract Comparator<NS> getDefaultBoundsComparator();

    protected abstract Collection<NR> getNodeChildrenOf(long var1);

    protected Collection<NR> getNodeChildrenOf(NR parent) {
        return this.cachedNodeChildren.computeIfAbsent(parent.getKey(), k -> new ArrayList<long>(this.getNodeChildrenOf((NR)k)));
    }

    protected abstract Collection<DR> getDataChildrenOf(long var1);

    protected Collection<DR> getDataChildrenOf(NR parent) {
        return this.cachedDataChildren.computeIfAbsent(parent.getKey(), k -> new ArrayList<DR>(this.getDataChildrenOf((NR)k)));
    }

    protected Collection<? extends DBTreeRecord<?, ? extends NS>> getChildrenOf(NR parent) {
        if (((DBTreeNodeRecord)((Object)parent)).getType().isLeaf()) {
            return this.getDataChildrenOf(parent);
        }
        return this.getNodeChildrenOf(parent);
    }

    protected NR getParentOf(DBTreeRecord<?, ?> n) {
        return (NR)((Object)((DBTreeNodeRecord)((Object)this.nodeStore.getObjectAt(n.getParentKey()))));
    }

    protected NR getOrCreateRoot() {
        Iterator<long> oneRoot = this.getNodeChildrenOf((NR)-1L).iterator();
        if (oneRoot.hasNext()) {
            return (NR)((Object)((DBTreeNodeRecord)oneRoot.next()));
        }
        assert (this.nodeStore.getRecordCount() == 0);
        DBTreeNodeRecord r = (DBTreeNodeRecord)((Object)this.nodeStore.create());
        r.setParentKey(-1L);
        r.setType(DBTreeNodeRecord.NodeType.LEAF);
        this.cachedDataChildren.put(r.getKey(), new ArrayList());
        return (NR)((Object)r);
    }

    protected int computeLeafLevel() {
        for (DBTreeDataRecord data : this.dataStore.asMap().values()) {
            NR parent = this.getParentOf(data);
            if (parent == null) continue;
            int level = 0;
            while (parent != this.root) {
                ++level;
                parent = this.getParentOf((DBTreeRecord<?, ?>)((Object)parent));
            }
            return level;
        }
        return 0;
    }

    protected abstract DR doInsertData(DS var1, T var2);

    protected VisitResult visit(Q query, TreeRecordVisitor visitor, boolean ordered) {
        return this.visit(null, this.root, query, visitor, ordered);
    }

    protected VisitResult visit(NR parent, NR node, Q query, TreeRecordVisitor visitor, boolean ordered) {
        Query.QueryInclusion inclusion = query == null ? Query.QueryInclusion.ALL : query.testNode((BoundingShape)((BoundingShape)((DBTreeRecord)((Object)node)).getShape()));
        VisitResult r = visitor.beginNode(parent, node, inclusion);
        if (r != VisitResult.DESCEND) {
            return r;
        }
        if (((DBTreeNodeRecord)((Object)node)).getType().isLeaf()) {
            ArrayList<DR> data = new ArrayList<DR>(this.getDataChildrenOf(node));
            if (query != null && ordered) {
                data.sort(Comparator.comparing(DBTreeRecord::getBounds, query.getBoundsComparator()));
            }
            for (DBTreeDataRecord d : data) {
                if (query != null && ordered && query.terminateEarlyData(d.getShape())) break;
                boolean included = query == null || query.testData(d.getShape());
                r = visitor.visitData(node, d, included);
                if (r == VisitResult.ASCEND) {
                    return visitor.endNode(parent, node, inclusion);
                }
                if (r != VisitResult.TERMINATE) continue;
                visitor.endNode(parent, node, inclusion);
                return r;
            }
            return visitor.endNode(parent, node, inclusion);
        }
        assert (((DBTreeNodeRecord)((Object)node)).getType().isDirectory());
        ArrayList<NR> nodes = new ArrayList<NR>(this.getNodeChildrenOf(node));
        if (query != null && ordered) {
            nodes.sort(Comparator.comparing(DBTreeRecord::getBounds, query.getBoundsComparator()));
        }
        for (DBTreeNodeRecord n : nodes) {
            if (query != null && ordered && query.terminateEarlyNode((BoundingShape)((BoundingShape)n.getShape()))) break;
            r = this.visit(node, n, query, visitor, ordered);
            if (r == VisitResult.ASCEND) {
                return visitor.endNode(parent, node, inclusion);
            }
            if (r != VisitResult.TERMINATE) continue;
            visitor.endNode(parent, node, inclusion);
            return r;
        }
        return visitor.endNode(parent, node, inclusion);
    }

    protected Iterator<DR> iterator(Q query) {
        return this.iterator(this.root, query);
    }

    protected Iterator<DR> iterator(NR node, Q query) {
        if (((DBTreeNodeRecord)((Object)node)).getType().isLeaf()) {
            ArrayList<DBTreeDataRecord> data = new ArrayList<DBTreeDataRecord>(((DBTreeNodeRecord)((Object)node)).getChildCount());
            for (DBTreeDataRecord d : this.getDataChildrenOf(node)) {
                if (query != null && !query.testData(d.getShape())) continue;
                data.add(d);
            }
            return data.iterator();
        }
        ArrayList<DBTreeNodeRecord> nodes = new ArrayList<DBTreeNodeRecord>(((DBTreeNodeRecord)((Object)node)).getChildCount());
        for (DBTreeNodeRecord n2 : this.getNodeChildrenOf(node)) {
            if (query != null && query.testNode((BoundingShape)((BoundingShape)n2.getShape())) == Query.QueryInclusion.NONE) continue;
            nodes.add(n2);
        }
        return NestedIterator.start(nodes.iterator(), n -> this.iterator(n, query));
    }

    protected Iterator<DR> orderedIterator(Q query) {
        return new PeekableIterator<DR>((Query)query){
            Comparator<NS> boundsComparator;
            Comparator<? super DBTreeRecord<?, ? extends NS>> recordComparator;
            PriorityQueue<DBTreeRecord<?, ? extends NS>> queue;
            private DR next;
            private boolean soughtNext;
            final /* synthetic */ Query val$query;
            {
                this.val$query = query;
                this.boundsComparator = this.val$query != null ? this.val$query.getBoundsComparator() : AbstractConstraintsTree.this.getDefaultBoundsComparator();
                this.recordComparator = Comparator.comparing(DBTreeRecord::getBounds, this.boundsComparator);
                this.queue = new PriorityQueue(this.recordComparator);
                this.descend(AbstractConstraintsTree.this.root);
            }

            private void checkSoughtNext() {
                if (!this.soughtNext) {
                    this.next = this.findNext();
                    this.soughtNext = true;
                }
            }

            private void descend(NR nr) {
                this.queue.addAll(AbstractConstraintsTree.this.getChildrenOf(nr));
            }

            private DR findNext() {
                DBTreeRecord rec;
                while ((rec = this.queue.poll()) != null) {
                    if (this.val$query != null && this.val$query.terminateEarlyNode(rec.getBounds())) {
                        return null;
                    }
                    if (rec instanceof DBTreeDataRecord) {
                        DBTreeDataRecord dr = (DBTreeDataRecord)rec;
                        if (this.val$query != null && !this.val$query.testData(dr.getShape())) continue;
                        return (Object)dr;
                    }
                    assert (rec instanceof DBTreeNodeRecord);
                    DBTreeNodeRecord nr = (DBTreeNodeRecord)rec;
                    if (this.val$query == null || this.val$query.testNode((BoundingShape)nr.getShape()) == Query.QueryInclusion.NONE) continue;
                    this.descend((Object)((Object)nr));
                }
                return null;
            }

            public boolean hasNext() {
                this.checkSoughtNext();
                return this.next != null;
            }

            public DR peek() throws NoSuchElementException {
                this.checkSoughtNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            public DR next() {
                this.checkSoughtNext();
                this.soughtNext = false;
                return this.next;
            }
        };
    }

    protected int count(Q query) {
        var visitor = new TreeRecordVisitor(){
            int count = 0;

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                if (inclusion == Query.QueryInclusion.ALL) {
                    this.count += ((DBTreeRecord)((Object)n)).getDataCount();
                    return VisitResult.NEXT;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                if (included) {
                    ++this.count;
                }
                return VisitResult.NEXT;
            }
        };
        this.visit(query, visitor, false);
        return visitor.count;
    }

    protected boolean isEmpty(Q query) {
        var visitor = new TreeRecordVisitor(){
            boolean result = true;

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                if (inclusion == Query.QueryInclusion.ALL && ((DBTreeRecord)((Object)n)).getDataCount() > 0) {
                    this.result = false;
                    return VisitResult.TERMINATE;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                if (included) {
                    this.result = false;
                    return VisitResult.TERMINATE;
                }
                return VisitResult.NEXT;
            }
        };
        this.visit(query, visitor, false);
        return visitor.result;
    }

    protected DR first(Q query) {
        final Comparator comparator = query != null ? query.getBoundsComparator() : this.getDefaultBoundsComparator();
        var visitor = new TreeRecordVisitor(){
            DR result;

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (this.result != null && comparator.compare(((DBTreeRecord)((Object)this.result)).getBounds(), (BoundingShape)((DBTreeRecord)((Object)n)).getShape()) <= 0) {
                    return VisitResult.ASCEND;
                }
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                if (this.result != null && comparator.compare(((DBTreeRecord)((Object)this.result)).getBounds(), ((DBTreeRecord)((Object)d)).getBounds()) <= 0) {
                    return VisitResult.ASCEND;
                }
                if (included) {
                    this.result = d;
                }
                return VisitResult.NEXT;
            }
        };
        this.visit(query, visitor, true);
        return visitor.result;
    }

    protected void visitAllData(Q query, final Consumer<DR> consumer, boolean ordered) {
        TreeRecordVisitor visitor = new TreeRecordVisitor(){

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                if (included) {
                    consumer.accept(d);
                }
                return VisitResult.NEXT;
            }
        };
        this.visit(query, visitor, ordered);
    }

    protected DR doFindExact(DS shape, T value, Q query) {
        final Comparator comparator = query == null ? null : query.getBoundsComparator();
        var visitor = new TreeRecordVisitor((BoundedShape)shape, value){
            DR result;
            final /* synthetic */ BoundedShape val$shape;
            final /* synthetic */ Object val$value;
            {
                this.val$shape = boundedShape;
                this.val$value = object;
            }

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (comparator != null && comparator.compare(this.val$shape.getBounds(), (BoundingShape)((DBTreeRecord)((Object)n)).getShape()) < 0) {
                    return VisitResult.ASCEND;
                }
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                if (!((BoundingShape)((DBTreeRecord)((Object)n)).getShape()).encloses(this.val$shape.getBounds())) {
                    return VisitResult.NEXT;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                if (comparator != null && comparator.compare(this.val$shape.getBounds(), ((DBTreeRecord)((Object)d)).getBounds()) <= 0) {
                    return VisitResult.ASCEND;
                }
                if (!included) {
                    return VisitResult.NEXT;
                }
                if (!((DBTreeDataRecord)((Object)d)).shapeEquals((BoundedShape)this.val$shape)) {
                    return VisitResult.NEXT;
                }
                if (!this.val$value.equals(((DBTreeDataRecord)((Object)d)).getRecordValue())) {
                    return VisitResult.NEXT;
                }
                this.result = d;
                return VisitResult.TERMINATE;
            }
        };
        this.visit(query, visitor, false);
        return visitor.result;
    }

    protected void doUpdateOrDeleteAlongPath(NR node) {
        NR cur = node;
        while (cur != null) {
            int childCount = ((DBTreeNodeRecord)((Object)cur)).getChildCount() - 1;
            if (childCount != 0) {
                ((DBTreeNodeRecord)((Object)cur)).setChildCount(childCount);
                break;
            }
            this.doRemoveFromCachedChildren(((DBTreeRecord)((Object)cur)).getParentKey(), cur, this.cachedNodeChildren);
            this.nodeStore.delete(cur);
            if (cur == this.root) {
                this.root = null;
                assert (this.dataStore.getRecordCount() == 0 || this.dataStore.getRecordCount() == 1);
                assert (this.nodeStore.getRecordCount() == 0);
                this.init();
                return;
            }
            cur = this.getParentOf((DBTreeRecord<?, ?>)((Object)cur));
        }
        while (cur != null) {
            this.doDecrementDataCount(cur);
            this.doRecomputeBounds(cur);
            cur = this.getParentOf((DBTreeRecord<?, ?>)((Object)cur));
        }
    }

    protected void doDecrementDataCount(NR node) {
        ((DBTreeNodeRecord)((Object)node)).setDataCount(((DBTreeRecord)((Object)node)).getDataCount() - 1);
    }

    protected void doRecomputeBounds(NR node) {
        Collection childBounds = Collections2.transform(this.getChildrenOf(node), DBTreeRecord::getBounds);
        Object bounds = BoundingShape.boundsUnion(childBounds);
        ((DBTreeRecord)((Object)node)).setShape(bounds);
    }

    protected <R> void doRemoveFromCachedChildren(long parentKey, R child, Map<Long, Collection<R>> cache) {
        Collection<R> children = cache.get(parentKey);
        if (children == null) {
            return;
        }
        if (!children.remove(child)) {
            throw new AssertionError();
        }
    }

    protected <R> void doAddToCachedChildren(long parentKey, R child, Map<Long, Collection<R>> cache) {
        Collection<R> children = cache.get(parentKey);
        if (children == null) {
            return;
        }
        if (!children.add(child)) {
            throw new AssertionError();
        }
    }

    protected <R extends DBTreeRecord<?, ?>> void doSetParentKey(R child, long key, Map<Long, Collection<R>> cache) {
        this.doRemoveFromCachedChildren(child.getParentKey(), child, cache);
        child.setParentKey(key);
        this.doAddToCachedChildren(key, child, cache);
    }

    protected void doUnparentEntry(DR data) {
        NR parent = this.getParentOf((DBTreeRecord<?, ?>)((Object)data));
        this.doSetParentKey((DBTreeRecord)((Object)data), -1L, this.cachedDataChildren);
        this.doUpdateOrDeleteAlongPath(parent);
    }

    protected void doDeleteEntry(DR data) {
        this.doUnparentEntry(data);
        if (!this.dataStore.delete(data)) {
            throw new AssertionError();
        }
    }

    protected boolean doRemoveData(DS shape, T value, Q query) {
        DR found = this.doFindExact(shape, value, query);
        if (found == null) {
            return false;
        }
        this.doDeleteEntry(found);
        return true;
    }

    protected void destroySubtree(NR node) {
        this.visit(null, node, null, new TreeRecordVisitor(){

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                AbstractConstraintsTree.this.dataStore.delete(d);
                return VisitResult.NEXT;
            }

            @Override
            protected VisitResult endNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (((DBTreeNodeRecord)((Object)n)).getType() == DBTreeNodeRecord.NodeType.LEAF) {
                    AbstractConstraintsTree.this.cachedDataChildren.remove(n.getKey());
                } else {
                    AbstractConstraintsTree.this.cachedNodeChildren.remove(n.getKey());
                }
                AbstractConstraintsTree.this.nodeStore.delete(n);
                return VisitResult.NEXT;
            }
        }, false);
    }

    protected void resyncMetadata(NR node) {
        int childCount = 0;
        int dataCount = 0;
        BoundingShape bounds = null;
        for (DBTreeRecord<?, NS> child : this.getChildrenOf(node)) {
            ++childCount;
            dataCount += child.getDataCount();
            bounds = (BoundingShape)(bounds == null ? child.getBounds() : bounds.unionBounds(child.getBounds()));
        }
        ((DBTreeNodeRecord)((Object)node)).setChildCount(childCount);
        ((DBTreeNodeRecord)((Object)node)).setDataCount(dataCount);
        ((DBTreeRecord)((Object)node)).setShape(bounds);
    }

    protected void clear(Q query) {
        this.visit(query, new TreeRecordVisitor(){
            Set<NR> dirty = new HashSet();

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                if (inclusion == Query.QueryInclusion.ALL) {
                    if (n == AbstractConstraintsTree.this.root) {
                        AbstractConstraintsTree.this.cachedDataChildren.clear();
                        AbstractConstraintsTree.this.cachedNodeChildren.clear();
                        AbstractConstraintsTree.this.dataStore.deleteAll();
                        AbstractConstraintsTree.this.nodeStore.deleteAll();
                        AbstractConstraintsTree.this.root = null;
                        AbstractConstraintsTree.this.init();
                        return VisitResult.TERMINATE;
                    }
                    this.dirty.add(parent);
                    AbstractConstraintsTree.this.doRemoveFromCachedChildren(parent.getKey(), n, AbstractConstraintsTree.this.cachedNodeChildren);
                    AbstractConstraintsTree.this.destroySubtree(n);
                    return VisitResult.NEXT;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                if (!included) {
                    return VisitResult.NEXT;
                }
                this.dirty.add(parent);
                AbstractConstraintsTree.this.doRemoveFromCachedChildren(parent.getKey(), d, AbstractConstraintsTree.this.cachedDataChildren);
                AbstractConstraintsTree.this.dataStore.delete(d);
                return VisitResult.NEXT;
            }

            @Override
            protected VisitResult endNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                if (this.dirty.remove(n)) {
                    AbstractConstraintsTree.this.resyncMetadata(n);
                    this.dirty.add(parent);
                }
                return VisitResult.NEXT;
            }
        }, false);
    }

    protected void dump(Q query) {
        this.visit(query, new TreeRecordVisitor(){

            String getLevel(DBTreeRecord<?, ?> record) {
                Object level = "";
                Object parent = AbstractConstraintsTree.this.getParentOf(record);
                while (parent != null) {
                    level = (String)level + "  ";
                    parent = AbstractConstraintsTree.this.getParentOf((DBTreeRecord<?, ?>)((Object)parent));
                }
                return level;
            }

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                System.out.println(this.getLevel((DBTreeRecord<?, ?>)((Object)n)) + n + ": (" + inclusion + ")");
                if (inclusion == Query.QueryInclusion.NONE) {
                    return VisitResult.NEXT;
                }
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                System.out.println(this.getLevel((DBTreeRecord<?, ?>)((Object)d)) + d + ": (" + included + ")");
                return VisitResult.NEXT;
            }
        }, true);
    }

    protected void checkNodeIntegrity(NR n) {
        Collection childBounds = Collections2.transform(this.getChildrenOf(n), DBTreeRecord::getBounds);
        Object expectedBounds = BoundingShape.boundsUnion(childBounds);
        if (expectedBounds == null && n != this.root) {
            throw new AssertionError((Object)"Non-root node cannot be empty");
        }
        if (expectedBounds != null && !expectedBounds.equals(((DBTreeRecord)((Object)n)).getBounds())) {
            throw new AssertionError((Object)"Parent bounds do not match expected");
        }
        switch (((DBTreeNodeRecord)((Object)n)).getType()) {
            case DIRECTORY: {
                Collection<DR> dataChildren = this.getDataChildrenOf((NR)n.getKey());
                if (dataChildren.iterator().hasNext()) {
                    throw new AssertionError((Object)("Directory node " + n + " cannot contain data " + dataChildren));
                }
                Collection<NR> nodeChildren = this.getNodeChildrenOf(n);
                if (!nodeChildren.iterator().hasNext()) {
                    throw new AssertionError((Object)("Directory node " + n + " cannot be empty"));
                }
                Object childType = ((DBTreeNodeRecord)((Object)nodeChildren.iterator().next())).getType();
                if (childType == DBTreeNodeRecord.NodeType.LEAF) {
                    throw new AssertionError((Object)("Only leaf-parent directory node can have leaf children: n=" + n + ",children=" + nodeChildren));
                }
                for (DBTreeNodeRecord nr : nodeChildren) {
                    if (nr.getType() != childType) {
                        throw new AssertionError((Object)("All sibling must have the same type: " + nodeChildren));
                    }
                }
                break;
            }
            case LEAF_PARENT: {
                Collection<DR> dataChildren = this.getDataChildrenOf(n);
                if (dataChildren.iterator().hasNext()) {
                    throw new AssertionError((Object)("Directory node " + n + " cannot contain data " + dataChildren));
                }
                Collection<NR> nodeChildren = this.getNodeChildrenOf(n);
                if (!nodeChildren.iterator().hasNext()) {
                    throw new AssertionError((Object)("Leaf-parent " + n + " cannot be empty"));
                }
                for (DBTreeNodeRecord nr : nodeChildren) {
                    if (nr.getType() != DBTreeNodeRecord.NodeType.LEAF) {
                        throw new AssertionError((Object)("Leaf-parent node " + n + " must have all leaf children: " + nodeChildren));
                    }
                }
                break;
            }
            case LEAF: {
                Collection<NR> nodeChildren = this.getNodeChildrenOf(n);
                if (nodeChildren.iterator().hasNext()) {
                    throw new AssertionError((Object)("Leaf node " + n + " cannot contain nodes " + nodeChildren));
                }
                break;
            }
        }
        long actualChildCount = 0L;
        for (DBTreeRecord<?, NS> obj : this.getChildrenOf(n)) {
            ++actualChildCount;
        }
        if (actualChildCount != (long)((DBTreeNodeRecord)((Object)n)).getChildCount()) {
            throw new AssertionError((Object)("Parent's child count " + ((DBTreeNodeRecord)((Object)n)).getChildCount() + " does not match actual count " + actualChildCount));
        }
        long actualDataCount = 0L;
        for (DBTreeRecord<?, NS> r : this.getChildrenOf(n)) {
            actualDataCount += (long)r.getDataCount();
        }
        if (actualDataCount != (long)((DBTreeRecord)((Object)n)).getDataCount()) {
            throw new AssertionError((Object)("Parent's data count " + ((DBTreeRecord)((Object)n)).getDataCount() + " does not match actual sum " + actualDataCount));
        }
    }

    protected void checkDataIntegrity(DR d) {
    }

    public void checkIntegrity() {
        TreeSet<DBTreeRecord> cachedChildren;
        TreeSet<DBTreeRecord> databasedChildren;
        for (Map.Entry<Long, Collection<DR>> entry : this.cachedDataChildren.entrySet()) {
            databasedChildren = new TreeSet<DBTreeDataRecord>(Comparator.comparing(DatabaseObject::getKey));
            databasedChildren.addAll(this.getDataChildrenOf((NR)entry.getKey()));
            cachedChildren = new TreeSet<DBTreeDataRecord>(Comparator.comparing(DatabaseObject::getKey));
            cachedChildren.addAll(entry.getValue());
            if (!databasedChildren.equals(cachedChildren)) {
                throw new AssertionError((Object)("Cached children of node " + entry.getKey() + " out of sync: cache=" + cachedChildren + " db=" + databasedChildren));
            }
        }
        for (Map.Entry<Long, Collection<Object>> entry : this.cachedNodeChildren.entrySet()) {
            databasedChildren = new TreeSet<DBTreeNodeRecord>(Comparator.comparing(DatabaseObject::getKey));
            databasedChildren.addAll(this.getNodeChildrenOf((NR)entry.getKey()));
            cachedChildren = new TreeSet<DBTreeNodeRecord>(Comparator.comparing(DatabaseObject::getKey));
            cachedChildren.addAll(entry.getValue());
            if (!databasedChildren.equals(cachedChildren)) {
                throw new AssertionError((Object)("Cached children of node " + entry.getKey() + " out of sync: cache=" + cachedChildren + " db=" + databasedChildren));
            }
        }
        if (this.leafLevel != this.computeLeafLevel()) {
            throw new AssertionError((Object)"Leaf level is incorrect");
        }
        this.visit(null, new TreeRecordVisitor(){

            @Override
            protected VisitResult beginNode(NR parent, NR n, Query.QueryInclusion inclusion) {
                AbstractConstraintsTree.this.checkNodeIntegrity(n);
                return VisitResult.DESCEND;
            }

            @Override
            protected VisitResult visitData(NR parent, DR d, boolean included) {
                AbstractConstraintsTree.this.checkDataIntegrity(d);
                return VisitResult.NEXT;
            }
        }, false);
    }

    public abstract AbstractConstraintsTreeSpatialMap<DS, DR, NS, T, Q> asSpatialMap();

    public DR getDataByKey(long key) {
        return (DR)((Object)((DBTreeDataRecord)((Object)this.dataStore.getObjectAt(key))));
    }

    public <K> DBCachedObjectIndex<K, DR> getUserIndex(Class<K> fieldClass, DBObjectColumn column) {
        return this.dataStore.getIndex(fieldClass, column);
    }

    public void invalidateCache() {
        try (LockHold hold = LockHold.lock(this.dataStore.writeLock());){
            this.cachedDataChildren.clear();
            this.cachedNodeChildren.clear();
            this.dataStore.invalidateCache();
            this.nodeStore.invalidateCache();
        }
    }

    protected abstract class TreeRecordVisitor {
        protected TreeRecordVisitor() {
        }

        protected abstract VisitResult beginNode(NR var1, NR var2, Query.QueryInclusion var3);

        protected VisitResult endNode(NR parent, NR n, Query.QueryInclusion inclusion) {
            return VisitResult.NEXT;
        }

        protected abstract VisitResult visitData(NR var1, DR var2, boolean var3);
    }

    protected static enum VisitResult {
        TERMINATE,
        NEXT,
        DESCEND,
        ASCEND;

    }
}

