/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.Field;
import db.LongField;
import db.Schema;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class SchemaBuilder {
    private int version = 0;
    private String keyFieldName = "Key";
    private Class<? extends Field> keyFieldClass = LongField.class;
    private List<String> fieldNames = new ArrayList<String>();
    private List<Class<? extends Field>> fieldClasses = new ArrayList<Class<? extends Field>>();

    public static int getColumnIndex(Schema schema, String name) {
        return ArrayUtils.indexOf((Object[])schema.getFieldNames(), (Object)name);
    }

    public SchemaBuilder version(int version) {
        this.version = version;
        return this;
    }

    public SchemaBuilder keyField(String name, Class<? extends Field> cls) {
        this.keyFieldName = name;
        this.keyFieldClass = cls;
        return this;
    }

    public SchemaBuilder field(String name, Class<? extends Field> cls) {
        this.fieldNames.add(name);
        this.fieldClasses.add(cls);
        return this;
    }

    public int fieldCount() {
        return this.fieldNames.size();
    }

    public Schema build() {
        return new Schema(this.version, this.keyFieldClass, this.keyFieldName, this.fieldClasses.toArray(new Class[this.fieldClasses.size()]), this.fieldNames.toArray(new String[this.fieldNames.size()]));
    }
}

