/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.util.ErrorHandler;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreKeySubSet;
import ghidra.util.database.DirectedIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.collections4.ComparatorUtils;

public class DBCachedObjectStoreKeySet
implements NavigableSet<Long> {
    protected final DBCachedObjectStore<?> store;
    protected final ErrorHandler errHandler;
    protected final ReadWriteLock lock;
    protected final DirectedIterator.Direction direction;
    private final Comparator<? super Long> comparator;
    private final Comparator<? super Long> reverseComparator;

    public DBCachedObjectStoreKeySet(DBCachedObjectStore<?> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction) {
        this.store = store;
        this.errHandler = errHandler;
        this.lock = lock;
        this.direction = direction;
        this.comparator = store.keyComparator();
        this.reverseComparator = ComparatorUtils.reversedComparator(this.comparator);
    }

    @Override
    public int size() {
        return this.store.getRecordCount();
    }

    @Override
    public boolean isEmpty() {
        return this.store.getRecordCount() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.contains(o));
    }

    @Override
    public Iterator<Long> iterator() {
        return this.store.keys.iterator(this.direction, null);
    }

    @Override
    public Object[] toArray() {
        return this.store.keys.toArray(this.direction, null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.store.keys.toArray(this.direction, null, a, this.store.getRecordCount());
    }

    @Override
    public boolean add(Long e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.keys.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.keys.retain(c, null);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.keys.removeAll(c));
    }

    @Override
    public void clear() {
        this.store.deleteAll();
    }

    @Override
    public Comparator<? super Long> comparator() {
        if (this.direction == DirectedIterator.Direction.FORWARD) {
            return this.comparator;
        }
        return this.reverseComparator;
    }

    @Override
    public Long first() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.first(this.direction));
    }

    @Override
    public Long last() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.last(this.direction));
    }

    @Override
    public Long lower(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.lower(this.direction, e));
    }

    @Override
    public Long floor(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.floor(this.direction, e));
    }

    @Override
    public Long ceiling(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.ceiling(this.direction, e));
    }

    @Override
    public Long higher(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.higher(this.direction, e));
    }

    @Override
    public Long pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long pollLast() {
        throw new UnsupportedOperationException();
    }

    public DBCachedObjectStoreKeySet descendingSet() {
        return new DBCachedObjectStoreKeySet(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction));
    }

    @Override
    public Iterator<Long> descendingIterator() {
        return this.store.keys.iterator(DirectedIterator.Direction.reverse(this.direction), null);
    }

    public DBCachedObjectStoreKeySubSet subSet(Long fromElement, boolean fromInclusive, Long toElement, boolean toInclusive) {
        Range<Long> rng = DBCachedObjectStore.toRange(fromElement, fromInclusive, toElement, toInclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, rng);
    }

    public DBCachedObjectStoreKeySubSet headSet(Long toElement, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeHead(toElement, inclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, rng);
    }

    public DBCachedObjectStoreKeySubSet tailSet(Long fromElement, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeTail(fromElement, inclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, rng);
    }

    public DBCachedObjectStoreKeySubSet subSet(Long fromElement, Long toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    public DBCachedObjectStoreKeySubSet headSet(Long toElement) {
        return this.headSet(toElement, false);
    }

    public DBCachedObjectStoreKeySubSet tailSet(Long fromElement) {
        return this.tailSet(fromElement, true);
    }
}

