/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreEntrySubSet;
import ghidra.util.database.DirectedIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.collections4.ComparatorUtils;

public class DBCachedObjectStoreEntrySet<T extends DBAnnotatedObject>
implements NavigableSet<Map.Entry<Long, T>> {
    protected final DBCachedObjectStore<T> store;
    protected final DirectedIterator.Direction direction;
    protected final ReadWriteLock lock;
    protected final ErrorHandler errHandler;
    private final Comparator<Map.Entry<Long, ?>> comparator;
    private final Comparator<Map.Entry<Long, ?>> reverseComparator;

    public DBCachedObjectStoreEntrySet(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction) {
        this.store = store;
        this.errHandler = errHandler;
        this.lock = lock;
        this.direction = direction;
        this.comparator = Comparator.comparing(Map.Entry::getKey, store.keyComparator());
        this.reverseComparator = ComparatorUtils.reversedComparator(this.comparator);
    }

    @Override
    public int size() {
        return this.store.getRecordCount();
    }

    @Override
    public boolean isEmpty() {
        return this.store.getRecordCount() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.contains(o));
    }

    @Override
    public Iterator<Map.Entry<Long, T>> iterator() {
        return this.store.entries.iterator(this.direction, null);
    }

    @Override
    public Object[] toArray() {
        return this.store.entries.toArray(this.direction, null);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.store.entries.toArray(this.direction, null, a, this.store.getRecordCount());
    }

    @Override
    public boolean add(Map.Entry<Long, T> o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.entries.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<Long, T>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.entries.retain(c, null);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.entries.removeAll(c));
    }

    @Override
    public void clear() {
        this.store.deleteAll();
    }

    @Override
    public Comparator<? super Map.Entry<Long, T>> comparator() {
        if (this.direction == DirectedIterator.Direction.FORWARD) {
            return this.comparator;
        }
        return this.reverseComparator;
    }

    @Override
    public Map.Entry<Long, T> first() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.first(this.direction));
    }

    @Override
    public Map.Entry<Long, T> last() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.last(this.direction));
    }

    @Override
    public Map.Entry<Long, T> lower(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.lower(this.direction, (Long)e.getKey()));
    }

    @Override
    public Map.Entry<Long, T> floor(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.floor(this.direction, (Long)e.getKey()));
    }

    @Override
    public Map.Entry<Long, T> ceiling(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.ceiling(this.direction, (Long)e.getKey()));
    }

    @Override
    public Map.Entry<Long, T> higher(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.higher(this.direction, (Long)e.getKey()));
    }

    @Override
    public Map.Entry<Long, T> pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<Long, T> pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBCachedObjectStoreEntrySet<T> descendingSet() {
        return new DBCachedObjectStoreEntrySet<T>(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction));
    }

    @Override
    public Iterator<Map.Entry<Long, T>> descendingIterator() {
        return this.store.entries.iterator(DirectedIterator.Direction.reverse(this.direction), null);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> subSet(Map.Entry<Long, T> fromElement, boolean fromInclusive, Map.Entry<Long, T> toElement, boolean toInclusive) {
        Range<Long> rng = DBCachedObjectStore.toRange(fromElement.getKey(), fromInclusive, toElement.getKey(), toInclusive, this.direction);
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, this.direction, rng);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> headSet(Map.Entry<Long, T> toElement, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeHead(toElement.getKey(), inclusive, this.direction);
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, this.direction, rng);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> tailSet(Map.Entry<Long, T> fromElement, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeTail(fromElement.getKey(), inclusive, this.direction);
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, this.direction, rng);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> subSet(Map.Entry<Long, T> fromElement, Map.Entry<Long, T> toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> headSet(Map.Entry<Long, T> toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> tailSet(Map.Entry<Long, T> fromElement) {
        return this.tailSet(fromElement, true);
    }
}

