/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import com.google.common.collect.ImmutableList;
import generic.ComparableTupleRecord;
import ghidra.framework.options.AutoOptionsListener;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.beans.PropertyEditor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public interface AutoOptions {
    public static Wiring wireOptions(Plugin plugin) {
        return AutoOptions.wireOptions(plugin, plugin);
    }

    public static Wiring wireOptions(Plugin plugin, Object receiver) {
        AutoOptions.registerOptionsDefined(plugin, receiver.getClass(), receiver);
        return AutoOptions.wireOptionsConsumed(plugin, receiver);
    }

    public static void registerOptionsDefined(Plugin plugin, Class<?> cls, Object receiver) {
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            AutoOptions.registerOptionsDefined(plugin, superclass, receiver);
        }
        for (Field f : cls.getDeclaredFields()) {
            PropertyEditor editor;
            Object defaultValue;
            AutoOptionDefined annotation = f.getAnnotation(AutoOptionDefined.class);
            if (annotation == null) continue;
            CategoryAndName key = new CategoryAndName(annotation, plugin);
            ToolOptions options = plugin.getTool().getOptions(key.getCategory());
            if (options.isRegistered(key.getName())) continue;
            f.setAccessible(true);
            HelpLocation help = AutoOptions.getHelpLocation(plugin.getName(), annotation.help());
            try {
                defaultValue = f.get(receiver);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            OptionType type = annotation.type();
            if (type == OptionType.NO_TYPE) {
                type = OptionType.getOptionType((Object)defaultValue);
            }
            if (type == OptionType.NO_TYPE) {
                throw new IllegalArgumentException("Could not determine option type from default value: " + f + " = " + defaultValue);
            }
            String description = annotation.description();
            Class<? extends PropertyEditor> editorClass = annotation.editor();
            if (editorClass == PropertyEditor.class) {
                editor = null;
            } else {
                try {
                    editor = editorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalArgumentException("editor class must have accessible default constructor", e);
                }
            }
            options.registerOption(key.getName(), type, defaultValue, help, description, editor);
            options.putObject(key.getName(), defaultValue, type);
        }
    }

    public static HelpLocation getHelpLocation(String defaultTopic, HelpInfo annot) {
        if (annot.topic().length == 0) {
            return null;
        }
        String anchor = annot.anchor();
        if ("".equals(anchor)) {
            anchor = null;
        }
        String topic = annot.topic().length == 0 ? defaultTopic : StringUtils.join((Object[])annot.topic(), (String)".");
        return new HelpLocation(topic, anchor);
    }

    public static Wiring wireOptionsConsumed(Plugin plugin, Object receiver) {
        PluginTool tool = plugin.getTool();
        AutoOptionsListener<Object> listener = new AutoOptionsListener<Object>(plugin, receiver);
        for (String category : listener.getCategories()) {
            ToolOptions options = tool.getOptions(category);
            options.addOptionsChangeListener(listener);
        }
        listener.notifyCurrentValues(tool);
        return new WiringImpl(listener);
    }

    public static class WiringImpl
    implements Wiring {
        private AutoOptionsListener<?> listener;

        public WiringImpl(AutoOptionsListener<?> listener) {
            this.listener = listener;
        }

        @Override
        public void dispose() {
            this.listener = null;
        }
    }

    public static interface Wiring {
        public void dispose();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface NewValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OldValue {
    }

    public static class CategoryAndName
    implements ComparableTupleRecord<CategoryAndName> {
        public static final List<Function<CategoryAndName, ? extends Comparable<?>>> ACCESSORS = ImmutableList.of(CategoryAndName::getCategory, CategoryAndName::getName);
        private final String category;
        private final String name;

        protected static String getPluginPackageName(Plugin plugin) {
            return plugin.getPluginDescription().getPluginPackage().getName();
        }

        public CategoryAndName(AutoOptionDefined annotation, Plugin plugin) {
            Object[] categoryNames = annotation.category();
            this.category = categoryNames.length == 0 ? CategoryAndName.getPluginPackageName(plugin) : StringUtils.join((Object[])categoryNames, (String)".");
            this.name = StringUtils.join((Object[])annotation.name(), (String)".");
        }

        public CategoryAndName(AutoOptionConsumed annotation, Plugin plugin) {
            Object[] categoryNames = annotation.category();
            this.category = categoryNames.length == 0 ? CategoryAndName.getPluginPackageName(plugin) : StringUtils.join((Object[])categoryNames, (String)".");
            this.name = StringUtils.join((Object[])annotation.name(), (String)".");
        }

        public CategoryAndName(String category, String name) {
            this.category = category;
            this.name = name;
        }

        @Override
        public List<Function<CategoryAndName, ? extends Comparable<?>>> getComparableFieldAccessors() {
            return ACCESSORS;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.doHashCode();
        }

        public boolean equals(Object obj) {
            return this.doEquals(obj);
        }

        public String toString() {
            return this.category + ":" + this.name;
        }
    }
}

