/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.wizard.WizardState;
import ghidra.util.SystemUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WizardStateDependencyValidator<T> {
    private Set<T> dependentSet = new HashSet<T>();
    private Map<T, Set<T>> dependentMap = new HashMap<T, Set<T>>();
    private Map<T, Object> valueMap = new HashMap<T, Object>();

    public void addDependency(T dependent, T predecessor) {
        this.dependentSet.add(dependent);
        if (predecessor != null) {
            Set<T> dependents = this.dependentMap.get(predecessor);
            if (dependents == null) {
                dependents = new HashSet<T>();
                this.dependentMap.put(predecessor, dependents);
            }
            dependents.add(dependent);
        }
    }

    public Set<T> findAffectedDependants(WizardState<T> globalState) {
        HashSet<T> affectedDependendants = new HashSet<T>();
        for (T predecessor : this.dependentMap.keySet()) {
            Object localValue;
            Object globalValue = globalState.get(predecessor);
            if (SystemUtilities.isEqual((Object)globalValue, (Object)(localValue = this.valueMap.get(predecessor)))) continue;
            affectedDependendants.addAll((Collection)this.dependentMap.get(predecessor));
        }
        for (T dependant : this.dependentSet) {
            if (this.valueMap.get(dependant) != null) continue;
            affectedDependendants.add(dependant);
        }
        return affectedDependendants;
    }

    public void updatePropertyValues(WizardState<T> globalState) {
        for (T dependent : this.dependentSet) {
            this.valueMap.put(dependent, globalState.get(dependent));
        }
        for (T trigger : this.dependentMap.keySet()) {
            this.valueMap.put(trigger, globalState.get(trigger));
        }
    }
}

