/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jungrapht.visualization.control.AbstractModalGraphMouse;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.RegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.modal.Modal;

public class DefaultModalGraphMouse<V, E>
extends AbstractModalGraphMouse
implements ModalGraphMouse {
    protected int singleSelectionMask;
    protected int toggleSingleSelectionMask;
    protected int regionSelectionMask;
    protected int toggleRegionSelectionMask;
    protected int regionSelectionCompleteMask;
    protected int toggleRegionSelectionCompleteMask;
    protected int translatingMask;
    protected int scalingMask;
    protected int xAxisScalingMask;
    protected int yAxisScalingMask;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public DefaultModalGraphMouse() {
        this(new Builder());
    }

    DefaultModalGraphMouse(float in, float out, boolean vertexSelectionOnly) {
        super(Modal.Mode.TRANSFORMING, in, out, vertexSelectionOnly);
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    protected DefaultModalGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.mode, builder.in, builder.out, builder.vertexSelectionOnly, builder.singleSelectionMask, builder.toggleSingleSelectionMask, builder.regionSelectionMask, builder.toggleRegionSelectionMask, builder.regionSelectionCompleteMask, builder.toggleRegionSelectionCompleteMask, builder.translatingMask, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask);
    }

    public DefaultModalGraphMouse(Modal.Mode mode, float in, float out, boolean vertexSelectionOnly, int singleSelectionMask, int toggleSingleSelectionMask, int regionSelectionMask, int toggleRegionSelectionMask, int regionSelectionCompleteMask, int toggleRegionSelectionCompleteMask, int translatingMask, int scalingMask, int xAxisScalingMask, int yAxisScalingMask) {
        super(mode, in, out, vertexSelectionOnly);
        this.singleSelectionMask = singleSelectionMask;
        this.toggleSingleSelectionMask = toggleSingleSelectionMask;
        this.regionSelectionMask = regionSelectionMask;
        this.toggleRegionSelectionMask = toggleRegionSelectionMask;
        this.regionSelectionCompleteMask = regionSelectionCompleteMask;
        this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
        this.translatingMask = translatingMask;
        this.scalingMask = scalingMask;
        this.xAxisScalingMask = xAxisScalingMask;
        this.yAxisScalingMask = yAxisScalingMask;
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    public void loadPlugins() {
        this.selectingPlugin = ((SelectingGraphMousePlugin.Builder)((SelectingGraphMousePlugin.Builder)SelectingGraphMousePlugin.builder().singleSelectionMask(1024)).toggleSingleSelectionMask(1088)).build();
        this.regionSelectingPlugin = ((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)RegionSelectingGraphMousePlugin.builder().regionSelectionMask(1024)).toggleRegionSelectionMask(1088)).regionSelectionCompleteMask(0)).toggleRegionSelectionCompleteMask(64)).build();
        this.translatingPlugin = ((TranslatingGraphMousePlugin.Builder)TranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
        this.scalingPlugin = ScalingGraphMousePlugin.builder().scalingControl(new CrossoverScalingControl()).build();
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.setMode(this.mode);
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(Modal.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(Modal.Mode.PICKING);
            }
        }
    }

    public static class Builder<V, E, T extends DefaultModalGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends AbstractModalGraphMouse.Builder<T, B> {
        protected int singleSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.singleSelectionMask", "MB1_MENU"));
        protected int toggleSingleSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleSingleSelectionMask", "MB1_SHIFT_MENU"));
        protected int regionSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.regionSelectionMask", "MB1_MENU"));
        protected int toggleRegionSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.addregionSelectionMask", "MB1_SHIFT_MENU"));
        protected int regionSelectionCompleteMask = Modifiers.masks.get(System.getProperty("jungrapht.regionSelectionCompleteMask", "MENU"));
        protected int toggleRegionSelectionCompleteMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleRegionSelectionCompleteMask", "SHIFT_MENU"));
        protected int translatingMask = Modifiers.masks.get(System.getProperty("jungrapht.translatingMask", "MB1"));
        protected int xAxisScalingMask = Modifiers.masks.get(System.getProperty("jungrapht.xAxisScalingMask", "MENU"));
        protected int yAxisScalingMask = Modifiers.masks.get(System.getProperty("jungrapht.yAxisScalingMask", "ALT"));
        protected int scalingMask = Modifiers.masks.get(System.getProperty("jungrapht.scalingMask", "NONE"));

        public B singleSelectionMask(int singleSelectionMask) {
            this.singleSelectionMask = singleSelectionMask;
            return (B)((Builder)this.self());
        }

        public B toggleSingleSelectionMask(int toggleSingleSelectionMask) {
            this.toggleSingleSelectionMask = toggleSingleSelectionMask;
            return (B)((Builder)this.self());
        }

        public B regionSelectionMask(int regionSelectionMask) {
            this.regionSelectionMask = regionSelectionMask;
            return (B)((Builder)this.self());
        }

        public B toggleRegionSelectionMask(int toggleRegionSelectionMask) {
            this.toggleRegionSelectionMask = toggleRegionSelectionMask;
            return (B)((Builder)this.self());
        }

        public B regionSelectionCompleteMask(int regionSelectionCompleteMask) {
            this.regionSelectionCompleteMask = regionSelectionCompleteMask;
            return (B)((Builder)this.self());
        }

        public B toggleRegionSelectionCompleteMask(int toggleRegionSelectionCompleteMask) {
            this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
            return (B)((Builder)this.self());
        }

        public B translatingMask(int translatingMask) {
            this.translatingMask = translatingMask;
            return (B)((Builder)this.self());
        }

        public B scalingMask(int scalingMask) {
            this.scalingMask = scalingMask;
            return (B)((Builder)this.self());
        }

        public B xAxisScalingMask(int xAxisScalingMask) {
            this.xAxisScalingMask = xAxisScalingMask;
            return (B)((Builder)this.self());
        }

        public B yAxisScalingMask(int yAxisScalingMask) {
            this.yAxisScalingMask = yAxisScalingMask;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new DefaultModalGraphMouse(this);
        }
    }
}

