/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;

public class Class16MsType
extends AbstractClassMsType {
    public static final int PDB_ID = 4;

    public Class16MsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.count = reader.parseUnsignedShortVal();
        this.fieldDescriptorListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        this.property = new MsProperty(reader);
        this.derivedFromListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        this.vShapeTableRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.size = numeric.getIntegral();
        this.name = reader.parseString(pdb, StringParseType.StringSt);
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 4;
    }
}

