/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.validator.VTPreconditionValidator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;

public class MemoryBlocksValidator
extends VTPreconditionValidator {
    private static final String NAME = "Memory Blocks Validator";

    public MemoryBlocksValidator(Program sourceProgram, Program destinationProgram, VTSession existingResults) {
        super(sourceProgram, destinationProgram, existingResults);
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) {
        ConditionStatus status = ConditionStatus.Passed;
        StringBuilder warnings = new StringBuilder();
        String sourceProgName = this.sourceProgram.getDomainFile().getName();
        String destProgName = this.destinationProgram.getDomainFile().getName();
        MemoryBlock[] sourceBlocks = this.sourceProgram.getMemory().getBlocks();
        MemoryBlock[] destBlocks = this.destinationProgram.getMemory().getBlocks();
        int sourceNumBlocks = sourceBlocks.length;
        int destNumBlocks = destBlocks.length;
        int numBlocksToCompare = 0;
        int numBlocksNeededForPerfectMatch = 0;
        if (sourceNumBlocks >= destNumBlocks) {
            numBlocksToCompare = destNumBlocks;
            numBlocksNeededForPerfectMatch = sourceNumBlocks;
        } else {
            numBlocksToCompare = sourceNumBlocks;
            numBlocksNeededForPerfectMatch = destNumBlocks;
        }
        int numMatches = 0;
        int numMatchingNames = 0;
        monitor.setIndeterminate(false);
        monitor.initialize((long)numBlocksToCompare);
        for (int i = 0; i < numBlocksToCompare; ++i) {
            monitor.setProgress((long)i);
            String blockName = destBlocks[i].getName();
            MemoryBlock matchingABlock = this.sourceProgram.getMemory().getBlock(destBlocks[i].getName());
            if (matchingABlock != null) {
                ++numMatchingNames;
                int sourcePerm = matchingABlock.getPermissions();
                if (sourcePerm == destBlocks[i].getPermissions()) {
                    ++numMatches;
                    continue;
                }
                warnings.append("Block " + destProgName + ":" + blockName + " doesn't match permissions of " + sourceProgName + ":" + blockName + "\n");
                status = ConditionStatus.Warning;
                continue;
            }
            warnings.append("Block " + destProgName + ":" + blockName + " doesn't appear in " + sourceProgName + "\n");
            status = ConditionStatus.Warning;
        }
        if (numMatches != numBlocksNeededForPerfectMatch) {
            status = ConditionStatus.Warning;
            if (numMatches == numBlocksToCompare) {
                String plural;
                int addl;
                if (sourceNumBlocks > numMatches) {
                    addl = sourceNumBlocks - numMatches;
                    plural = addl > 1 ? "s" : "";
                    warnings.append(sourceProgName + " has " + addl + " more block" + plural + " than " + destProgName + " (but the rest match)\n");
                } else if (destNumBlocks > numMatches) {
                    addl = destNumBlocks - numMatches;
                    plural = addl > 1 ? "s" : "";
                    warnings.append(destProgName + " has " + addl + " more block" + plural + " than " + sourceProgName + " (but the rest match)\n");
                }
            }
            if (numMatchingNames == numBlocksNeededForPerfectMatch) {
                warnings.append("\nSUMMARY: Number and names of blocks match but not all permissions match.");
            } else {
                warnings.append("\nSUMMARY: Number, names, and permissions of blocks do not all match");
            }
        }
        return new ConditionResult(status, warnings.toString());
    }

    public String getDescription() {
        return "Make sure the memory blocks in both programs match up.";
    }

    public String getName() {
        return NAME;
    }
}

