/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.list.GListCellRenderer;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.editors.TagEditorDialog;
import ghidra.feature.vt.gui.filters.TagFilterChooser;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.framework.plugintool.PluginTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TagFilterEditorDialog
extends DialogComponentProvider
implements TagFilterChooser {
    private Map<String, VTMatchTag> allTags;
    private Map<String, VTMatchTag> excludedTags;
    private TagListModel listModel;
    private final VTController controller;

    public TagFilterEditorDialog(VTController controller) {
        super("Tag Chooser", true, false, true, false);
        this.controller = controller;
        this.setPreferredSize(300, 400);
        this.addOKButton();
    }

    private JPanel createWorkPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.listModel = new TagListModel(this.allTags, this.excludedTags);
        final JList list = new JList(this.listModel);
        list.setBackground(scrollPane.getBackground());
        list.setCellRenderer(new TagRenderer());
        list.getSelectionModel().setSelectionMode(0);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = list.locationToIndex(e.getPoint());
                Rectangle cellBounds = list.getCellBounds(index, index);
                if (cellBounds == null) {
                    return;
                }
                if (cellBounds.contains(e.getPoint())) {
                    TagInfo info;
                    info.setIncluded(!(info = (TagInfo)TagFilterEditorDialog.this.listModel.get(index)).isIncluded());
                    list.repaint();
                }
            }
        });
        scrollPane.setViewportView(list);
        mainPanel.add((Component)scrollPane, "Center");
        JButton editButton = new JButton("Manage Tags");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagEditorDialog dialog = new TagEditorDialog(TagFilterEditorDialog.this.controller.getSession());
                PluginTool tool = TagFilterEditorDialog.this.controller.getTool();
                tool.showDialog((DialogComponentProvider)dialog);
                TagFilterEditorDialog.this.allTags = TagFilterEditorDialog.this.getAllTags();
                TagFilterEditorDialog.this.rebuild();
            }
        });
        JPanel editPanel = new JPanel();
        editPanel.add(editButton);
        mainPanel.add((Component)editPanel, "South");
        return mainPanel;
    }

    @Override
    public Map<String, VTMatchTag> getExcludedTags(Map<String, VTMatchTag> allTagsMap, Map<String, VTMatchTag> currentExcludedTagsMap) {
        this.allTags = allTagsMap;
        this.excludedTags = currentExcludedTagsMap;
        this.rebuild();
        PluginTool tool = this.controller.getTool();
        tool.showDialog((DialogComponentProvider)this);
        int size = this.listModel.getSize();
        TreeMap<String, VTMatchTag> newExcludedTags = new TreeMap<String, VTMatchTag>();
        for (int i = 0; i < size; ++i) {
            TagInfo info = (TagInfo)this.listModel.get(i);
            if (info.isIncluded()) continue;
            VTMatchTag tag = info.getTag();
            newExcludedTags.put(tag.getName(), tag);
        }
        return newExcludedTags;
    }

    private Map<String, VTMatchTag> getAllTags() {
        VTSession session = this.controller.getSession();
        if (session == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, VTMatchTag> map = new TreeMap<String, VTMatchTag>();
        Set<VTMatchTag> matchTags = session.getMatchTags();
        for (VTMatchTag tag : matchTags) {
            map.put(tag.getName(), tag);
        }
        map.put(VTMatchTag.UNTAGGED.getName(), VTMatchTag.UNTAGGED);
        return map;
    }

    private void rebuild() {
        this.removeWorkPanel();
        this.addWorkPanel(this.createWorkPanel());
    }

    protected void okCallback() {
        this.close();
    }

    private class TagRenderer
    extends GListCellRenderer<TagInfo> {
        private JPanel panel;
        private GCheckBox checkBox = new GCheckBox();

        private TagRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends TagInfo> list, TagInfo value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            this.checkBox.setSelected(value.isIncluded);
            renderer.setText(value.getDisplayText());
            return this.getPanel(renderer);
        }

        private JPanel getPanel(JLabel renderer) {
            if (this.panel == null) {
                JScrollPane scrollPane = new JScrollPane();
                this.panel = new JPanel();
                this.panel.setBackground(scrollPane.getBackground());
                this.panel.setLayout(new BoxLayout(this.panel, 0));
                this.panel.add((Component)this.checkBox);
                this.panel.add(Box.createHorizontalStrut(5));
                this.panel.add(renderer);
            }
            return this.panel;
        }
    }

    private class TagInfo {
        private boolean isIncluded;
        private final VTMatchTag tag;

        TagInfo(VTMatchTag tag, boolean isIncluded) {
            this.tag = tag;
            this.isIncluded = isIncluded;
        }

        VTMatchTag getTag() {
            return this.tag;
        }

        boolean isIncluded() {
            return this.isIncluded;
        }

        void setIncluded(boolean isIncluded) {
            this.isIncluded = isIncluded;
        }

        String getDisplayText() {
            String name = this.tag.getName();
            if (this.tag == VTMatchTag.UNTAGGED) {
                name = this.tag.toString();
            }
            String status = this.isIncluded ? "included" : "excluded";
            return name + " (" + status + ")";
        }
    }

    private class TagListModel
    extends DefaultListModel {
        TagListModel(Map<String, VTMatchTag> allTags, Map<String, VTMatchTag> excludedTags) {
            Iterator<Map.Entry<String, VTMatchTag>> iterator = allTags.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isExcluded;
                Map.Entry<String, VTMatchTag> entry;
                this.addElement(new TagInfo(entry.getValue(), !(isExcluded = excludedTags.containsKey((entry = iterator.next()).getKey()))));
            }
        }
    }
}

