/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyContext;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class SetVTMatchFromOneToManyAction
extends DockingAction {
    private static final String MENU_GROUP = "AAA_VT_Main";
    public static final Icon SET_MATCH_ICON = ResourceManager.loadImage((String)"images/text_align_justify.png");
    final VTController controller;

    public SetVTMatchFromOneToManyAction(VTController controller, boolean addToToolbar) {
        super("Select Same Match In Version Tracking Matches Table", VTPlugin.OWNER);
        this.controller = controller;
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(SET_MATCH_ICON, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Select Match in VT Matches Table"}, SET_MATCH_ICON, MENU_GROUP);
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Select_Same_Match_In_Version_Tracking_Matches_Table"));
    }

    public void actionPerformed(ActionContext context) {
        VTMatch match;
        if (context instanceof VTMatchOneToManyContext && (match = this.getSelectedMatch((VTMatchOneToManyContext)context)) != null) {
            this.controller.setSelectedMatch(match);
        }
    }

    private VTMatch getSelectedMatch(VTMatchOneToManyContext context) {
        List<VTMatch> selectedMatches = context.getSelectedMatches();
        if (selectedMatches.size() == 1) {
            return selectedMatches.get(0);
        }
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof VTMatchOneToManyContext) {
            VTMatch match = this.getSelectedMatch((VTMatchOneToManyContext)context);
            return match != null;
        }
        return false;
    }

    public boolean isAddToPopup(ActionContext context) {
        return context instanceof VTMatchOneToManyContext;
    }
}

