/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.editors.MatchTagComboBox;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class ChooseMatchTagAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_Edit_2";
    private static final Icon EDIT_TAG_ICON = ResourceManager.loadImage((String)"images/tag_blue.png");
    private static final String ACTION_NAME = "Choose Match Tag";
    private final VTController controller;
    private VTMatchTag lastTag;

    public ChooseMatchTagAction(VTController controller) {
        super(ACTION_NAME, VTPlugin.OWNER);
        this.controller = controller;
        this.setDescription(ACTION_NAME);
        this.setToolBarData(new ToolBarData(EDIT_TAG_ICON, MENU_GROUP));
        MenuData menuData = new MenuData(new String[]{"Choose Tag"}, EDIT_TAG_ICON, MENU_GROUP);
        menuData.setMenuSubGroup("1");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Choose_Tag"));
    }

    public void actionPerformed(ActionContext context) {
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        if (matches.size() == 0) {
            return;
        }
        JComponent component = context.getComponentProvider().getComponent();
        this.editTag(matches, component);
    }

    private void editTag(List<VTMatch> matches, JComponent component) {
        if (matches == null || matches.size() == 0) {
            return;
        }
        VTSession session = this.controller.getSession();
        if (session == null) {
            return;
        }
        TagChooserDialog dialog = new TagChooserDialog(session, matches, component, this.lastTag);
        dialog.setRememberSize(false);
        SwingUtilities.invokeLater(() -> {
            this.controller.getTool().showDialog((DialogComponentProvider)dialog, (Component)component);
            this.lastTag = dialog.getSelectedTag();
        });
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        return matches.size() != 0;
    }

    private class TagChooserDialog
    extends DialogComponentProvider {
        private JPanel editorPanel;
        private MatchTagComboBox tagComboBox;
        private final VTSession session;
        private final List<VTMatch> matches;
        private final JComponent component;
        private VTMatchTag selectedTag;

        protected TagChooserDialog(VTSession session, List<VTMatch> matches, JComponent component, VTMatchTag selectedTag) {
            super(ChooseMatchTagAction.ACTION_NAME, true, true, true, false);
            this.session = session;
            this.matches = matches;
            this.component = component;
            this.selectedTag = selectedTag;
            this.editorPanel = this.createEditorPanel();
            this.addWorkPanel(this.editorPanel);
            this.addOKButton();
            this.addCancelButton();
            this.setDefaultButton(this.okButton);
        }

        private JPanel createEditorPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            this.tagComboBox = new MatchTagComboBox(this.session, this.matches, this.component, this.selectedTag);
            Dimension dim = new Dimension(50, this.tagComboBox.getPreferredSize().height);
            this.tagComboBox.setMinimumSize(dim);
            this.tagComboBox.addActionListener(e -> this.fieldEdited());
            panel.add((Component)((Object)this.tagComboBox), "Center");
            return panel;
        }

        protected void cancelCallback() {
            super.cancelCallback();
        }

        protected void okCallback() {
            this.selectedTag = (VTMatchTag)this.tagComboBox.getSelectedItem();
            this.tagComboBox.apply();
            this.close();
        }

        VTMatchTag getSelectedTag() {
            return this.selectedTag;
        }

        public void fieldEdited() {
            this.okCallback();
        }
    }
}

