/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Mapping;
import edsim51di.logicdiagram.LogicDiagramInterface;

public abstract class Peripheral {
    private String name;
    private boolean onLogicDiagramLeft;
    private boolean sharingPinsWithKeypad = false;
    Mapping[] dataLineMappings;

    Peripheral(String name, boolean onLogicDiagramLeft) {
        this.name = name;
        this.onLogicDiagramLeft = onLogicDiagramLeft;
    }

    public abstract LogicDiagramInterface[] getLogicDiagramInterfaces();

    public String getName() {
        return this.name;
    }

    public void putOnLogicDiagramLeft(boolean b) {
        this.onLogicDiagramLeft = b;
    }

    public boolean isOnLogicDiagramLeft() {
        return this.onLogicDiagramLeft;
    }

    void setSharingPinsWithKeypad(boolean b) {
        this.sharingPinsWithKeypad = b;
    }

    boolean isSharingPinsWithKeypad() {
        return this.sharingPinsWithKeypad;
    }

    int getPortNumber(double d) {
        return (int)d & 3;
    }

    int getPinNumber(double d) {
        return (int)(d * 10.0 - (double)(this.getPortNumber(d) * 10)) & 7;
    }

    void initDataLineMappings(double[] data, String[] descriptions) {
        this.dataLineMappings = new Mapping[data.length];
        for (int i = 0; i < this.dataLineMappings.length; ++i) {
            this.dataLineMappings[i] = new Mapping(this.getDataLinePortNumber(data, i), this.getDataLinePinNumber(data, i), descriptions[i]);
        }
    }

    void initDataLineMappings(double[] data, String description) {
        this.dataLineMappings = new Mapping[data.length];
        for (int i = 0; i < this.dataLineMappings.length; ++i) {
            this.dataLineMappings[i] = new Mapping(this.getDataLinePortNumber(data, i), this.getDataLinePinNumber(data, i), description + i);
        }
    }

    private int getDataLinePortNumber(double[] data, int number) {
        return this.getPortNumber(data[number]);
    }

    private int getDataLinePinNumber(double[] data, int pinNumber) {
        return this.getPinNumber(data[pinNumber]);
    }
}

