/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.IntelHex;
import edsim51sh.MainPanel;
import edsim51sh.Text;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileHandler {
    private final int ASM_ONLY = 0;
    private final int HEX_ONLY = 1;
    private final int BOTH = 2;
    private String newline = System.getProperty("line.separator");
    private MainPanel sim;

    public FileHandler(MainPanel sim) {
        this.sim = sim;
        if (sim.settings.getLastFileFilterDesc() == null) {
            sim.settings.setLastFileFilterDesc(sim.aff);
        }
    }

    public ReturnedData saveFile(String text) {
        int returnVal;
        int fileType = 0;
        ReturnedData rd = new ReturnedData();
        JFileChooser saveDialog = new JFileChooser();
        this.addFileFilters(saveDialog, false);
        if (this.sim.settings.getLastFilePath() != null) {
            saveDialog.setSelectedFile(new File(this.sim.settings.getLastFilePath()));
        }
        if ((returnVal = saveDialog.showSaveDialog(this.sim)) == 1) {
            rd.success = false;
            rd.message = "";
            return rd;
        }
        if (returnVal == 0) {
            File file = saveDialog.getSelectedFile();
            this.sim.settings.setLastFileFilterDesc(saveDialog.getFileFilter());
            try {
                String message;
                int response;
                if (file == null) {
                    rd.success = false;
                    rd.message = "";
                    return rd;
                }
                FileFilter fileFilter = saveDialog.getFileFilter();
                fileType = fileFilter.getDescription().equals(this.sim.aff.getDescription()) ? 0 : (fileFilter.getDescription().equals(this.sim.hff.getDescription()) ? 1 : 2);
                String fileName = file.getName();
                if (fileName.lastIndexOf(46) == -1 && fileName.lastIndexOf(46) < fileName.length() - 2) {
                    fileName = file.getAbsolutePath().trim();
                    if (fileType == 0 || fileType == 2) {
                        fileName = fileName + ".asm";
                    } else if (fileType == 1) {
                        fileName = fileName + ".hex";
                    }
                    file = new File(fileName);
                }
                this.sim.settings.setLastFilePath(file);
                if (fileType == 0) {
                    int response2;
                    if (file.exists() && (response2 = JOptionPane.showConfirmDialog(saveDialog, "File " + file.getName() + " exists. Overwrite?", "Confirm Overwrite", 0)) == 1) {
                        rd.success = false;
                        rd.message = "";
                        return rd;
                    }
                    rd = this.assemblySave(file, text);
                    this.setFrameTitle(rd.success, file.getName());
                    return rd;
                }
                if (fileType == 1) {
                    int response3;
                    if (file.exists() && (response3 = JOptionPane.showConfirmDialog(saveDialog, "File " + file.getName() + " exists. Overwrite?", "Confirm Overwrite", 0)) == 1) {
                        rd.success = false;
                        rd.message = "";
                        return rd;
                    }
                    rd = this.hexSave(file, saveDialog, true);
                    this.setFrameTitle(rd.success, file.getName());
                    return rd;
                }
                File[] bothFiles = this.getBothFiles(file);
                if ((bothFiles[0].exists() || bothFiles[1].exists()) && (response = JOptionPane.showConfirmDialog(saveDialog, message = bothFiles[0].exists() && bothFiles[1].exists() ? "Files " + bothFiles[0].getName() + " and " + bothFiles[1].getName() + " exist. Overwrite both?" : (bothFiles[0].exists() ? "File " + bothFiles[0].getName() + " exists. Overwrite?" : "File " + bothFiles[1].getName() + " exists. Overwrite?"), "Confirm Overwrite", 0)) == 1) {
                    rd.success = false;
                    rd.message = "";
                    return rd;
                }
                ReturnedData asmRd = this.assemblySave(bothFiles[0], text);
                ReturnedData hexRd = this.hexSave(bothFiles[1], saveDialog, false);
                if (asmRd.success && hexRd.success) {
                    rd.success = true;
                    rd.message = "Files " + bothFiles[0].getName() + " and " + bothFiles[1].getName() + " saved.";
                } else if (asmRd.success) {
                    rd.success = false;
                    rd.message = "Error saving file " + bothFiles[1].getName() + " (only file " + bothFiles[0].getName() + " saved successfully).";
                } else {
                    rd.success = false;
                    rd.message = "Error saving file " + bothFiles[0].getName() + " (only file " + bothFiles[1].getName() + " saved successfully).";
                }
                this.setFrameTitle(asmRd.success, bothFiles[0].getName());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(saveDialog, "Error saving file " + file.getName() + "\n\n" + Text.lessJavaErrorMessage(ex.toString()), "Error Saving File", 0);
                rd.success = false;
                rd.message = "Error saving file.";
                return rd;
            }
        }
        rd.success = false;
        rd.message = "";
        return rd;
    }

    private File[] getBothFiles(File file) {
        File[] files = new File[2];
        String fileName = file.getName().trim().toLowerCase();
        if (fileName.endsWith(".h")) {
            files[1] = file;
            String secondFilePath = this.replaceFilenameExtension(file.getAbsolutePath().trim(), false, false);
            files[0] = new File(secondFilePath);
        } else if (fileName.endsWith(".hex")) {
            files[1] = file;
            String secondFilePath = this.replaceFilenameExtension(file.getAbsolutePath().trim(), false, true);
            files[0] = new File(secondFilePath);
        } else if (fileName.endsWith(".a")) {
            files[0] = file;
            String secondFilePath = this.replaceFilenameExtension(file.getAbsolutePath().trim(), true, false);
            files[1] = new File(secondFilePath);
        } else {
            files[0] = file;
            String secondFilePath = this.replaceFilenameExtension(file.getAbsolutePath().trim(), true, true);
            files[1] = new File(secondFilePath);
        }
        return files;
    }

    private String replaceFilenameExtension(String filePath, boolean isAsmFile, boolean threeLetterExtension) {
        String otherExtension = isAsmFile ? (threeLetterExtension ? ".hex" : ".h") : (threeLetterExtension ? ".asm" : ".a");
        int dotIndex = filePath.lastIndexOf(46);
        return filePath.substring(0, dotIndex) + otherExtension;
    }

    private ReturnedData assemblySave(File file, String text) throws IOException {
        ReturnedData rd = new ReturnedData();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(text.replaceAll("\n", this.newline));
        out.close();
        rd.success = true;
        rd.message = "File " + file.getName() + " saved.";
        return rd;
    }

    private ReturnedData hexSave(File file, JFileChooser saveDialog, boolean withWarning) throws IOException {
        int response;
        ReturnedData rd = new ReturnedData();
        if (this.sim.instructions == null) {
            JOptionPane.showMessageDialog(saveDialog, "Error!\n\nSource code can only be saved in Intel HEX format\nif it has first been assembled without error.\n\nAssemble the source and try again.", "Source not assembled", 0);
            rd.success = false;
            rd.message = "";
            return rd;
        }
        if (withWarning && (response = JOptionPane.showConfirmDialog(saveDialog, "Warning!\n\nWhen saving in Intel HEX format, symbol information\n(labels, assembler directives, etc) is not saved\n- only the machine code is saved.\n\nContinue?", "Confirm HEX Format", 0)) == 1) {
            rd.success = false;
            rd.message = "";
            return rd;
        }
        IntelHex ih = new IntelHex();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        String hex = ih.toIntelHex(this.sim.instructions, this.sim.cpu.memory.codeMemory).replaceAll("\n", this.newline).trim();
        out.write(hex);
        out.close();
        rd.success = true;
        rd.message = "File " + file.getName() + " saved.";
        return rd;
    }

    private void addFileFilters(JFileChooser fileChooser, boolean readFile) {
        String affDesc = this.sim.aff.getDescription();
        String hffDesc = this.sim.hff.getDescription();
        String ahffDesc = this.sim.ahff.getDescription();
        String lastDesc = this.sim.settings.getLastFileFilterDesc();
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        if (readFile) {
            fileChooser.addChoosableFileFilter(this.sim.aff);
            fileChooser.addChoosableFileFilter(this.sim.hff);
            fileChooser.addChoosableFileFilter(this.sim.ahff);
            fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
            if (lastDesc.equals(affDesc)) {
                fileChooser.setFileFilter(this.sim.aff);
            } else if (lastDesc.equals(hffDesc)) {
                fileChooser.setFileFilter(this.sim.hff);
            } else if (lastDesc.equals(ahffDesc)) {
                fileChooser.setFileFilter(this.sim.ahff);
            }
        } else {
            fileChooser.addChoosableFileFilter(this.sim.aff);
            fileChooser.addChoosableFileFilter(this.sim.hff);
            fileChooser.addChoosableFileFilter(this.sim.ahff);
            if (lastDesc.equals(ahffDesc)) {
                fileChooser.setFileFilter(this.sim.ahff);
            } else if (lastDesc.equals(hffDesc)) {
                fileChooser.setFileFilter(this.sim.hff);
            } else {
                fileChooser.setFileFilter(this.sim.aff);
            }
        }
    }

    public ReturnedData readFile() {
        int returnVal;
        ReturnedData rd = new ReturnedData();
        JFileChooser openDialog = new JFileChooser();
        this.addFileFilters(openDialog, true);
        if (this.sim.settings.getLastFilePath() != null) {
            openDialog.setCurrentDirectory(new File(this.sim.settings.getLastFilePath()));
        }
        if ((returnVal = openDialog.showOpenDialog(this.sim)) == 1) {
            rd.success = false;
            rd.message = "";
            return rd;
        }
        if (returnVal == 0) {
            File file = openDialog.getSelectedFile();
            this.sim.settings.setLastFileFilterDesc(openDialog.getFileFilter());
            if (file == null) {
                rd.success = false;
                rd.message = "";
                return rd;
            }
            this.sim.settings.setLastFilePath(file);
            rd = this.readBytes(file, openDialog);
            this.setFrameTitle(rd.success, file.getName());
            return rd;
        }
        rd.success = false;
        rd.message = "";
        return rd;
    }

    private void setFrameTitle(boolean success, String filename) {
        if (success) {
            String title = this.sim.externalFrame.getTitle();
            int barIndex = title.indexOf(124);
            if (barIndex != -1) {
                title = title.substring(0, barIndex).trim();
            }
            title = title + " | " + filename;
            this.sim.externalFrame.setTitle(title);
        }
    }

    private ReturnedData readBytes(File file, JFileChooser openDialog) {
        ReturnedData rd = new ReturnedData();
        boolean isHexFile = true;
        try {
            String line;
            FileReader in = new FileReader(file);
            BufferedReader br = new BufferedReader(in);
            String text = "";
            while ((line = br.readLine()) != null) {
                if (isHexFile && !this.isHexLine(line)) {
                    isHexFile = false;
                }
                text = text + line + "\n";
            }
            in.close();
            if (isHexFile) {
                IntelHex hex = new IntelHex();
                rd.success = hex.readIntelHex(text.trim());
                rd.message = hex.message;
                rd.warning = hex.warning;
                rd.fileContents = hex.dissassembly;
                if (!rd.success) {
                    rd.errorLine = hex.errorLine;
                    rd.fileContents = text;
                }
            } else {
                rd.fileContents = text;
                rd.success = true;
            }
            return rd;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(openDialog, "Error loading file " + file.getName() + "\n\n" + Text.lessJavaErrorMessage(ex.toString()), "Error Loading File", 0);
            rd.success = false;
            rd.message = "Error opening file - " + file.getName() + " may not exist.";
            return rd;
        }
    }

    private boolean isHexLine(String line) {
        line = line.trim();
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ':') continue;
            String s = line.substring(i, i + 1);
            try {
                int temp = Integer.parseInt(s, 16);
                continue;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }

    public class ReturnedData {
        public boolean success;
        public String fileContents = "";
        public String message;
        public String errorLine;
        public String warning;
    }
}

