/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class DisplayCore {
    private final ArrayList<DisplayGlyph> shownGlyphs;
    private final JPanel pane = new JPanel();

    static ImageIcon initGlyphIcon(String string) {
        URL uRL = Button.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        throw new RuntimeException("Could not find " + string);
    }

    DisplayCore(int n, int n2, int n3, int n4, JPanel jPanel, boolean bl) {
        this.pane.setBounds(n, n2, n3, n4);
        if (bl) {
            this.pane.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.pane.setLayout(null);
        jPanel.add(this.pane);
        this.shownGlyphs = new ArrayList();
    }

    JPanel getPane() {
        return this.pane;
    }

    void clear() {
        for (DisplayGlyph displayGlyph : this.shownGlyphs) {
            displayGlyph.hide();
        }
        this.shownGlyphs.clear();
    }

    void addGlyphToShow(DisplayGlyph displayGlyph) {
        this.shownGlyphs.add(displayGlyph);
    }

    void refresh() {
        for (DisplayGlyph displayGlyph : this.shownGlyphs) {
            displayGlyph.show();
        }
    }

    static final class DisplayGlyph {
        private final int x;
        private final int y;
        private final ImageIcon icon;
        private final JPanel parent;
        private JLabel label;

        DisplayGlyph(int n, int n2, ImageIcon imageIcon, JPanel jPanel) {
            this.x = n;
            this.y = n2;
            this.icon = imageIcon;
            this.parent = jPanel;
        }

        void show() {
            if (this.label == null) {
                this.label = new JLabel();
                this.label.setIcon(this.icon);
                this.label.setBounds(this.x, this.y, this.icon.getIconWidth(), this.icon.getIconHeight());
                this.parent.add(this.label);
            }
            this.label.setVisible(true);
        }

        void hide() {
            if (this.label != null) {
                this.label.setVisible(false);
            }
        }
    }
}

