/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.util.ArrayList;
import java.util.List;

public abstract class Option
extends Parameter {
    private boolean isList = false;
    private boolean required = false;
    private char listSeparator = JSAP.DEFAULT_LISTSEPARATOR;
    private StringParser stringParser = null;

    public Option(String id) {
        super(id);
    }

    protected final void internalSetList(boolean isList) {
        this.enforceParameterLock();
        this.isList = isList;
    }

    public final boolean isList() {
        return this.isList;
    }

    protected final void internalSetListSeparator(char listSeparator) {
        this.enforceParameterLock();
        this.listSeparator = listSeparator;
    }

    public final char getListSeparator() {
        return this.listSeparator;
    }

    protected final void internalSetRequired(boolean required) {
        this.enforceParameterLock();
        this.required = required;
    }

    public final boolean required() {
        return this.required;
    }

    protected final void internalSetStringParser(StringParser stringParser) {
        this.enforceParameterLock();
        this.stringParser = stringParser;
    }

    public final StringParser getStringParser() {
        return this.stringParser;
    }

    private void storeParseResult(List result, String argToParse) throws ParseException {
        if (argToParse == null) {
            return;
        }
        Object parseResult = this.getStringParser().parse(argToParse);
        if (parseResult != null) {
            result.add(parseResult);
        }
    }

    @Override
    protected final List parse(String arg) throws ParseException {
        ArrayList result = new ArrayList();
        if (this.getStringParser() == null) {
            boolean wasLocked = this.locked();
            this.setLocked(false);
            this.internalSetStringParser(JSAP.STRING_PARSER);
            this.setLocked(wasLocked);
        }
        if (arg == null || !this.isList()) {
            this.storeParseResult(result, arg);
        } else {
            StringBuffer subarg = new StringBuffer();
            int arglen = arg.length();
            for (int index = 0; index < arglen; ++index) {
                char c = arg.charAt(index);
                if (c == this.getListSeparator()) {
                    this.storeParseResult(result, subarg.toString());
                    subarg.setLength(0);
                    continue;
                }
                subarg.append(c);
                if (index != arglen - 1) continue;
                this.storeParseResult(result, subarg.toString());
            }
        }
        return result;
    }

    protected void register() throws JSAPException {
        StringParser stringParser = this.getStringParser();
        try {
            if (stringParser != null) {
                stringParser.setUp();
            }
        }
        catch (Exception e) {
            throw new JSAPException(e.getMessage(), e);
        }
    }

    protected void unregister() {
        StringParser stringParser = this.getStringParser();
        if (stringParser != null) {
            stringParser.tearDown();
        }
    }
}

