/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import com.google.protobuf.CodedInputStream;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.Alignments;

public class AlignmentTooManyHitsReader {
    private static final Log LOG = LogFactory.getLog(AlignmentTooManyHitsReader.class);
    private Int2IntMap queryIndex2NumHits;
    private Int2IntMap queryIndex2Depth;
    private int alignerThreshold;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlignmentTooManyHitsReader(String basename) throws IOException {
        block8: {
            this.queryIndex2NumHits = new Int2IntAVLTreeMap();
            this.queryIndex2Depth = new Int2IntAVLTreeMap();
            String filename = basename + ".tmh";
            File optionalFile = new File(filename);
            try (InputStream tmhStream = null;){
                if (optionalFile.exists()) {
                    try {
                        tmhStream = new GZIPInputStream(new FileInputStream(optionalFile));
                    }
                    catch (IOException e) {
                        LOG.trace((Object)"falling back to legacy 1.6- uncompressed TMH.");
                        tmhStream = new FileInputStream(optionalFile);
                    }
                    CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)tmhStream);
                    codedInput.setSizeLimit(Integer.MAX_VALUE);
                    Alignments.AlignmentTooManyHits tmh = Alignments.AlignmentTooManyHits.parseFrom(codedInput);
                    this.queryIndex2NumHits.defaultReturnValue(-1);
                    this.queryIndex2Depth.defaultReturnValue(-1);
                    List<Alignments.AmbiguousLocation> hitsList = tmh.getHitsList();
                    for (Alignments.AmbiguousLocation hit : hitsList) {
                        this.queryIndex2NumHits.put(hit.getQueryIndex(), hit.getAtLeastNumberOfHits());
                        if (!hit.hasLengthOfMatch()) continue;
                        this.queryIndex2Depth.put(hit.getQueryIndex(), hit.getLengthOfMatch());
                    }
                    this.alignerThreshold = tmh.getAlignerThreshold();
                    break block8;
                }
                LOG.info((Object)("basename " + optionalFile + " has no 'too many hits' information (" + basename + ".tmh does not exist)." + " Assuming no queries have too many hits."));
            }
        }
    }

    public int getAlignerThreshold() {
        return this.alignerThreshold;
    }

    public final int getNumberOfHits(int queryIndex) {
        assert (!this.closed) : "TMH reader was already closed.";
        return this.queryIndex2NumHits.get(queryIndex);
    }

    public final int getLengthOfMatch(int queryIndex) {
        assert (!this.closed) : "TMH reader was already closed.";
        return this.queryIndex2Depth.get(queryIndex);
    }

    public final IntSet getQueryIndices() {
        assert (!this.closed) : "TMH reader was already closed.";
        return this.queryIndex2NumHits.keySet();
    }

    public boolean isQueryAmbiguous(int queryIndex) {
        assert (!this.closed) : "TMH reader was already closed.";
        return this.queryIndex2NumHits.containsKey(queryIndex);
    }

    public final boolean isQueryAmbiguous(int queryIndex, int k) {
        assert (!this.closed) : "TMH reader was already closed.";
        int atLeastNumberOfHits = this.queryIndex2NumHits.get(queryIndex);
        if (atLeastNumberOfHits == -1) {
            return false;
        }
        if (k >= this.alignerThreshold) {
            return true;
        }
        return atLeastNumberOfHits >= k;
    }

    public final boolean isQueryAmbiguous(int queryIndex, int k, int matchLength) {
        if (matchLength < this.getLengthOfMatch(queryIndex)) {
            return true;
        }
        return this.isQueryAmbiguous(queryIndex, k);
    }

    public void close() {
        this.queryIndex2Depth.clear();
        this.queryIndex2NumHits.clear();
        this.queryIndex2Depth = null;
        this.queryIndex2NumHits = null;
        this.closed = true;
    }
}

