/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.world.grid;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.EncogMath;
import org.encog.ml.world.Action;
import org.encog.ml.world.State;
import org.encog.ml.world.basic.BasicAction;
import org.encog.ml.world.basic.BasicWorld;
import org.encog.ml.world.grid.GridState;

public class GridWorld
extends BasicWorld {
    public static final Action ACTION_NORTH = new BasicAction("NORTH");
    public static final Action ACTION_SOUTH = new BasicAction("SOUTH");
    public static final Action ACTION_EAST = new BasicAction("EAST");
    public static final Action ACTION_WEST = new BasicAction("WEST");
    private GridState[][] state;

    public GridWorld(int rows, int columns) {
        this.addAction(ACTION_NORTH);
        this.addAction(ACTION_SOUTH);
        this.addAction(ACTION_EAST);
        this.addAction(ACTION_WEST);
        this.state = new GridState[rows][columns];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                GridState state = new GridState(this, row, col, false);
                this.addState(state);
                this.state[row][col] = state;
                this.state[row][col].setPolicyValueSize(this.getActions().size());
            }
        }
    }

    public static boolean isStateBlocked(GridState state) {
        return state == null;
    }

    public int getRows() {
        return this.state.length;
    }

    public int getColumns() {
        return this.state[0].length;
    }

    public GridState getState(int row, int column) {
        if (row < 0 || row >= this.getRows()) {
            return null;
        }
        if (column < 0 || column >= this.getColumns()) {
            return null;
        }
        return this.state[row][column];
    }

    public static Action leftOfAction(Action action) {
        if (action == ACTION_NORTH) {
            return ACTION_WEST;
        }
        if (action == ACTION_SOUTH) {
            return ACTION_EAST;
        }
        if (action == ACTION_EAST) {
            return ACTION_NORTH;
        }
        if (action == ACTION_WEST) {
            return ACTION_SOUTH;
        }
        return null;
    }

    public static Action rightOfAction(Action action) {
        if (action == ACTION_NORTH) {
            return ACTION_EAST;
        }
        if (action == ACTION_SOUTH) {
            return ACTION_WEST;
        }
        if (action == ACTION_EAST) {
            return ACTION_SOUTH;
        }
        if (action == ACTION_WEST) {
            return ACTION_NORTH;
        }
        return null;
    }

    public static Action reverseOfAction(Action action) {
        if (action == ACTION_NORTH) {
            return ACTION_SOUTH;
        }
        if (action == ACTION_SOUTH) {
            return ACTION_NORTH;
        }
        if (action == ACTION_EAST) {
            return ACTION_WEST;
        }
        if (action == ACTION_WEST) {
            return ACTION_EAST;
        }
        return null;
    }

    public List<GridState> getAdjacentStates(GridState s) {
        ArrayList<GridState> result = new ArrayList<GridState>();
        GridState northState = this.getState(s.getRow() - 1, s.getColumn());
        GridState southState = this.getState(s.getRow() + 1, s.getColumn());
        GridState eastState = this.getState(s.getRow(), s.getColumn() + 1);
        GridState westState = this.getState(s.getRow(), s.getColumn() - 1);
        if (!GridWorld.isStateBlocked(northState)) {
            result.add(northState);
        }
        if (!GridWorld.isStateBlocked(southState)) {
            result.add(southState);
        }
        if (!GridWorld.isStateBlocked(eastState)) {
            result.add(eastState);
        }
        if (!GridWorld.isStateBlocked(westState)) {
            result.add(westState);
        }
        if (!GridWorld.isStateBlocked(s)) {
            result.add(s);
        }
        return result;
    }

    public static double euclideanDistance(GridState s1, GridState s2) {
        double d = EncogMath.square(s1.getRow() - s2.getRow()) + EncogMath.square(s1.getColumn() - s2.getColumn());
        return Math.sqrt(d);
    }

    public GridState findClosestStateTo(List<GridState> states, GridState goalState) {
        double min = Double.POSITIVE_INFINITY;
        GridState minState = null;
        for (GridState state : states) {
            double d = GridWorld.euclideanDistance(state, goalState);
            if (!(d < min)) continue;
            min = d;
            minState = state;
        }
        return minState;
    }

    public Action determineActionToState(GridState currentState, GridState targetState) {
        int rowDiff = currentState.getRow() - targetState.getRow();
        int colDiff = currentState.getColumn() - targetState.getColumn();
        if (rowDiff == 0 && colDiff == 0) {
            return null;
        }
        if (Math.abs(rowDiff) >= Math.abs(colDiff)) {
            if (rowDiff < 0) {
                return ACTION_SOUTH;
            }
            return ACTION_NORTH;
        }
        if (colDiff < 0) {
            return ACTION_EAST;
        }
        return ACTION_WEST;
    }

    public GridState findClosestStateToGoal(List<GridState> states) {
        double min = Double.POSITIVE_INFINITY;
        GridState minState = null;
        for (State goalState : this.getGoals()) {
            for (GridState state : states) {
                double d = GridWorld.euclideanDistance(state, (GridState)goalState);
                if (!(d < min)) continue;
                min = d;
                minState = state;
            }
        }
        return minState;
    }

    public void setBlocked(int row, int column) {
        GridState state = this.state[row][column];
        this.state[row][column] = null;
        this.getStates().remove(state);
    }
}

