/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.util.ArrayList;
import java.util.List;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Link;
import org.encog.bot.dataunit.DataUnit;

public class WebPage {
    private final List<DataUnit> data = new ArrayList<DataUnit>();
    private final List<DocumentRange> contents = new ArrayList<DocumentRange>();
    private DocumentRange title;

    public final void addContent(DocumentRange span) {
        span.setSource(this);
        this.contents.add(span);
    }

    public final void addDataUnit(DataUnit unit) {
        this.data.add(unit);
    }

    public final DocumentRange find(Class<?> c, int index) {
        int i = index;
        for (DocumentRange span : this.getContents()) {
            if (!span.getClass().getName().equals(c.getName())) continue;
            if (i <= 0) {
                return span;
            }
            --i;
        }
        return null;
    }

    public final Link findLink(String str) {
        for (DocumentRange span : this.getContents()) {
            Link link;
            if (!(span instanceof Link) || !(link = (Link)span).getTextOnly().equals(str)) continue;
            return link;
        }
        return null;
    }

    public final List<DocumentRange> getContents() {
        return this.contents;
    }

    public final List<DataUnit> getData() {
        return this.data;
    }

    public final int getDataSize() {
        return this.data.size();
    }

    public final DataUnit getDataUnit(int i) {
        return this.data.get(i);
    }

    public final DocumentRange getTitle() {
        return this.title;
    }

    public final void setTitle(DocumentRange theTitle) {
        this.title = theTitle;
        this.title.setSource(this);
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        for (DocumentRange span : this.getContents()) {
            result.append(span.toString());
            result.append("\n");
        }
        return result.toString();
    }
}

