/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.wizard.integrity.gui.IntegrityMessagePanel;

public class IntegrityWizard
extends JDialog
implements ActionListener {
    private BibtexDatabase dbase;
    private BasePanel basePanel;
    private JButton closeButton;
    private JButton startButton;
    private IntegrityMessagePanel warnPanel;

    public IntegrityWizard(JabRefFrame frame, BasePanel basePanel) {
        super(frame, "dialog", false);
        this.basePanel = basePanel;
        this.dbase = basePanel.database();
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setResizable(false);
        this.setTitle(Globals.lang("Integrity_check"));
        this.warnPanel = new IntegrityMessagePanel(this.basePanel);
        JPanel buttonPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        con.weightx = 0.0;
        con.insets = new Insets(5, 10, 0, 10);
        con.fill = 2;
        this.startButton = new JButton(Globals.lang("Scan"));
        this.startButton.addActionListener(this);
        this.closeButton = new JButton(Globals.lang("Close"));
        this.closeButton.addActionListener(this);
        con.gridwidth = 0;
        gbl.setConstraints(this.startButton, con);
        buttonPanel.add(this.startButton);
        gbl.setConstraints(this.closeButton, con);
        buttonPanel.add(this.closeButton);
        JEditorPane infoText = null;
        URL infoURL = JabRef.class.getResource(GUIGlobals.getLocaleHelpPath() + "ShortIntegrityCheck.html");
        if (infoURL != null) {
            try {
                infoText = new JEditorPane();
                infoText.setEditable(false);
                infoText.setPreferredSize(new Dimension(220, 60));
                infoText.setMinimumSize(new Dimension(180, 50));
                infoText.setPage(infoURL);
                infoText.setBackground(GUIGlobals.infoField);
                infoText.setBorder(new EtchedBorder(1));
            }
            catch (IOException e) {
                infoText = null;
            }
        }
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        if (infoText != null) {
            content.add((Component)infoText, "First");
        }
        content.add((Component)this.warnPanel, "Center");
        content.add((Component)buttonPanel, "Last");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object sender = e.getSource();
        if (sender == this.closeButton) {
            this.dispose();
        } else if (sender == this.startButton) {
            this.startButton.setEnabled(false);
            Runnable scanWork = new Runnable(){

                @Override
                public void run() {
                    IntegrityWizard.this.warnPanel.updateView(IntegrityWizard.this.dbase);
                }
            };
            SwingUtilities.invokeLater(scanWork);
            this.startButton.setEnabled(true);
        }
    }
}

