/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;

public class UndoableKeyChange
extends AbstractUndoableEdit {
    private String entryId;
    private BibtexDatabase base;
    private String oldValue;
    private String newValue;

    public UndoableKeyChange(BibtexDatabase base, String entryId, String oldValue, String newValue) {
        this.base = base;
        this.entryId = entryId;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change key");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change key");
    }

    @Override
    public void undo() {
        super.undo();
        this.set(this.oldValue);
    }

    @Override
    public void redo() {
        super.redo();
        this.set(this.newValue);
    }

    private void set(String to) {
        this.base.setCiteKeyForEntry(this.entryId, to);
    }
}

