/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.oo.OOBibStyle;

public class StyleSelectDialog {
    public static final String STYLE_FILE_EXTENSION = ".jstyle";
    private JabRefFrame frame;
    private EventList<OOBibStyle> styles;
    private EventList<OOBibStyle> sortedStyles;
    private JDialog diag;
    private JTable table;
    private UIFSplitPane contentPane = new UIFSplitPane(0);
    private EventTableModel tableModel;
    private EventSelectionModel<OOBibStyle> selectionModel;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem edit = new JMenuItem(Globals.lang("Edit"));
    private JRadioButton useDefaultAuthoryear = new JRadioButton(Globals.lang("Default style (author-year citations)"));
    private JRadioButton useDefaultNumerical = new JRadioButton(Globals.lang("Default style (numerical citations)"));
    private JRadioButton chooseDirectly = new JRadioButton(Globals.lang("Choose style file directly") + ":");
    private JRadioButton setDirectory = new JRadioButton(Globals.lang("Choose from a directory") + ":");
    private JTextField directFile = new JTextField();
    private JTextField styleDir = new JTextField();
    private JButton browseDirectFile = new JButton(Globals.lang("Browse"));
    private JButton browseStyleDir = new JButton(Globals.lang("Browse"));
    private JButton showDefaultAuthoryearStyle = new JButton(Globals.lang("View"));
    private JButton showDefaultNumericalStyle = new JButton(Globals.lang("View"));
    PreviewPanel preview;
    private Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private JButton ok = new JButton(Globals.lang("Ok"));
    private JButton cancel = new JButton(Globals.lang("Cancel"));
    private BibtexEntry prevEntry = new BibtexEntry(Util.createNeutralId());
    private boolean okPressed = false;
    private String initSelection;

    public StyleSelectDialog(JabRefFrame frame, String initSelection) {
        this.frame = frame;
        this.setupPrevEntry();
        this.init(initSelection);
    }

    private void init(String initSelection) {
        this.initSelection = initSelection;
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.useDefaultAuthoryear);
        bg.add(this.useDefaultNumerical);
        bg.add(this.chooseDirectly);
        bg.add(this.setDirectory);
        if (Globals.prefs.getBoolean("ooUseDefaultAuthoryearStyle")) {
            this.useDefaultAuthoryear.setSelected(true);
        } else if (Globals.prefs.getBoolean("ooUseDefaultNumericalStyle")) {
            this.useDefaultNumerical.setSelected(true);
        } else if (Globals.prefs.getBoolean("ooChooseStyleDirectly")) {
            this.chooseDirectly.setSelected(true);
        } else {
            this.setDirectory.setSelected(true);
        }
        this.directFile.setText(Globals.prefs.get("ooDirectFile"));
        this.styleDir.setText(Globals.prefs.get("ooStyleDirectory"));
        this.directFile.setEditable(false);
        this.styleDir.setEditable(false);
        this.popup.add(this.edit);
        BrowseAction dfBrowse = new BrowseAction(null, this.directFile, false);
        dfBrowse.setFocusTarget(this.directFile);
        this.browseDirectFile.addActionListener(dfBrowse);
        BrowseAction sdBrowse = new BrowseAction(null, this.styleDir, true);
        sdBrowse.setFocusTarget(this.setDirectory);
        this.browseStyleDir.addActionListener(sdBrowse);
        this.showDefaultAuthoryearStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyleSelectDialog.this.displayDefaultStyle(true);
            }
        });
        this.showDefaultNumericalStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyleSelectDialog.this.displayDefaultStyle(false);
            }
        });
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int i = StyleSelectDialog.this.table.getSelectedRow();
                if (i == -1) {
                    return;
                }
                ExternalFileType type = Globals.prefs.getExternalFileTypeByExt("jstyle");
                String link = ((OOBibStyle)StyleSelectDialog.this.tableModel.getElementAt(i)).getFile().getPath();
                try {
                    if (type != null) {
                        Util.openExternalFileAnyFormat(new MetaData(), link, type);
                    } else {
                        Util.openExternalFileUnknown(StyleSelectDialog.this.frame, null, new MetaData(), link, new UnknownExternalFileType("jstyle"));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.diag = new JDialog(this.frame, Globals.lang("Styles"), true);
        this.styles = new BasicEventList<OOBibStyle>();
        this.sortedStyles = new SortedList<OOBibStyle>(this.styles);
        this.preview = new PreviewPanel(null, new MetaData(), "");
        this.preview.setEntry(this.prevEntry);
        this.tableModel = new EventTableModel<OOBibStyle>(this.sortedStyles, new StyleTableFormat());
        this.table = new JTable(this.tableModel);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(1).setPreferredWidth(200);
        cm.getColumn(2).setPreferredWidth(80);
        this.selectionModel = new EventSelectionModel<OOBibStyle>(this.sortedStyles);
        this.table.setSelectionModel(this.selectionModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StyleSelectDialog.this.tablePopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StyleSelectDialog.this.tablePopup(mouseEvent);
                }
            }
        });
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.styleDir.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.readStyles();
                StyleSelectDialog.this.setDirectory.setSelected(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.readStyles();
                StyleSelectDialog.this.setDirectory.setSelected(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.readStyles();
                StyleSelectDialog.this.setDirectory.setSelected(true);
            }
        });
        this.directFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.chooseDirectly.setSelected(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.chooseDirectly.setSelected(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.chooseDirectly.setSelected(true);
            }
        });
        this.contentPane.setTopComponent(new JScrollPane(this.table));
        this.contentPane.setBottomComponent(this.preview);
        this.readStyles();
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("fill:pref,4dlu,fill:150dlu,4dlu,fill:pref", ""));
        b.append((Component)this.useDefaultAuthoryear, 3);
        b.append(this.showDefaultAuthoryearStyle);
        b.nextLine();
        b.append((Component)this.useDefaultNumerical, 3);
        b.append(this.showDefaultNumericalStyle);
        b.nextLine();
        b.append(this.chooseDirectly);
        b.append(this.directFile);
        b.append(this.browseDirectFile);
        b.nextLine();
        b.append(this.setDirectory);
        b.append(this.styleDir);
        b.append(this.browseStyleDir);
        b.nextLine();
        DefaultFormBuilder b2 = new DefaultFormBuilder(new FormLayout("fill:1dlu:grow", "fill:pref, fill:pref, fill:270dlu:grow"));
        b2.nextLine();
        b2.append(new JLabel("<html>" + Globals.lang("This is the list of available styles. Select the one you want to use.") + "</html>"));
        b2.nextLine();
        b2.append(this.contentPane);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        b2.getPanel().setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        this.diag.add((Component)b.getPanel(), "North");
        this.diag.add((Component)b2.getPanel(), "Center");
        AbstractAction okListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!StyleSelectDialog.this.useDefaultAuthoryear.isSelected() && !StyleSelectDialog.this.useDefaultNumerical.isSelected()) {
                    if (StyleSelectDialog.this.chooseDirectly.isSelected()) {
                        File f = new File(StyleSelectDialog.this.directFile.getText());
                        if (!f.exists()) {
                            JOptionPane.showMessageDialog(StyleSelectDialog.this.diag, Globals.lang("You must select either a valid style file, or use a default style."), Globals.lang("Style selection"), 0);
                            return;
                        }
                    } else if (StyleSelectDialog.this.table.getRowCount() == 0 || StyleSelectDialog.this.table.getSelectedRowCount() == 0) {
                        JOptionPane.showMessageDialog(StyleSelectDialog.this.diag, Globals.lang("You must select either a valid style file, or use a default style."), Globals.lang("Style selection"), 0);
                        return;
                    }
                }
                StyleSelectDialog.this.okPressed = true;
                StyleSelectDialog.this.storeSettings();
                StyleSelectDialog.this.diag.dispose();
            }
        };
        this.ok.addActionListener(okListener);
        AbstractAction cancelListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StyleSelectDialog.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelListener);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)bb.getPanel(), "South");
        ActionMap am = bb.getPanel().getActionMap();
        InputMap im = bb.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelListener);
        im.put(KeyStroke.getKeyStroke("ENTER"), "enterOk");
        am.put("enterOk", okListener);
        this.diag.pack();
        this.diag.setLocationRelativeTo(this.frame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StyleSelectDialog.this.contentPane.setDividerLocation(((StyleSelectDialog)StyleSelectDialog.this).contentPane.getSize().height - 150);
            }
        });
    }

    public void setVisible(boolean visible) {
        this.okPressed = false;
        this.diag.setVisible(visible);
    }

    private void readStyles() {
        this.table.clearSelection();
        this.styles.getReadWriteLock().writeLock().lock();
        this.styles.clear();
        if (this.styleDir.getText().length() > 0) {
            this.addStyles(this.styleDir.getText(), true);
        }
        this.styles.getReadWriteLock().writeLock().unlock();
        this.selectLastUsed();
    }

    private void selectLastUsed() {
        if (this.initSelection != null) {
            boolean found = false;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!((OOBibStyle)this.tableModel.getElementAt(i)).getFile().getPath().equals(this.initSelection)) continue;
                this.table.setRowSelectionInterval(i, i);
                found = true;
                break;
            }
            if (!found && this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        } else if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void addStyles(String dir, boolean recurse) {
        File dirF = new File(dir);
        if (dirF.isDirectory()) {
            File[] files = dirF.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory() && file.getName().endsWith(STYLE_FILE_EXTENSION)) {
                    this.addSingleFile(file);
                    continue;
                }
                if (!file.isDirectory() || !recurse) continue;
                this.addStyles(file.getPath(), recurse);
            }
        } else {
            this.addSingleFile(dirF);
        }
    }

    private void addSingleFile(File file) {
        try {
            OOBibStyle style = new OOBibStyle(file);
            if (style.isValid() && !this.styles.contains(style)) {
                this.styles.add(style);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to read style file: '" + file.getPath() + "'");
            e.printStackTrace();
        }
    }

    public void storeSettings() {
        OOBibStyle selected = this.getSelectedStyle();
        Globals.prefs.putBoolean("ooUseDefaultAuthoryearStyle", this.useDefaultAuthoryear.isSelected());
        Globals.prefs.putBoolean("ooUseDefaultNumericalStyle", this.useDefaultNumerical.isSelected());
        Globals.prefs.putBoolean("ooChooseStyleDirectly", this.chooseDirectly.isSelected());
        Globals.prefs.put("ooDirectFile", this.directFile.getText());
        Globals.prefs.put("ooStyleDirectory", this.styleDir.getText());
        if (this.chooseDirectly.isSelected()) {
            Globals.prefs.put("ooBibliographyStyleFile", this.directFile.getText());
        } else if (this.setDirectory.isSelected() && selected != null) {
            Globals.prefs.put("ooBibliographyStyleFile", selected.getFile().getPath());
        }
    }

    public OOBibStyle getSelectedStyle() {
        if (this.selectionModel.getSelected().size() > 0) {
            return (OOBibStyle)this.selectionModel.getSelected().get(0);
        }
        return null;
    }

    private void setupPrevEntry() {
        this.prevEntry.setField("author", "Smith, Bill and Jones, Bob and Williams, Jeff");
        this.prevEntry.setField("editor", "Taylor, Phil");
        this.prevEntry.setField("title", "Title of the test entry for reference styles");
        this.prevEntry.setField("volume", "34");
        this.prevEntry.setField("year", "2008");
        this.prevEntry.setField("journal", "BibTeX journal");
        this.prevEntry.setField("publisher", "JabRef publishing");
        this.prevEntry.setField("address", "Trondheim");
        this.prevEntry.setField("www", "http://jabref.sf.net");
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    protected void tablePopup(MouseEvent e) {
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void displayDefaultStyle(boolean authoryear) {
        try {
            URL defPath = authoryear ? JabRef.class.getResource("/resource/openoffice/default_authoryear.jstyle") : JabRef.class.getResource("/resource/openoffice/default_numerical.jstyle");
            BufferedReader r = new BufferedReader(new InputStreamReader(defPath.openStream()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = r.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            final JDialog dd = new JDialog(this.diag, Globals.lang("Default style"), true);
            JLabel header = new JLabel("<html>" + Globals.lang("The panel below shows the definition of the default style.") + Globals.lang("If you want to use it as a template for a new style, you can copy the contents into a new .jstyle file") + "</html>");
            header.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            dd.getContentPane().add((Component)header, "North");
            JTextArea ta = new JTextArea(sb.toString());
            ta.setEditable(false);
            JScrollPane sp = new JScrollPane(ta);
            sp.setPreferredSize(new Dimension(700, 500));
            dd.getContentPane().add((Component)sp, "Center");
            JButton ok = new JButton(Globals.lang("Ok"));
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)ok);
            bb.addGlue();
            bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            dd.getContentPane().add((Component)bb.getPanel(), "South");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    dd.dispose();
                }
            });
            dd.pack();
            dd.setLocationRelativeTo(this.diag);
            dd.setVisible(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    class EntrySelectionListener
    implements ListEventListener<OOBibStyle> {
        EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<OOBibStyle> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                OOBibStyle style = (OOBibStyle)listEvent.getSourceList().get(0);
                StyleSelectDialog.this.initSelection = style.getFile().getPath();
                StyleSelectDialog.this.preview.setLayout(style.getReferenceFormat("default"));
                StyleSelectDialog.this.contentPane.setDividerLocation(((StyleSelectDialog)StyleSelectDialog.this).contentPane.getSize().height - 150);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StyleSelectDialog.this.preview.update();
                        StyleSelectDialog.this.preview.scrollRectToVisible(StyleSelectDialog.this.toRect);
                    }
                });
            }
        }
    }

    static class StyleTableFormat
    implements TableFormat<OOBibStyle> {
        StyleTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return Globals.lang("Name");
                }
                case 1: {
                    return Globals.lang("Journals");
                }
                case 2: {
                    return Globals.lang("File");
                }
            }
            return "";
        }

        @Override
        public Object getColumnValue(OOBibStyle style, int i) {
            switch (i) {
                case 0: {
                    return style.getName();
                }
                case 1: {
                    return this.formatJournals(style.getJournals());
                }
                case 2: {
                    return style.getFile().getName();
                }
            }
            return "";
        }

        private String formatJournals(Set<String> journals) {
            StringBuilder sb = new StringBuilder("");
            Iterator<String> i = journals.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }
}

