/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.oo.AdvancedCiteDialog;
import net.sf.jabref.oo.AutoDetectPaths;
import net.sf.jabref.oo.BibtexEntryNotFoundException;
import net.sf.jabref.oo.BstWrapper;
import net.sf.jabref.oo.CitationManager;
import net.sf.jabref.oo.ConnectionLostException;
import net.sf.jabref.oo.OOBibBase;
import net.sf.jabref.oo.OOBibStyle;
import net.sf.jabref.oo.StyleSelectDialog;
import net.sf.jabref.oo.UndefinedCharacterFormatException;
import net.sf.jabref.oo.UndefinedParagraphFormatException;
import net.sf.jabref.plugin.SidePanePlugin;

public class OpenOfficePanel
extends AbstractWorker
implements SidePanePlugin,
PushToApplication {
    public static final String defaultAuthorYearStylePath = "/resource/openoffice/default_authoryear.jstyle";
    public static final String defaultNumericalStylePath = "/resource/openoffice/default_numerical.jstyle";
    public static boolean postLayoutSupported = true;
    OOPanel comp;
    JDialog diag;
    static JButton connect;
    static JButton manualConnect;
    static JButton selectDocument;
    static JButton setStyleFile;
    static JButton pushEntries;
    static JButton pushEntriesInt;
    static JButton pushEntriesEmpty;
    static JButton pushEntriesAdvanced;
    static JButton focus;
    static JButton update;
    static JButton insertFullRef;
    static JButton merge;
    static JButton manageCitations;
    static JButton settingsB;
    static JButton help;
    static JButton test;
    JRadioButton inPar;
    JRadioButton inText;
    private JPanel settings = null;
    private static String styleFile;
    private static OOBibBase ooBase;
    private static JabRefFrame frame;
    private SidePaneManager manager;
    private static OOBibStyle style;
    private static boolean useDefaultAuthoryearStyle;
    private static boolean useDefaultNumericalStyle;
    private StyleSelectDialog styleDialog = null;
    private boolean dialogOkPressed = false;
    private boolean autoDetected = false;
    private String sOffice = null;
    private Throwable connectException = null;
    private static OpenOfficePanel instance;
    private static final Class[] parameters;

    public static OpenOfficePanel getInstance() {
        if (instance == null) {
            instance = new OpenOfficePanel();
        }
        return instance;
    }

    private OpenOfficePanel() {
        ImageIcon connectImage = new ImageIcon(OpenOfficePanel.class.getResource("/images/connect_no.png"));
        connect = new JButton(connectImage);
        manualConnect = new JButton(connectImage);
        connect.setToolTipText(Globals.lang("Connect"));
        manualConnect.setToolTipText(Globals.lang("Manual connect"));
        selectDocument = new JButton(GUIGlobals.getImage("open"));
        selectDocument.setToolTipText(Globals.lang("Select Writer document"));
        update = new JButton(GUIGlobals.getImage("refresh"));
        update.setToolTipText(Globals.lang("Sync OO bibliography"));
        if (Globals.ON_WIN) {
            Globals.prefs.putDefaultValue("ooPath", "C:\\Program Files\\OpenOffice.org 3");
            Globals.prefs.putDefaultValue("ooExecutablePath", "C:\\Program Files\\OpenOffice.org 2.3\\program\\soffice.exe");
            Globals.prefs.putDefaultValue("ooJarsPath", "C:\\Program Files\\OpenOffice.org 2.3\\program\\classes");
        } else if (Globals.ON_MAC) {
            Globals.prefs.putDefaultValue("ooExecutablePath", "/Applications/OpenOffice.org.app/Contents/MacOS/soffice.bin");
            Globals.prefs.putDefaultValue("ooPath", "/Applications/OpenOffice.org.app");
            Globals.prefs.putDefaultValue("ooJarsPath", "/Applications/OpenOffice.org.app/Contents/basis-link");
        } else {
            Globals.prefs.putDefaultValue("ooPath", "/opt/openoffice.org3");
            Globals.prefs.putDefaultValue("ooExecutablePath", "/usr/lib/openoffice/program/soffice");
            Globals.prefs.putDefaultValue("ooJarsPath", "/opt/openoffice.org/basis3.0");
        }
        Globals.prefs.putDefaultValue("connectToOO3", Boolean.TRUE);
        Globals.prefs.putDefaultValue("ooStyleFileLastDir", System.getProperty("user.home"));
        Globals.prefs.putDefaultValue("ooInParCitation", true);
        Globals.prefs.putDefaultValue("syncOOWhenCiting", false);
        Globals.prefs.putDefaultValue("showOOPanel", false);
        Globals.prefs.putDefaultValue("useAllOpenBases", true);
        Globals.prefs.putDefaultValue("ooUseDefaultAuthoryearStyle", true);
        Globals.prefs.putDefaultValue("ooUseDefaultNumericalStyle", false);
        Globals.prefs.putDefaultValue("ooChooseStyleDirectly", false);
        Globals.prefs.putDefaultValue("ooDirectFile", "");
        Globals.prefs.putDefaultValue("ooStyleDirectory", "");
        styleFile = Globals.prefs.get("ooBibliographyStyleFile");
    }

    @Override
    public SidePaneComponent getSidePaneComponent() {
        return this.comp;
    }

    @Override
    public void init(JabRefFrame frame, SidePaneManager manager) {
        OpenOfficePanel.frame = frame;
        this.manager = manager;
        this.comp = new OOPanel(manager, GUIGlobals.getIconUrl("openoffice"), Globals.lang("OpenOffice"));
        try {
            this.initPanel();
            manager.register(this.getName(), this.comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JMenuItem getMenuItem() {
        if (Globals.prefs.getBoolean("showOOPanel")) {
            this.manager.show(this.getName());
        }
        JMenuItem item = new JMenuItem(Globals.lang("OpenOffice/LibreOffice connection"), GUIGlobals.getImage("openoffice"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenOfficePanel.this.manager.show(OpenOfficePanel.this.getName());
            }
        });
        return item;
    }

    @Override
    public String getShortcutKey() {
        return null;
    }

    private void initPanel() throws Exception {
        useDefaultAuthoryearStyle = Globals.prefs.getBoolean("ooUseDefaultAuthoryearStyle");
        useDefaultNumericalStyle = Globals.prefs.getBoolean("ooUseDefaultNumericalStyle");
        AbstractAction al = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenOfficePanel.this.connect(true);
            }
        };
        connect.addActionListener(al);
        manualConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenOfficePanel.this.connect(false);
            }
        });
        selectDocument.setToolTipText(Globals.lang("Select which open Writer document to work on"));
        selectDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ooBase.selectDocument();
                    frame.output(Globals.lang("Connected to document") + ": " + ooBase.getCurrentDocumentTitle());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(frame, ex.getMessage(), Globals.lang("Error"), 0);
                }
            }
        });
        setStyleFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OpenOfficePanel.this.styleDialog == null) {
                    OpenOfficePanel.this.styleDialog = new StyleSelectDialog(frame, styleFile);
                }
                OpenOfficePanel.this.styleDialog.setVisible(true);
                if (OpenOfficePanel.this.styleDialog.isOkPressed()) {
                    useDefaultAuthoryearStyle = Globals.prefs.getBoolean("ooUseDefaultAuthoryearStyle");
                    useDefaultNumericalStyle = Globals.prefs.getBoolean("ooUseDefaultNumericalStyle");
                    styleFile = Globals.prefs.get("ooBibliographyStyleFile");
                    try {
                        OpenOfficePanel.this.readStyleFile();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        pushEntries.setToolTipText(Globals.lang("Cite selected entries"));
        pushEntries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenOfficePanel.this.pushEntries(true, true, false);
            }
        });
        pushEntriesInt.setToolTipText(Globals.lang("Cite selected entries with in-text citation"));
        pushEntriesInt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenOfficePanel.this.pushEntries(false, true, false);
            }
        });
        pushEntriesEmpty.setToolTipText(Globals.lang("Insert a citation without text (the entry will appear in the reference list)"));
        pushEntriesEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenOfficePanel.this.pushEntries(false, false, false);
            }
        });
        pushEntriesAdvanced.setToolTipText(Globals.lang("Cite selected entries with extra information"));
        pushEntriesAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenOfficePanel.this.pushEntries(false, true, true);
            }
        });
        focus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ooBase.setFocus();
            }
        });
        update.setToolTipText(Globals.lang("Ensure that the bibliography is up-to-date"));
        AbstractAction updateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    try {
                        if (style == null) {
                            OpenOfficePanel.this.readStyleFile();
                        } else {
                            style.ensureUpToDate();
                        }
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(frame, Globals.lang("You must select either a valid style file, or use one of the default styles."), Globals.lang("No valid style file defined"), 0);
                        return;
                    }
                    ooBase.updateSortedReferenceMarks();
                    List<BibtexDatabase> databases = OpenOfficePanel.this.getBaseList();
                    List<String> unresolvedKeys = ooBase.refreshCiteMarkers(databases, style);
                    ooBase.rebuildBibTextSection(databases, style);
                    if (unresolvedKeys.size() > 0) {
                        JOptionPane.showMessageDialog(frame, Globals.lang("Your OpenOffice document references the BibTeX key '%0', which could not be found in your current database.", unresolvedKeys.get(0)), Globals.lang("Unable to synchronize bibliography"), 0);
                    }
                }
                catch (UndefinedCharacterFormatException ex) {
                    OpenOfficePanel.this.reportUndefinedCharacterFormat(ex);
                }
                catch (UndefinedParagraphFormatException ex) {
                    OpenOfficePanel.this.reportUndefinedParagraphFormat(ex);
                }
                catch (ConnectionLostException ex) {
                    OpenOfficePanel.this.showConnectionLostErrorMessage();
                }
                catch (BibtexEntryNotFoundException ex) {
                    JOptionPane.showMessageDialog(frame, Globals.lang("Your OpenOffice document references the BibTeX key '%0', which could not be found in your current database.", ex.getBibtexKey()), Globals.lang("Unable to synchronize bibliography"), 0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        update.addActionListener(updateAction);
        insertFullRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    OpenOfficePanel.this.insertFullRefs();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        merge.setToolTipText(Globals.lang("Combine pairs of citations that are separated by spaces only"));
        merge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ooBase.combineCiteMarkers(OpenOfficePanel.this.getBaseList(), style);
                }
                catch (UndefinedCharacterFormatException e) {
                    OpenOfficePanel.this.reportUndefinedCharacterFormat(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        settingsB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.showSettingsPopup();
            }
        });
        help.addActionListener(new HelpAction(Globals.helpDiag, "OpenOfficeIntegration.html"));
        manageCitations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    CitationManager cm = new CitationManager(frame, ooBase);
                    cm.showDialog();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        selectDocument.setEnabled(false);
        pushEntries.setEnabled(false);
        pushEntriesInt.setEnabled(false);
        pushEntriesEmpty.setEnabled(false);
        pushEntriesAdvanced.setEnabled(false);
        focus.setEnabled(false);
        update.setEnabled(false);
        insertFullRef.setEnabled(false);
        merge.setEnabled(false);
        manageCitations.setEnabled(false);
        test.setEnabled(false);
        this.diag = new JDialog((Frame)null, "OpenOffice panel", false);
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("fill:pref:grow", "p,p,p,p,p,p,p,p,p,p"));
        DefaultFormBuilder bb = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow", ""));
        bb.append(connect);
        bb.append(manualConnect);
        bb.append(selectDocument);
        bb.append(update);
        bb.append(help);
        b.append(bb.getPanel());
        b.append(setStyleFile);
        b.append(pushEntries);
        b.append(pushEntriesInt);
        b.append(pushEntriesAdvanced);
        b.append(pushEntriesEmpty);
        b.append(merge);
        b.append(manageCitations);
        b.append(settingsB);
        JPanel content = new JPanel();
        this.comp.setContent(content);
        content.setLayout(new BorderLayout());
        content.add((Component)b.getPanel(), "Center");
        frame.getTabbedPane().getInputMap(2).put(Globals.prefs.getKey("Refresh OO"), "Refresh OO");
        frame.getTabbedPane().getActionMap().put("Refresh OO", updateAction);
    }

    public List<BibtexDatabase> getBaseList() {
        ArrayList<BibtexDatabase> databases = new ArrayList<BibtexDatabase>();
        if (Globals.prefs.getBoolean("useAllOpenBases")) {
            for (int i = 0; i < frame.baseCount(); ++i) {
                databases.add(frame.baseAt(i).database());
            }
        } else {
            databases.add(frame.basePanel().database());
        }
        return databases;
    }

    public void connect(boolean auto) {
        String ooBaseDirectory;
        String unoilDir;
        if (auto) {
            AutoDetectPaths adp = new AutoDetectPaths(this.diag);
            if (adp.runAutodetection()) {
                this.autoDetected = true;
                this.dialogOkPressed = true;
                this.diag.dispose();
            } else if (!adp.cancelled()) {
                JOptionPane.showMessageDialog(this.diag, Globals.lang("Autodetection failed"), Globals.lang("Autodetection failed"), 0);
            }
            if (!this.autoDetected) {
                return;
            }
            unoilDir = Globals.prefs.get("ooUnoilPath");
            ooBaseDirectory = Globals.prefs.get("ooJurtPath");
            this.sOffice = Globals.prefs.get("ooExecutablePath");
        } else {
            this.showConnectDialog();
            if (!this.dialogOkPressed) {
                return;
            }
            String ooPath = Globals.prefs.get("ooPath");
            String ooJars = Globals.prefs.get("ooJarsPath");
            this.sOffice = Globals.prefs.get("ooExecutablePath");
            boolean openOffice3 = true;
            if (Globals.ON_WIN) {
                unoilDir = ooPath + "\\Basis\\program\\classes";
                ooBaseDirectory = ooPath + "\\URE\\java";
                this.sOffice = ooPath + "\\program\\soffice.exe";
            } else if (Globals.ON_MAC) {
                this.sOffice = ooPath + "/Contents/MacOS/soffice.bin";
                ooBaseDirectory = ooPath + "/Contents/basis-link/ure-link/share/java";
                unoilDir = ooPath + "/Contents/basis-link/program/classes";
            } else {
                unoilDir = ooJars + "/program/classes";
                ooBaseDirectory = ooJars + "/ure-link/share/java";
            }
        }
        try {
            File[] jarFiles = new File[]{new File(unoilDir, "unoil.jar"), new File(ooBaseDirectory, "jurt.jar"), new File(ooBaseDirectory, "juh.jar"), new File(ooBaseDirectory, "ridl.jar")};
            URL[] jarList = new URL[jarFiles.length];
            for (int i = 0; i < jarList.length; ++i) {
                if (!jarFiles[i].exists()) {
                    throw new Exception(Globals.lang("File not found") + ": " + jarFiles[i].getPath());
                }
                jarList[i] = jarFiles[i].toURI().toURL();
            }
            OpenOfficePanel.addURL(jarList);
            JDialog progDiag = new AutoDetectPaths(this.diag).showProgressDialog(this.diag, Globals.lang("Connecting"), Globals.lang("Please wait..."), false);
            this.getWorker().run();
            progDiag.dispose();
            this.diag.dispose();
            if (ooBase == null) {
                throw this.connectException;
            }
            if (ooBase.isConnectedToDocument()) {
                frame.output(Globals.lang("Connected to document") + ": " + ooBase.getCurrentDocumentTitle());
            }
            selectDocument.setEnabled(true);
            pushEntries.setEnabled(true);
            pushEntriesInt.setEnabled(true);
            pushEntriesEmpty.setEnabled(true);
            pushEntriesAdvanced.setEnabled(true);
            focus.setEnabled(true);
            update.setEnabled(true);
            insertFullRef.setEnabled(true);
            merge.setEnabled(true);
            manageCitations.setEnabled(true);
            test.setEnabled(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof UnsatisfiedLinkError) {
                JOptionPane.showMessageDialog(frame, Globals.lang("Unable to connect. One possible reason is that JabRef and OpenOffice/LibreOffice are not both running in either 32 bit mode or 64 bit mode."));
            }
            JOptionPane.showMessageDialog(frame, Globals.lang("Could not connect to running OpenOffice.\nMake sure you have installed OpenOffice with Java support.\nIf connecting manually, please verify program and library paths.\n\nError message: " + e.getMessage()));
        }
    }

    @Override
    public void run() {
        try {
            ooBase = new OOBibBase(this.sOffice, true);
        }
        catch (Throwable e) {
            ooBase = null;
            this.connectException = e;
        }
    }

    public void readStyleFile() throws Exception {
        if (useDefaultAuthoryearStyle) {
            URL defPath = JabRef.class.getResource(defaultAuthorYearStylePath);
            InputStreamReader r = new InputStreamReader(defPath.openStream());
            style = new OOBibStyle(r);
        } else if (useDefaultNumericalStyle) {
            URL defPath = JabRef.class.getResource(defaultNumericalStylePath);
            InputStreamReader r = new InputStreamReader(defPath.openStream());
            style = new OOBibStyle(r);
        } else {
            style = new OOBibStyle(new File(styleFile));
        }
    }

    public static void addURL(URL[] u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            for (int i = 0; i < u.length; ++i) {
                method.invoke((Object)sysloader, u[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public void updateConnectionParams(String ooPath, String ooExec, String ooJars, boolean oo3) {
        Globals.prefs.put("ooPath", ooPath);
        Globals.prefs.put("ooExecutablePath", ooExec);
        Globals.prefs.put("ooJarsPath", ooJars);
        Globals.prefs.putBoolean("connectToOO3", oo3);
    }

    public void showConnectDialog() {
        this.dialogOkPressed = false;
        final JDialog diag = new JDialog(frame, Globals.lang("Set connection parameters"), true);
        final JTextField ooPath = new JTextField(30);
        JButton browseOOPath = new JButton(Globals.lang("Browse"));
        ooPath.setText(Globals.prefs.get("ooPath"));
        final JTextField ooExec = new JTextField(30);
        JButton browseOOExec = new JButton(Globals.lang("Browse"));
        browseOOExec.addActionListener(new BrowseAction(null, ooExec, false));
        final JTextField ooJars = new JTextField(30);
        JButton browseOOJars = new JButton(Globals.lang("Browse"));
        browseOOJars.addActionListener(new BrowseAction(null, ooJars, true));
        ooExec.setText(Globals.prefs.get("ooExecutablePath"));
        ooJars.setText(Globals.prefs.get("ooJarsPath"));
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, fill:pref", ""));
        if (Globals.ON_WIN || Globals.ON_MAC) {
            builder.append(Globals.lang("Path to OpenOffice directory"));
            builder.append(ooPath);
            builder.append(browseOOPath);
            builder.nextLine();
        } else {
            builder.append(Globals.lang("Path to OpenOffice executable"));
            builder.append(ooExec);
            builder.append(browseOOExec);
            builder.nextLine();
            builder.append(Globals.lang("Path to OpenOffice library dir"));
            builder.append(ooJars);
            builder.append(browseOOJars);
            builder.nextLine();
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        ActionListener tfListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenOfficePanel.this.updateConnectionParams(ooPath.getText(), ooExec.getText(), ooJars.getText(), true);
                diag.dispose();
            }
        };
        ooPath.addActionListener(tfListener);
        ooExec.addActionListener(tfListener);
        ooJars.addActionListener(tfListener);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenOfficePanel.this.updateConnectionParams(ooPath.getText(), ooExec.getText(), ooJars.getText(), true);
                OpenOfficePanel.this.dialogOkPressed = true;
                diag.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                diag.dispose();
            }
        });
        bb.addGlue();
        bb.addRelatedGap();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        diag.getContentPane().add((Component)builder.getPanel(), "Center");
        diag.getContentPane().add((Component)bb.getPanel(), "South");
        diag.pack();
        diag.setLocationRelativeTo(frame);
        diag.setVisible(true);
    }

    public void pushEntries(boolean inParenthesis, boolean withText, boolean addPageInfo) {
        BibtexEntry[] entries;
        if (!ooBase.isConnectedToDocument()) {
            JOptionPane.showMessageDialog(frame, Globals.lang("Not connected to any Writer document. Please make sure a document is open, and use the 'Select Writer document' button to connect to it."), Globals.lang("Error"), 0);
            return;
        }
        String pageInfo = null;
        if (addPageInfo) {
            AdvancedCiteDialog acd = new AdvancedCiteDialog(frame);
            acd.showDialog();
            if (acd.cancelled()) {
                return;
            }
            if (acd.getPageInfo().length() > 0) {
                pageInfo = acd.getPageInfo();
            }
            inParenthesis = acd.isInParenthesisCite();
        }
        BasePanel panel = frame.basePanel();
        BibtexDatabase database = panel.database();
        if (panel != null && (entries = panel.getSelectedEntries()).length > 0) {
            try {
                if (style == null) {
                    this.readStyleFile();
                }
                ooBase.insertEntry(entries, database, this.getBaseList(), style, inParenthesis, withText, pageInfo, Globals.prefs.getBoolean("syncOOWhenCiting"));
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(frame, Globals.lang("You must select either a valid style file, or use one of the default styles."), Globals.lang("No valid style file defined"), 0);
                return;
            }
            catch (ConnectionLostException ex) {
                this.showConnectionLostErrorMessage();
            }
            catch (UndefinedCharacterFormatException ex) {
                this.reportUndefinedCharacterFormat(ex);
            }
            catch (UndefinedParagraphFormatException ex) {
                this.reportUndefinedParagraphFormat(ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void showConnectionLostErrorMessage() {
        JOptionPane.showMessageDialog(frame, Globals.lang("Connection to OpenOffice has been lost. Please make sure OpenOffice is running, and try to reconnect."), Globals.lang("Connection lost"), 0);
    }

    public void insertFullRefs() {
        try {
            BasePanel panel = frame.basePanel();
            BibtexDatabase database = panel.database();
            LinkedHashMap<BibtexEntry, BibtexDatabase> entries = new LinkedHashMap<BibtexEntry, BibtexDatabase>();
            if (panel != null) {
                BibtexEntry[] e = panel.getSelectedEntries();
                ArrayList el = new ArrayList();
                for (int i = 0; i < e.length; ++i) {
                    entries.put(e[i], database);
                }
                ooBase.insertFullReferenceAtViewCursor(entries, style, "Default");
            }
        }
        catch (UndefinedParagraphFormatException ex) {
            this.reportUndefinedParagraphFormat(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void reportUndefinedParagraphFormat(UndefinedParagraphFormatException ex) {
        JOptionPane.showMessageDialog(frame, "<html>" + Globals.lang("Your style file specifies the paragraph format '%0', which is undefined in your current OpenOffice document.", ex.getFormatName()) + "<br>" + Globals.lang("The paragraph format is controlled by the property 'ReferenceParagraphFormat' or 'ReferenceHeaderParagraphFormat' in the style file.") + "</html>", Globals.lang(""), 0);
    }

    private void reportUndefinedCharacterFormat(UndefinedCharacterFormatException ex) {
        JOptionPane.showMessageDialog(frame, "<html>" + Globals.lang("Your style file specifies the character format '%0', which is undefined in your current OpenOffice document.", ex.getFormatName()) + "<br>" + Globals.lang("The character format is controlled by the citation property 'CitationCharacterFormat' in the style file.") + "</html>", Globals.lang(""), 0);
    }

    public void insertUsingBST() {
        try {
            BasePanel panel = frame.basePanel();
            BibtexDatabase database = panel.database();
            if (panel != null) {
                BibtexEntry[] entries = panel.getSelectedEntries();
                ArrayList<BibtexEntry> el = new ArrayList<BibtexEntry>();
                for (int i = 0; i < entries.length; ++i) {
                    el.add(entries[i]);
                }
                BstWrapper wrapper = new BstWrapper();
                wrapper.loadBstFile(new File("/home/usr/share/texmf-tetex/bibtex/bst/ams/amsalpha.bst"));
                Map<String, String> result = wrapper.processEntries(el, database);
                for (String key : result.keySet()) {
                    System.out.println("Key: " + key);
                    System.out.println("Entry: " + result.get(key));
                    ooBase.insertMarkedUpTextAtViewCursor(result.get(key), "Default");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void showSettingsPopup() {
        JPopupMenu menu = new JPopupMenu();
        final JCheckBoxMenuItem autoSync = new JCheckBoxMenuItem(Globals.lang("Automatically sync bibliography when inserting citations"), Globals.prefs.getBoolean("syncOOWhenCiting"));
        final JRadioButtonMenuItem useActiveBase = new JRadioButtonMenuItem(Globals.lang("Look up BibTeX entries in the active tab only"));
        final JRadioButtonMenuItem useAllBases = new JRadioButtonMenuItem(Globals.lang("Look up BibTeX entries in all open databases"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(useActiveBase);
        bg.add(useAllBases);
        if (Globals.prefs.getBoolean("useAllOpenBases")) {
            useAllBases.setSelected(true);
        } else {
            useActiveBase.setSelected(true);
        }
        autoSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("syncOOWhenCiting", autoSync.isSelected());
            }
        });
        useAllBases.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("useAllOpenBases", useAllBases.isSelected());
            }
        });
        useActiveBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("useAllOpenBases", !useActiveBase.isSelected());
            }
        });
        menu.add(autoSync);
        menu.addSeparator();
        menu.add(useActiveBase);
        menu.add(useAllBases);
        menu.show(settingsB, 0, settingsB.getHeight());
    }

    public void pushEntries(boolean inParenthesis, BibtexEntry[] entries) {
        BibtexDatabase database = frame.basePanel().database();
        if (entries.length > 0) {
            String pageInfo = null;
            AdvancedCiteDialog acd = new AdvancedCiteDialog(frame);
            acd.showDialog();
            if (acd.cancelled()) {
                return;
            }
            if (acd.getPageInfo().length() > 0) {
                pageInfo = acd.getPageInfo();
            }
            inParenthesis = acd.isInParenthesisCite();
            try {
                ooBase.insertEntry(entries, database, this.getBaseList(), style, inParenthesis, true, pageInfo, Globals.prefs.getBoolean("syncOOWhenCiting"));
            }
            catch (ConnectionLostException ex) {
                this.showConnectionLostErrorMessage();
            }
            catch (UndefinedCharacterFormatException ex) {
                this.reportUndefinedCharacterFormat(ex);
            }
            catch (UndefinedParagraphFormatException ex) {
                this.reportUndefinedParagraphFormat(ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return "Push to OpenOffice";
    }

    @Override
    public String getApplicationName() {
        return "OpenOffice";
    }

    @Override
    public String getTooltip() {
        return "Push selection to OpenOffice";
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("openoffice");
    }

    @Override
    public String getKeyStrokeName() {
        return null;
    }

    @Override
    public JPanel getSettingsPanel() {
        return null;
    }

    private void initSettingsPanel() {
        boolean inParen = Globals.prefs.getBoolean("ooInParCitation");
        this.inPar = new JRadioButton(Globals.lang("Use in-parenthesis citation"), inParen);
        this.inText = new JRadioButton(Globals.lang("Use in-text citation"), !inParen);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.inPar);
        bg.add(this.inText);
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout());
        this.settings.add((Component)this.inPar, "North");
        this.settings.add((Component)this.inText, "South");
    }

    @Override
    public void storeSettings() {
        Globals.prefs.putBoolean("ooInParCitation", this.inPar.isSelected());
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] entries, String s, MetaData metaData) {
        if (ooBase == null) {
            this.connect(true);
        }
        if (ooBase != null) {
            try {
                if (style == null) {
                    this.readStyleFile();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(frame, Globals.lang("You must select either a valid style file, or use one of the default styles."), Globals.lang("No valid style file defined"), 0);
                return;
            }
            this.pushEntries(Globals.prefs.getBoolean("ooInParCitation"), entries);
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    static {
        try {
            Layout l = new LayoutHelper(new StringReader("")).getLayoutFromText("net.sf.jabref.export.layout.format.");
            l.setPostFormatter(null);
        }
        catch (NoSuchMethodError ex) {
            postLayoutSupported = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        setStyleFile = new JButton(Globals.lang("Select style"));
        pushEntries = new JButton(Globals.lang("Cite"));
        pushEntriesInt = new JButton(Globals.lang("Cite in-text"));
        pushEntriesEmpty = new JButton(Globals.lang("Insert empty citation"));
        pushEntriesAdvanced = new JButton(Globals.lang("Cite special"));
        focus = new JButton("Focus OO document");
        insertFullRef = new JButton("Insert reference text");
        merge = new JButton(Globals.lang("Merge citations"));
        manageCitations = new JButton(Globals.lang("Manage citations"));
        settingsB = new JButton(Globals.lang("Settings"));
        help = new JButton(GUIGlobals.getImage("help"));
        test = new JButton("Test");
        styleFile = null;
        style = null;
        useDefaultAuthoryearStyle = false;
        useDefaultNumericalStyle = false;
        instance = null;
        parameters = new Class[]{URL.class};
    }

    class OOPanel
    extends SidePaneComponent {
        public OOPanel(SidePaneManager sidePaneManager, URL url, String s) {
            super(sidePaneManager, url, s);
        }

        @Override
        public String getName() {
            return OpenOfficePanel.this.getName();
        }

        @Override
        public void componentClosing() {
            Globals.prefs.putBoolean("showOOPanel", false);
        }

        @Override
        public void componentOpening() {
            Globals.prefs.putBoolean("showOOPanel", true);
        }
    }
}

