/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import net.sf.jabref.Globals;
import net.sf.jabref.OpenFileFilter;

public class FileDialogs {
    public static String[] getMultipleFiles(JFrame owner, File directory, String extension, boolean updateWorkingdirectory) {
        OpenFileFilter off = null;
        if (extension == null) {
            off = new OpenFileFilter();
        } else if (!extension.equals("_non__")) {
            off = new OpenFileFilter(extension);
        }
        Object files = FileDialogs.getNewFileImpl(owner, directory, extension, null, off, 0, updateWorkingdirectory, false, true, null);
        if (files instanceof String[]) {
            return (String[])files;
        }
        if (files != null) {
            return new String[]{(String)files};
        }
        return new String[0];
    }

    public static String getNewFile(JFrame owner, File directory, String extension, int dialogType, boolean updateWorkingDirectory) {
        return FileDialogs.getNewFile(owner, directory, extension, null, dialogType, updateWorkingDirectory, false, null);
    }

    public static String getNewFile(JFrame owner, File directory, String extension, int dialogType, boolean updateWorkingDirectory, JComponent accessory) {
        return FileDialogs.getNewFile(owner, directory, extension, null, dialogType, updateWorkingDirectory, false, accessory);
    }

    public static String getNewFile(JFrame owner, File directory, String extension, String description, int dialogType, boolean updateWorkingDirectory) {
        return FileDialogs.getNewFile(owner, directory, extension, description, dialogType, updateWorkingDirectory, false, null);
    }

    public static String getNewDir(JFrame owner, File directory, String extension, int dialogType, boolean updateWorkingDirectory) {
        return FileDialogs.getNewFile(owner, directory, extension, null, dialogType, updateWorkingDirectory, true, null);
    }

    public static String getNewDir(JFrame owner, File directory, String extension, String description, int dialogType, boolean updateWorkingDirectory) {
        return FileDialogs.getNewFile(owner, directory, extension, description, dialogType, updateWorkingDirectory, true, null);
    }

    public static String getNewFile(JFrame owner, File directory, String extension, String description, int dialogType, boolean updateWorkingDirectory, boolean dirOnly, JComponent accessory) {
        OpenFileFilter off = null;
        if (extension == null) {
            off = new OpenFileFilter();
        } else if (!extension.equals("_non__")) {
            off = new OpenFileFilter(extension);
        }
        return (String)FileDialogs.getNewFileImpl(owner, directory, extension, description, off, dialogType, updateWorkingDirectory, dirOnly, false, accessory);
    }

    public static Object getNewFileImpl(JFrame owner, File directory, String extension, String description, OpenFileFilter off, int dialogType, boolean updateWorkingDirectory, boolean dirOnly, boolean multipleSelection, JComponent accessory) {
        JFileChooser fc;
        if (!dirOnly && Globals.prefs.getBoolean("useNativeFileDialogOnMac")) {
            return FileDialogs.getNewFileForMac(owner, directory, extension, dialogType, updateWorkingDirectory, dirOnly, off);
        }
        try {
            fc = new JFileChooser(directory);
            if (accessory != null) {
                fc.setAccessory(accessory);
            }
        }
        catch (InternalError errl) {
            return FileDialogs.getNewFileForMac(owner, directory, extension, dialogType, updateWorkingDirectory, dirOnly, off);
        }
        if (dirOnly) {
            fc.setFileSelectionMode(1);
        }
        fc.setMultiSelectionEnabled(multipleSelection);
        fc.addChoosableFileFilter(off);
        fc.setDialogType(dialogType);
        int dialogResult = dialogType == 0 ? fc.showOpenDialog(owner) : (dialogType == 1 ? fc.showSaveDialog(owner) : fc.showDialog(owner, description));
        if (dialogResult != 0) {
            return null;
        }
        File selectedFile = fc.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        if (extension != null && dialogType == 1 && fc.getFileFilter() == off && !off.accept(selectedFile)) {
            selectedFile = new File(selectedFile.getPath() + extension.split("[, ]+", 0)[0]);
        }
        if (updateWorkingDirectory) {
            Globals.prefs.put("workingDirectory", selectedFile.getPath());
        }
        if (!multipleSelection) {
            return selectedFile.getAbsolutePath();
        }
        File[] files = fc.getSelectedFiles();
        String[] filenames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            filenames[i] = files[i].getAbsolutePath();
        }
        return filenames;
    }

    public static String getNewFileForMac(JFrame owner, File directory, String extensions, int dialogType, boolean updateWorkingDirectory, boolean dirOnly, FilenameFilter filter) {
        FileDialog fc = new FileDialog(owner);
        if (directory != null) {
            fc.setDirectory(directory.getParent());
        }
        if (dialogType == 0) {
            fc.setMode(0);
        } else {
            fc.setMode(1);
        }
        fc.setVisible(true);
        if (fc.getFile() != null) {
            Globals.prefs.put("workingDirectory", fc.getDirectory() + fc.getFile());
            return fc.getDirectory() + fc.getFile();
        }
        return null;
    }
}

